/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationSubmissionContextPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestApplicationSubmissionContextPBImpl {
    public ApplicationSubmissionContextPBImpl impl;

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testAppTagsLowerCaseConversionDefault(ApplicationSubmissionContextPBImpl applicationSubmissionContextPB) {
        this.initTestApplicationSubmissionContextPBImpl(applicationSubmissionContextPB);
        applicationSubmissionContextPB.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        applicationSubmissionContextPB.getApplicationTags().forEach(s -> Assertions.assertEquals((Object)s, (Object)s.toLowerCase()));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testAppTagsLowerCaseConversionDisabled(ApplicationSubmissionContextPBImpl applicationSubmissionContextPB) {
        this.initTestApplicationSubmissionContextPBImpl(applicationSubmissionContextPB);
        ApplicationSubmissionContextPBImpl.setForceLowerCaseTags((boolean)false);
        applicationSubmissionContextPB.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        applicationSubmissionContextPB.getApplicationTags().forEach(s -> Assertions.assertNotEquals((Object)s, (Object)s.toLowerCase()));
    }

    @MethodSource(value={"data"})
    @ParameterizedTest
    void testAppTagsLowerCaseConversionEnabled(ApplicationSubmissionContextPBImpl applicationSubmissionContextPB) {
        this.initTestApplicationSubmissionContextPBImpl(applicationSubmissionContextPB);
        ApplicationSubmissionContextPBImpl.setForceLowerCaseTags((boolean)true);
        applicationSubmissionContextPB.setApplicationTags((Set)Sets.newHashSet((Object[])new String[]{"ABcd", "efgH"}));
        applicationSubmissionContextPB.getApplicationTags().forEach(s -> Assertions.assertEquals((Object)s, (Object)s.toLowerCase()));
    }

    public static Collection<Object[]> data() {
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        list.add(new Object[]{new ApplicationSubmissionContextPBImpl()});
        list.add(new Object[]{new ApplicationSubmissionContextPBImpl(YarnProtos.ApplicationSubmissionContextProto.newBuilder().build())});
        return list;
    }

    public void initTestApplicationSubmissionContextPBImpl(ApplicationSubmissionContextPBImpl applicationSubmissionContextPB) {
        this.impl = applicationSubmissionContextPB;
    }
}

