/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.TestResourceUtils;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestResourcePBImpl {
    @BeforeEach
    public void setup() throws Exception {
        ResourceUtils.resetResourceTypes();
        String resourceTypesFile = "resource-types-5.xml";
        YarnConfiguration conf = new YarnConfiguration();
        TestResourceUtils.setupResourceTypes((Configuration)conf, resourceTypesFile);
    }

    @AfterEach
    public void teardown() {
        YarnConfiguration conf = new YarnConfiguration();
        File source = new File(conf.getClassLoader().getResource("resource-types-5.xml").getFile());
        File dest = new File(source.getParent(), "resource-types.xml");
        if (dest.exists()) {
            dest.delete();
        }
    }

    @Test
    void testEmptyResourcePBInit() throws Exception {
        ResourcePBImpl res = new ResourcePBImpl();
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)res.getMemorySize());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceInformation.MEMORY_MB.getUnits(), (Object)res.getResourceInformation(ResourceInformation.MEMORY_MB.getName()).getUnits());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceInformation.VCORES.getUnits(), (Object)res.getResourceInformation(ResourceInformation.VCORES.getName()).getUnits());
    }

    @Test
    void testResourcePBInitFromOldPB() throws Exception {
        YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).build();
        ResourcePBImpl res = new ResourcePBImpl(proto);
        org.junit.jupiter.api.Assertions.assertEquals((long)1024L, (long)res.getMemorySize());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)res.getVirtualCores());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceInformation.MEMORY_MB.getUnits(), (Object)res.getResourceInformation(ResourceInformation.MEMORY_MB.getName()).getUnits());
        org.junit.jupiter.api.Assertions.assertEquals((Object)ResourceInformation.VCORES.getUnits(), (Object)res.getResourceInformation(ResourceInformation.VCORES.getName()).getUnits());
    }

    @Test
    void testGetMemory() {
        ResourcePBImpl res = new ResourcePBImpl();
        long memorySize = 0x80000000L;
        res.setMemorySize(memorySize);
        org.junit.jupiter.api.Assertions.assertEquals((long)memorySize, (long)res.getMemorySize(), (String)"No need to cast if both are long");
        org.junit.jupiter.api.Assertions.assertEquals((int)Integer.MAX_VALUE, (int)res.getMemory(), (String)"Cast to Integer.MAX_VALUE if the long is greater than Integer.MAX_VALUE");
    }

    @Test
    void testGetVirtualCores() {
        ResourcePBImpl res = new ResourcePBImpl();
        long vcores = 0x80000000L;
        res.getResourceInformation("vcores").setValue(vcores);
        org.junit.jupiter.api.Assertions.assertEquals((long)vcores, (long)res.getResourceInformation("vcores").getValue(), (String)"No need to cast if both are long");
        org.junit.jupiter.api.Assertions.assertEquals((int)Integer.MAX_VALUE, (int)res.getVirtualCores(), (String)"Cast to Integer.MAX_VALUE if the long is greater than Integer.MAX_VALUE");
    }

    @Test
    void testResourcePBWithExtraResources() throws Exception {
        YarnProtos.ResourceInformationProto riProto = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("resource1").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(4L).setUnits("T").setKey("resource1").build();
        YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto).build();
        ResourcePBImpl res = new ResourcePBImpl(proto);
        org.junit.jupiter.api.Assertions.assertEquals((long)4000L, (long)res.getResourceInformation("resource1").getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"G", (Object)res.getResourceInformation("resource1").getUnits());
        YarnProtos.ResourceInformationProto riProto1 = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("resource2").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(4L).setUnits("M").setKey("resource2").build();
        YarnProtos.ResourceProto proto1 = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto1).build();
        ResourcePBImpl res1 = new ResourcePBImpl(proto1);
        org.junit.jupiter.api.Assertions.assertEquals((long)4000000000L, (long)res1.getResourceInformation("resource2").getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"m", (Object)res1.getResourceInformation("resource2").getUnits());
        YarnProtos.ResourceInformationProto riProto2 = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("resource1").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(3L).setUnits("M").setKey("resource1").build();
        YarnProtos.ResourceProto proto2 = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto2).build();
        ResourcePBImpl res2 = new ResourcePBImpl(proto2);
        org.junit.jupiter.api.Assertions.assertEquals((long)0L, (long)res2.getResourceInformation("resource1").getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"G", (Object)res2.getResourceInformation("resource1").getUnits());
    }

    @Test
    void testResourceTags() {
        YarnProtos.ResourceInformationProto riProto = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("yarn.io/test-volume").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(10L).setUnits("G").setKey("yarn.io/test-volume").addTags("tag_A").addTags("tag_B").addTags("tag_C").build();
        YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto).build();
        ResourcePBImpl res = new ResourcePBImpl(proto);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)res.getResourceInformation("yarn.io/test-volume"));
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)res.getResourceInformation("yarn.io/test-volume").getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"G", (Object)res.getResourceInformation("yarn.io/test-volume").getUnits());
        org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)res.getResourceInformation("yarn.io/test-volume").getTags().size());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)res.getResourceInformation("yarn.io/test-volume").getTags().isEmpty());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)res.getResourceInformation("yarn.io/test-volume").getAttributes().isEmpty());
        boolean protoConvertExpected = false;
        YarnProtos.ResourceProto protoFormat = ProtoUtils.convertToProtoFormat((Resource)res);
        for (YarnProtos.ResourceInformationProto pf : protoFormat.getResourceValueMapList()) {
            if (!pf.getKey().equals("yarn.io/test-volume")) continue;
            protoConvertExpected = pf.getAttributesCount() == 0 && pf.getTagsCount() == 3;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)protoConvertExpected, (String)"Expecting resource's protobuf message contains 0 attributes and 3 tags");
    }

    @Test
    void testResourceAttributes() {
        YarnProtos.ResourceInformationProto riProto = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("yarn.io/test-volume").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(10L).setUnits("G").setKey("yarn.io/test-volume").addAttributes(YarnProtos.StringStringMapProto.newBuilder().setKey("driver").setValue("test-driver").build()).addAttributes(YarnProtos.StringStringMapProto.newBuilder().setKey("mount").setValue("/mnt/data").build()).build();
        YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto).build();
        ResourcePBImpl res = new ResourcePBImpl(proto);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)res.getResourceInformation("yarn.io/test-volume"));
        org.junit.jupiter.api.Assertions.assertEquals((long)10L, (long)res.getResourceInformation("yarn.io/test-volume").getValue());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"G", (Object)res.getResourceInformation("yarn.io/test-volume").getUnits());
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)res.getResourceInformation("yarn.io/test-volume").getAttributes().size());
        org.junit.jupiter.api.Assertions.assertTrue((boolean)res.getResourceInformation("yarn.io/test-volume").getTags().isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)res.getResourceInformation("yarn.io/test-volume").getAttributes().isEmpty());
        boolean protoConvertExpected = false;
        YarnProtos.ResourceProto protoFormat = ProtoUtils.convertToProtoFormat((Resource)res);
        for (YarnProtos.ResourceInformationProto pf : protoFormat.getResourceValueMapList()) {
            if (!pf.getKey().equals("yarn.io/test-volume")) continue;
            protoConvertExpected = pf.getAttributesCount() == 2 && pf.getTagsCount() == 0;
        }
        org.junit.jupiter.api.Assertions.assertTrue((boolean)protoConvertExpected, (String)"Expecting resource's protobuf message contains 2 attributes and 0 tags");
    }

    @Test
    void testParsingResourceTags() {
        ResourceInformation info = (ResourceInformation)ResourceUtils.getResourceTypes().get("resource3");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)info.getAttributes().isEmpty());
        org.junit.jupiter.api.Assertions.assertFalse((boolean)info.getTags().isEmpty());
        Assertions.assertThat((Iterable)info.getTags()).hasSize(2);
        info.getTags().remove("resource3_tag_1");
        info.getTags().remove("resource3_tag_2");
        org.junit.jupiter.api.Assertions.assertTrue((boolean)info.getTags().isEmpty());
    }
}

