/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp.view;

import com.google.inject.Injector;
import java.io.PrintWriter;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.hamlet2.Hamlet;
import org.apache.hadoop.yarn.webapp.test.WebAppTests;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHtmlPage {
    @Test
    void testUsual() {
        Injector injector = WebAppTests.testPage(TestView.class);
        PrintWriter out = (PrintWriter)injector.getInstance(PrintWriter.class);
        ((PrintWriter)Mockito.verify((Object)out)).print(" http-equiv=\"X-UA-Compatible\"");
        ((PrintWriter)Mockito.verify((Object)out)).print(" content=\"IE=8\"");
        ((PrintWriter)Mockito.verify((Object)out)).print(" http-equiv=\"Content-type\"");
        ((PrintWriter)Mockito.verify((Object)out)).print(String.format(" content=\"%s\"", "text/html; charset=UTF-8"));
        ((PrintWriter)Mockito.verify((Object)out)).print("test");
        ((PrintWriter)Mockito.verify((Object)out)).print(" id=\"testid\"");
        ((PrintWriter)Mockito.verify((Object)out)).print("test note");
    }

    @Test
    void testShort() {
        Assertions.assertThrows(WebAppException.class, () -> WebAppTests.testPage(ShortView.class));
    }

    public static class ShortView
    extends HtmlPage {
        public void render(Hamlet.HTML<HtmlPage.__> html) {
            html.title("short test").p().__(new Object[]{"should throw"});
        }
    }

    public static class TestView
    extends HtmlPage {
        public void render(Hamlet.HTML<HtmlPage.__> html) {
            ((Hamlet.HTML)html.title("test").p("#testid").__(new Object[]{"test note"}).__()).__();
        }
    }
}

