/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.nativeio.NativeIO;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.TestContainerId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.util.Times;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAggregatedLogFormat {
    private static final File testWorkDir = new File("target", "TestAggregatedLogFormat");
    private static final FileSystem fs;
    private static final char filler = 'x';
    private static final Logger LOG;

    @BeforeEach
    @AfterEach
    public void cleanupTestDir() throws Exception {
        Path workDirPath = new Path(testWorkDir.getAbsolutePath());
        LOG.info("Cleaning test directory [" + workDirPath + "]");
        fs.delete(workDirPath, true);
    }

    @Test
    void testForCorruptedAggregatedLogs() throws Exception {
        AggregatedLogFormat.LogKey rLogKey;
        AggregatedLogFormat.LogReader logReader;
        Path remoteAppLogFile;
        Configuration conf;
        block4: {
            conf = new Configuration();
            File workDir = new File(testWorkDir, "testReadAcontainerLogs1");
            remoteAppLogFile = new Path(workDir.getAbsolutePath(), "aggregatedLogFile");
            Path srcFileRoot = new Path(workDir.getAbsolutePath(), "srcFiles");
            ContainerId testContainerId = TestContainerId.newContainerId(1, 1, 1L, 1L);
            Path t = new Path(srcFileRoot, testContainerId.getApplicationAttemptId().getApplicationId().toString());
            Path srcFilePath = new Path(t, testContainerId.toString());
            long numChars = 950000L;
            this.writeSrcFileAndALog(srcFilePath, "stdout", numChars, remoteAppLogFile, srcFileRoot, testContainerId);
            logReader = new AggregatedLogFormat.LogReader(conf, remoteAppLogFile);
            rLogKey = new AggregatedLogFormat.LogKey();
            DataInputStream dis = logReader.next(rLogKey);
            StringWriter writer = new StringWriter();
            try {
                AggregatedLogFormat.LogReader.readAcontainerLogs((DataInputStream)dis, (Writer)writer);
            }
            catch (Exception e) {
                if (!e.toString().contains("NumberFormatException")) break block4;
                Assertions.fail((String)"Aggregated logs are corrupted.");
            }
        }
        URI logUri = URI.create("file:///" + remoteAppLogFile.toUri().toString());
        Files.write(Paths.get(logUri), "corrupt_text".getBytes(), StandardOpenOption.APPEND);
        try {
            logReader = new AggregatedLogFormat.LogReader(conf, remoteAppLogFile);
            Assertions.fail((String)"Expect IOException from reading corrupt aggregated logs.");
        }
        catch (IOException ioe) {
            DataInputStream dIS = logReader.next(rLogKey);
            Assertions.assertNull((Object)dIS, (String)"Input stream not available for reading");
        }
    }

    private void writeSrcFileAndALog(Path srcFilePath, String fileName, final long length, Path remoteAppLogFile, Path srcFileRoot, ContainerId testContainerId) throws Exception {
        File dir = new File(srcFilePath.toString());
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create directory : " + dir);
        }
        File outputFile = new File(new File(srcFilePath.toString()), fileName);
        FileOutputStream os = new FileOutputStream(outputFile);
        final OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF8");
        int ch = 120;
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        try (AggregatedLogFormat.LogWriter logWriter = new AggregatedLogFormat.LogWriter();){
            logWriter.initialize(new Configuration(), remoteAppLogFile, ugi);
            AggregatedLogFormat.LogKey logKey = new AggregatedLogFormat.LogKey(testContainerId);
            AggregatedLogFormat.LogValue logValue = (AggregatedLogFormat.LogValue)Mockito.spy((Object)new AggregatedLogFormat.LogValue(Collections.singletonList(srcFileRoot.toString()), testContainerId, ugi.getShortUserName()));
            final CountDownLatch latch = new CountDownLatch(1);
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        int i = 0;
                        while ((long)i < length / 3L) {
                            osw.write(120);
                            ++i;
                        }
                        latch.countDown();
                        i = 0;
                        while ((long)i < 2L * length / 3L) {
                            osw.write(120);
                            ++i;
                        }
                        osw.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            latch.await();
            logWriter.append(logKey, logValue);
        }
    }

    @Test
    void testReadAcontainerLogs1() throws Exception {
        this.testReadAcontainerLog(true);
        this.testReadAcontainerLog(false);
    }

    private void testReadAcontainerLog(boolean logUploadedTime) throws Exception {
        Configuration conf = new Configuration();
        File workDir = new File(testWorkDir, "testReadAcontainerLogs1");
        Path remoteAppLogFile = new Path(workDir.getAbsolutePath(), "aggregatedLogFile");
        Path srcFileRoot = new Path(workDir.getAbsolutePath(), "srcFiles");
        ContainerId testContainerId = TestContainerId.newContainerId(1, 1, 1L, 1L);
        Path t = new Path(srcFileRoot, testContainerId.getApplicationAttemptId().getApplicationId().toString());
        Path srcFilePath = new Path(t, testContainerId.toString());
        int numChars = 80000;
        Path subDir = new Path(srcFilePath, "subDir");
        fs.mkdirs(subDir);
        this.writeSrcFile(subDir, "logs", numChars);
        this.writeSrcFile(srcFilePath, "stderr", numChars);
        this.writeSrcFile(srcFilePath, "stdout", numChars);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        try (AggregatedLogFormat.LogWriter logWriter = new AggregatedLogFormat.LogWriter();){
            logWriter.initialize(conf, remoteAppLogFile, ugi);
            AggregatedLogFormat.LogKey logKey = new AggregatedLogFormat.LogKey(testContainerId);
            AggregatedLogFormat.LogValue logValue = new AggregatedLogFormat.LogValue(Collections.singletonList(srcFileRoot.toString()), testContainerId, ugi.getShortUserName());
            AggregatedLogFormat.LogValue spyLogValue = (AggregatedLogFormat.LogValue)Mockito.spy((Object)logValue);
            File errorFile = new File(new Path(srcFilePath, "stderr").toString());
            ((AggregatedLogFormat.LogValue)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Mock can not open FileInputStream")}).when((Object)spyLogValue)).secureOpenFile(errorFile);
            logWriter.append(logKey, spyLogValue);
        }
        FileStatus fsStatus = fs.getFileStatus(remoteAppLogFile);
        Assertions.assertEquals((Object)FsPermission.createImmutable((short)416), (Object)fsStatus.getPermission(), (String)"permissions on log aggregation file are wrong");
        AggregatedLogFormat.LogReader logReader = new AggregatedLogFormat.LogReader(conf, remoteAppLogFile);
        AggregatedLogFormat.LogKey rLogKey = new AggregatedLogFormat.LogKey();
        DataInputStream dis = logReader.next(rLogKey);
        StringWriter writer = new StringWriter();
        if (logUploadedTime) {
            AggregatedLogFormat.LogReader.readAcontainerLogs((DataInputStream)dis, (Writer)writer, (long)System.currentTimeMillis());
        } else {
            AggregatedLogFormat.LogReader.readAcontainerLogs((DataInputStream)dis, (Writer)writer);
        }
        String s = ((Object)writer).toString();
        int expectedLength = "LogType:stdout".length() + (logUploadedTime ? (System.lineSeparator() + "Log Upload Time:" + Times.format((long)System.currentTimeMillis())).length() : 0) + (System.lineSeparator() + "LogLength:" + numChars).length() + (System.lineSeparator() + "Log Contents:" + System.lineSeparator()).length() + numChars + "\n".length() + ("End of LogType:stdout" + System.lineSeparator() + System.lineSeparator()).length();
        Assertions.assertTrue((boolean)s.contains("LogType:stdout"), (String)"LogType not matched");
        Assertions.assertTrue((!s.contains("LogType:stderr") ? 1 : 0) != 0, (String)"log file:stderr should not be aggregated.");
        Assertions.assertTrue((!s.contains("LogType:logs") ? 1 : 0) != 0, (String)"log file:logs should not be aggregated.");
        Assertions.assertTrue((boolean)s.contains("LogLength:" + numChars), (String)"LogLength not matched");
        Assertions.assertTrue((boolean)s.contains("Log Contents"), (String)"Log Contents not matched");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numChars; ++i) {
            sb.append('x');
        }
        String expectedContent = sb.toString();
        Assertions.assertTrue((boolean)s.contains(expectedContent), (String)"Log content incorrect");
        Assertions.assertEquals((int)expectedLength, (int)s.length());
    }

    @Test
    void testZeroLengthLog() throws IOException {
        Configuration conf = new Configuration();
        File workDir = new File(testWorkDir, "testZeroLength");
        Path remoteAppLogFile = new Path(workDir.getAbsolutePath(), "aggregatedLogFile");
        Path srcFileRoot = new Path(workDir.getAbsolutePath(), "srcFiles");
        ContainerId testContainerId = TestContainerId.newContainerId(1, 1, 1L, 1L);
        Path t = new Path(srcFileRoot, testContainerId.getApplicationAttemptId().getApplicationId().toString());
        Path srcFilePath = new Path(t, testContainerId.toString());
        this.writeSrcFile(srcFilePath, "stdout", 0L);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        try (AggregatedLogFormat.LogWriter logWriter = new AggregatedLogFormat.LogWriter();){
            logWriter.initialize(conf, remoteAppLogFile, ugi);
            AggregatedLogFormat.LogKey logKey = new AggregatedLogFormat.LogKey(testContainerId);
            AggregatedLogFormat.LogValue logValue = new AggregatedLogFormat.LogValue(Collections.singletonList(srcFileRoot.toString()), testContainerId, ugi.getShortUserName());
            logWriter.append(logKey, logValue);
        }
        AggregatedLogFormat.LogReader logReader = new AggregatedLogFormat.LogReader(conf, remoteAppLogFile);
        AggregatedLogFormat.LogKey rLogKey = new AggregatedLogFormat.LogKey();
        DataInputStream dis = logReader.next(rLogKey);
        StringWriter writer = new StringWriter();
        AggregatedLogFormat.LogReader.readAcontainerLogs((DataInputStream)dis, (Writer)writer);
        Assertions.assertEquals((Object)"LogType:stdout\nLogLength:0\nLog Contents:\n\nEnd of LogType:stdout\n\n", (Object)((Object)writer).toString());
    }

    @Test
    @Timeout(value=10000L)
    void testContainerLogsFileAccess() throws IOException {
        String line;
        Assumptions.assumeTrue((boolean)NativeIO.isAvailable());
        Configuration conf = new Configuration();
        conf.set("hadoop.security.authentication", "kerberos");
        UserGroupInformation.setConfiguration((Configuration)conf);
        File workDir = new File(testWorkDir, "testContainerLogsFileAccess1");
        Path remoteAppLogFile = new Path(workDir.getAbsolutePath(), "aggregatedLogFile");
        Path srcFileRoot = new Path(workDir.getAbsolutePath(), "srcFiles");
        String data = "Log File content for container : ";
        ApplicationId applicationId = ApplicationId.newInstance((long)1L, (int)1);
        ApplicationAttemptId applicationAttemptId = ApplicationAttemptId.newInstance((ApplicationId)applicationId, (int)1);
        ContainerId testContainerId1 = ContainerId.newContainerId((ApplicationAttemptId)applicationAttemptId, (long)1L);
        Path appDir = new Path(srcFileRoot, testContainerId1.getApplicationAttemptId().getApplicationId().toString());
        Path srcFilePath1 = new Path(appDir, testContainerId1.toString());
        String stdout = "stdout";
        String stderr = "stderr";
        this.writeSrcFile(srcFilePath1, stdout, data + testContainerId1.toString() + stdout);
        this.writeSrcFile(srcFilePath1, stderr, data + testContainerId1.toString() + stderr);
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        try (AggregatedLogFormat.LogWriter logWriter = new AggregatedLogFormat.LogWriter();){
            logWriter.initialize(conf, remoteAppLogFile, ugi);
            AggregatedLogFormat.LogKey logKey = new AggregatedLogFormat.LogKey(testContainerId1);
            String randomUser = "randomUser";
            AggregatedLogFormat.LogValue logValue = (AggregatedLogFormat.LogValue)Mockito.spy((Object)new AggregatedLogFormat.LogValue(Collections.singletonList(srcFileRoot.toString()), testContainerId1, randomUser));
            Mockito.when((Object)logValue.getUser()).thenReturn((Object)randomUser).thenReturn((Object)ugi.getShortUserName());
            logWriter.append(logKey, logValue);
        }
        BufferedReader in = new BufferedReader(new FileReader(new File(remoteAppLogFile.toUri().getRawPath())));
        StringBuffer sb = new StringBuffer("");
        while ((line = in.readLine()) != null) {
            LOG.info(line);
            sb.append(line);
        }
        line = sb.toString();
        String expectedOwner = ugi.getShortUserName();
        if (Path.WINDOWS) {
            String adminsGroupString = "Administrators";
            if (Arrays.asList(ugi.getGroupNames()).contains("Administrators")) {
                expectedOwner = "Administrators";
            }
        }
        String stdoutFile1 = StringUtils.join((CharSequence)File.separator, Arrays.asList(workDir.getAbsolutePath(), "srcFiles", testContainerId1.getApplicationAttemptId().getApplicationId().toString(), testContainerId1.toString(), stderr));
        String stdoutFile2 = StringUtils.join((CharSequence)File.separator, Arrays.asList(workDir.getAbsolutePath(), "srcFiles", testContainerId1.getApplicationAttemptId().getApplicationId().toString(), testContainerId1.toString(), stdout));
        String message2 = "Owner '" + expectedOwner + "' for path " + stdoutFile2 + " did not match expected owner '" + ugi.getShortUserName() + "'";
        Assertions.assertFalse((boolean)line.contains(message2));
        Assertions.assertFalse((boolean)line.contains(data + testContainerId1.toString() + stderr));
        Assertions.assertTrue((boolean)line.contains(data + testContainerId1.toString() + stdout));
    }

    private void writeSrcFile(Path srcFilePath, String fileName, long length) throws IOException {
        OutputStreamWriter osw = this.getOutputStreamWriter(srcFilePath, fileName);
        int ch = 120;
        int i = 0;
        while ((long)i < length) {
            osw.write(ch);
            ++i;
        }
        osw.close();
    }

    private void writeSrcFile(Path srcFilePath, String fileName, String data) throws IOException {
        OutputStreamWriter osw = this.getOutputStreamWriter(srcFilePath, fileName);
        osw.write(data);
        osw.close();
    }

    private OutputStreamWriter getOutputStreamWriter(Path srcFilePath, String fileName) throws IOException, FileNotFoundException, UnsupportedEncodingException {
        File dir = new File(srcFilePath.toString());
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Unable to create directory : " + dir);
        }
        File outputFile = new File(new File(srcFilePath.toString()), fileName);
        FileOutputStream os = new FileOutputStream(outputFile);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, "UTF8");
        return osw;
    }

    static {
        LOG = LoggerFactory.getLogger(TestAggregatedLogFormat.class);
        try {
            fs = FileSystem.get((Configuration)new Configuration());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

