/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.Range;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.apache.hadoop.util.Lists;
import org.apache.hadoop.util.Sets;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.api.resource.PlacementConstraints;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePBImplRecordsTest {
    private static final Logger LOG = LoggerFactory.getLogger(BasePBImplRecordsTest.class);
    protected static HashMap<Type, Object> typeValueCache = new HashMap();
    protected static HashMap<Type, List<String>> excludedPropertiesMap = new HashMap();
    private static Random rand = new Random();
    private static byte[] bytes = new byte[]{49, 50, 51, 52};

    private static Object genTypeValue(Type type) {
        Object ret = typeValueCache.get(type);
        if (ret != null) {
            return ret;
        }
        if (type.equals(Boolean.TYPE)) {
            return rand.nextBoolean();
        }
        if (type.equals(Byte.TYPE)) {
            return bytes[rand.nextInt(4)];
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return rand.nextInt(1000000);
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return (long)rand.nextInt(1000000);
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(rand.nextFloat());
        }
        if (type.equals(Double.TYPE)) {
            return rand.nextDouble();
        }
        if (type.equals(String.class)) {
            return String.format("%c%c%c", 97 + rand.nextInt(26), 97 + rand.nextInt(26), 97 + rand.nextInt(26));
        }
        if (type.equals(Float.class)) {
            return Float.valueOf(rand.nextFloat());
        }
        if (type.equals(Text.class)) {
            return new Text('a' + String.valueOf(rand.nextInt(1000000)));
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                Class<?> compClass = clazz.getComponentType();
                if (compClass != null) {
                    ret = Array.newInstance(compClass, 2);
                    Array.set(ret, 0, BasePBImplRecordsTest.genTypeValue(compClass));
                    Array.set(ret, 1, BasePBImplRecordsTest.genTypeValue(compClass));
                }
            } else if (clazz.isEnum()) {
                T[] values = clazz.getEnumConstants();
                ret = values[rand.nextInt(values.length)];
            } else {
                if (clazz.equals(ByteBuffer.class)) {
                    ByteBuffer buff = ByteBuffer.allocate(4);
                    rand.nextBytes(buff.array());
                    return buff;
                }
                if (type.equals(PlacementConstraint.class)) {
                    PlacementConstraint.AbstractConstraint sConstraintExpr = PlacementConstraints.targetIn((String)"node", (PlacementConstraint.TargetExpression[])new PlacementConstraint.TargetExpression[]{PlacementConstraints.PlacementTargets.allocationTag((String[])new String[]{"foo"})});
                    ret = PlacementConstraints.build((PlacementConstraint.AbstractConstraint)sConstraintExpr);
                }
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type rawType = pt.getRawType();
            Type[] params = pt.getActualTypeArguments();
            if (rawType.equals(EnumSet.class) && params[0] instanceof Class) {
                Class c = (Class)params[0];
                return EnumSet.allOf(c);
            }
            if (rawType.equals(List.class)) {
                ret = Lists.newArrayList((Object[])new Object[]{BasePBImplRecordsTest.genTypeValue(params[0])});
            } else if (rawType.equals(Set.class)) {
                ret = Sets.newHashSet((Object[])new Object[]{BasePBImplRecordsTest.genTypeValue(params[0])});
            } else if (rawType.equals(Map.class)) {
                HashMap map = Maps.newHashMap();
                map.put(BasePBImplRecordsTest.genTypeValue(params[0]), BasePBImplRecordsTest.genTypeValue(params[1]));
                ret = map;
            } else if (rawType.equals(Range.class) && (ret = typeValueCache.get(rawType)) != null) {
                return ret;
            }
        }
        if (ret == null) {
            throw new IllegalArgumentException("type " + type + " is not supported");
        }
        typeValueCache.put(type, ret);
        return ret;
    }

    protected static Object generateByNewInstance(Class clazz) throws Exception {
        Object ret = typeValueCache.get(clazz);
        if (ret != null) {
            return ret;
        }
        Method newInstance = null;
        Type[] paramTypes = new Type[]{};
        for (Method m : clazz.getMethods()) {
            int mod = m.getModifiers();
            if (!m.getDeclaringClass().equals(clazz) || !Modifier.isPublic(mod) || !Modifier.isStatic(mod) || !m.getName().equals("newInstance")) continue;
            Type[] pts = m.getGenericParameterTypes();
            if (newInstance != null && pts.length <= paramTypes.length) continue;
            newInstance = m;
            paramTypes = pts;
        }
        if (newInstance == null) {
            throw new IllegalArgumentException("type " + clazz.getName() + " does not have newInstance method");
        }
        Object[] args = new Object[paramTypes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = BasePBImplRecordsTest.genTypeValue(paramTypes[i]);
        }
        ret = newInstance.invoke(null, args);
        typeValueCache.put(clazz, ret);
        return ret;
    }

    private <R> Map<String, GetSetPair> getGetSetPairs(Class<R> recordClass) throws Exception {
        GetSetPair p;
        Type valueType;
        String propertyName;
        String name;
        int mod;
        Method m;
        int i;
        HashMap<String, GetSetPair> ret = new HashMap<String, GetSetPair>();
        List<String> excluded = null;
        if (excludedPropertiesMap.containsKey(recordClass.getClass())) {
            excluded = excludedPropertiesMap.get(recordClass.getClass());
        }
        Method[] methods = recordClass.getDeclaredMethods();
        for (i = 0; i < methods.length; ++i) {
            m = methods[i];
            mod = m.getModifiers();
            if (!m.getDeclaringClass().equals(recordClass) || !Modifier.isPublic(mod) || Modifier.isStatic(mod) || (name = m.getName()).equals("getProto") || name.length() <= 3 || !name.startsWith("get") || m.getParameterTypes().length != 0) continue;
            propertyName = name.substring(3);
            valueType = m.getGenericReturnType();
            p = (GetSetPair)ret.get(propertyName);
            if (p == null) {
                p = new GetSetPair();
                p.propertyName = propertyName;
                p.type = valueType;
                p.getMethod = m;
                ret.put(propertyName, p);
                continue;
            }
            Assertions.fail((String)("Multiple get method with same name: " + recordClass + p.propertyName));
        }
        for (i = 0; i < methods.length; ++i) {
            m = methods[i];
            mod = m.getModifiers();
            if (!m.getDeclaringClass().equals(recordClass) || !Modifier.isPublic(mod) || Modifier.isStatic(mod) || !(name = m.getName()).startsWith("set") || m.getParameterTypes().length != 1) continue;
            propertyName = name.substring(3);
            valueType = m.getGenericParameterTypes()[0];
            p = (GetSetPair)ret.get(propertyName);
            if (p == null || !p.type.equals(valueType)) continue;
            p.setMethod = m;
        }
        Iterator itr = ret.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry cur = itr.next();
            GetSetPair gsp = (GetSetPair)cur.getValue();
            if (gsp.getMethod == null || gsp.setMethod == null) {
                LOG.info(String.format("Exclude potential property: %s\n", gsp.propertyName));
                itr.remove();
                continue;
            }
            if (excluded != null && excluded.contains(gsp.propertyName)) {
                LOG.info(String.format("Excluding potential property(present in exclusion list): %s\n", gsp.propertyName));
                itr.remove();
                continue;
            }
            LOG.info(String.format("New property: %s type: %s", gsp.toString(), gsp.type));
            gsp.testValue = BasePBImplRecordsTest.genTypeValue(gsp.type);
            LOG.info(String.format(" testValue: %s\n", gsp.testValue));
        }
        return ret;
    }

    protected <R, P> void validatePBImplRecord(Class<R> recordClass, Class<P> protoClass) throws Exception {
        LOG.info(String.format("Validate %s %s\n", recordClass.getName(), protoClass.getName()));
        Constructor<R> emptyConstructor = recordClass.getConstructor(new Class[0]);
        Constructor<R> pbConstructor = recordClass.getConstructor(protoClass);
        Method getProto = recordClass.getDeclaredMethod("getProto", new Class[0]);
        Map<String, GetSetPair> getSetPairs = this.getGetSetPairs(recordClass);
        R origRecord = emptyConstructor.newInstance(new Object[0]);
        for (GetSetPair gsp : getSetPairs.values()) {
            gsp.setMethod.invoke(origRecord, gsp.testValue);
        }
        Object ret = getProto.invoke(origRecord, new Object[0]);
        Assertions.assertNotNull((Object)ret, (String)(recordClass.getName() + "#getProto returns null"));
        if (!protoClass.isAssignableFrom(ret.getClass())) {
            Assertions.fail((String)("Illegal getProto method return type: " + ret.getClass()));
        }
        R deserRecord = pbConstructor.newInstance(ret);
        Assertions.assertEquals(origRecord, deserRecord, (String)("whole " + recordClass + " records should be equal"));
        for (GetSetPair gsp : getSetPairs.values()) {
            Object origValue = gsp.getMethod.invoke(origRecord, new Object[0]);
            Object deserValue = gsp.getMethod.invoke(deserRecord, new Object[0]);
            Assertions.assertEquals((Object)origValue, (Object)deserValue, (String)("property " + recordClass.getName() + "#" + gsp.propertyName + " should be equal"));
        }
    }

    private class GetSetPair {
        public String propertyName;
        public Method getMethod;
        public Method setMethod;
        public Type type;
        public Object testValue;

        private GetSetPair() {
        }

        public String toString() {
            return String.format("{ name=%s, class=%s, value=%s }", this.propertyName, this.type, this.testValue);
        }
    }
}

