/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.util.Arrays;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.junit.Assert;
import org.junit.Test;

public class TestParseRoute {
    @Test
    public void testNormalAction() {
        Assert.assertEquals(Arrays.asList("/foo/action", "foo", "action", ":a1", ":a2"), (Object)WebApp.parseRoute((String)"/foo/action/:a1/:a2"));
    }

    @Test
    public void testDefaultController() {
        Assert.assertEquals(Arrays.asList("/", "default", "index"), (Object)WebApp.parseRoute((String)"/"));
    }

    @Test
    public void testDefaultAction() {
        Assert.assertEquals(Arrays.asList("/foo", "foo", "index"), (Object)WebApp.parseRoute((String)"/foo"));
        Assert.assertEquals(Arrays.asList("/foo", "foo", "index"), (Object)WebApp.parseRoute((String)"/foo/"));
    }

    @Test
    public void testMissingAction() {
        Assert.assertEquals(Arrays.asList("/foo", "foo", "index", ":a1"), (Object)WebApp.parseRoute((String)"/foo/:a1"));
    }

    @Test
    public void testDefaultCapture() {
        Assert.assertEquals(Arrays.asList("/", "default", "index", ":a"), (Object)WebApp.parseRoute((String)"/:a"));
    }

    @Test
    public void testPartialCapture1() {
        Assert.assertEquals(Arrays.asList("/foo/action/bar", "foo", "action", "bar", ":a"), (Object)WebApp.parseRoute((String)"/foo/action/bar/:a"));
    }

    @Test
    public void testPartialCapture2() {
        Assert.assertEquals(Arrays.asList("/foo/action", "foo", "action", ":a1", "bar", ":a2", ":a3"), (Object)WebApp.parseRoute((String)"/foo/action/:a1/bar/:a2/:a3"));
    }

    @Test
    public void testLeadingPaddings() {
        Assert.assertEquals(Arrays.asList("/foo/action", "foo", "action", ":a"), (Object)WebApp.parseRoute((String)" /foo/action/ :a"));
    }

    @Test
    public void testTrailingPaddings() {
        Assert.assertEquals(Arrays.asList("/foo/action", "foo", "action", ":a"), (Object)WebApp.parseRoute((String)"/foo/action//:a / "));
        Assert.assertEquals(Arrays.asList("/foo/action", "foo", "action"), (Object)WebApp.parseRoute((String)"/foo/action / "));
    }

    @Test(expected=WebAppException.class)
    public void testMissingLeadingSlash() {
        WebApp.parseRoute((String)"foo/bar");
    }
}

