/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.util.ResourceCalculatorProcessTree;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsSame;
import org.junit.Assert;
import org.junit.Test;

public class TestResourceCalculatorProcessTree {
    @Test
    public void testCreateInstance() {
        ResourceCalculatorProcessTree tree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)"1", EmptyProcessTree.class, (Configuration)new Configuration());
        Assert.assertNotNull((Object)tree);
        Assert.assertThat((Object)tree, (Matcher)IsInstanceOf.instanceOf(EmptyProcessTree.class));
    }

    @Test
    public void testCreatedInstanceConfigured() {
        Configuration conf = new Configuration();
        ResourceCalculatorProcessTree tree = ResourceCalculatorProcessTree.getResourceCalculatorProcessTree((String)"1", EmptyProcessTree.class, (Configuration)conf);
        Assert.assertNotNull((Object)tree);
        Assert.assertThat((Object)tree.getConf(), (Matcher)IsSame.sameInstance((Object)conf));
    }

    public static class EmptyProcessTree
    extends ResourceCalculatorProcessTree {
        public EmptyProcessTree(String pid) {
            super(pid);
        }

        public void updateProcessTree() {
        }

        public String getProcessTreeDump() {
            return "Empty tree for testing";
        }

        public long getRssMemorySize(int age) {
            return 0L;
        }

        public long getCumulativeRssmem(int age) {
            return 0L;
        }

        public long getVirtualMemorySize(int age) {
            return 0L;
        }

        public long getCumulativeVmem(int age) {
            return 0L;
        }

        public long getCumulativeCpuTime() {
            return 0L;
        }

        public float getCpuUsagePercent() {
            return -1.0f;
        }

        public boolean checkPidPgrpidForMatch() {
            return false;
        }
    }
}

