/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.logaggregation.filecontroller;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.logaggregation.AggregatedLogFormat;
import org.apache.hadoop.yarn.logaggregation.ContainerLogMeta;
import org.apache.hadoop.yarn.logaggregation.ContainerLogsRequest;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerContext;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.logaggregation.filecontroller.ifile.LogAggregationIndexedFileController;
import org.apache.hadoop.yarn.logaggregation.filecontroller.tfile.LogAggregationTFileController;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogAggregationFileControllerFactory
extends Configured {
    private static final Logger LOG = LoggerFactory.getLogger(TestLogAggregationFileControllerFactory.class);
    private static final String REMOTE_LOG_ROOT = "target/app-logs/";
    private static final String REMOTE_DEFAULT_DIR = "default/";
    private static final String APP_OWNER = "test";
    private static final String WRONG_ROOT_LOG_DIR_MSG = "Wrong remote root log directory found.";
    private static final String WRONG_ROOT_LOG_DIR_SUFFIX_MSG = "Wrong remote root log directory suffix found.";
    private static final List<Class<? extends LogAggregationFileController>> ALL_FILE_CONTROLLERS = Arrays.asList(TestLogAggregationFileController.class, LogAggregationIndexedFileController.class, LogAggregationTFileController.class);
    private static final List<String> ALL_FILE_CONTROLLER_NAMES = Arrays.asList("TestLogAggregationFileController", "IFile", "TFile");
    private ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);

    @Before
    public void setup() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        conf.setBoolean("yarn.log-aggregation-enable", true);
        conf.set("yarn.nodemanager.remote-app-log-dir", "target/app-logs/default/");
        conf.set("yarn.nodemanager.remote-app-log-dir-suffix", "log");
        this.setConf((Configuration)conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFileControllerInstance(LogAggregationFileControllerFactory factory, Class<? extends LogAggregationFileController> className) throws IOException {
        LinkedList fileControllers = factory.getConfiguredLogAggregationFileControllerList();
        FileSystem fs = FileSystem.get((Configuration)this.getConf());
        Path logPath = ((LogAggregationFileController)fileControllers.get(0)).getRemoteAppLogDir(this.appId, APP_OWNER);
        LOG.debug("Checking " + logPath);
        try {
            if (fs.exists(logPath)) {
                fs.delete(logPath, true);
            }
            Assert.assertTrue((boolean)fs.mkdirs(logPath));
            try (FileWriter writer = new FileWriter(new File(logPath.toString(), "testLog"));){
                writer.write(APP_OWNER);
            }
            Assert.assertTrue((String)("The used LogAggregationFileController is not instance of " + className.getSimpleName()), (boolean)className.isInstance(factory.getFileControllerForRead(this.appId, APP_OWNER)));
        }
        finally {
            fs.delete(logPath, true);
        }
    }

    @Test
    public void testDefaultLogAggregationFileControllerFactory() throws IOException {
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(this.getConf());
        LinkedList list = factory.getConfiguredLogAggregationFileControllerList();
        Assert.assertEquals((String)"Only one LogAggregationFileController is expected!", (long)1L, (long)list.size());
        Assert.assertTrue((String)"TFile format is expected to be the first LogAggregationFileController!", (boolean)(list.get(0) instanceof LogAggregationTFileController));
        Assert.assertTrue((String)"TFile format is expected to be used for writing!", (boolean)(factory.getFileControllerForWrite() instanceof LogAggregationTFileController));
        this.verifyFileControllerInstance(factory, LogAggregationTFileController.class);
    }

    @Test(expected=Exception.class)
    public void testLogAggregationFileControllerFactoryClassNotSet() {
        Configuration conf = this.getConf();
        conf.set("yarn.log-aggregation.file-formats", "TestLogAggregationFileController");
        new LogAggregationFileControllerFactory(conf);
        Assert.fail((String)"TestLogAggregationFileController's class was not set, but the factory creation did not fail.");
    }

    private void enableFileControllers(List<Class<? extends LogAggregationFileController>> fileControllers, List<String> fileControllerNames) {
        Configuration conf = this.getConf();
        conf.set("yarn.log-aggregation.file-formats", StringUtils.join(fileControllerNames, (String)","));
        for (int i = 0; i < fileControllers.size(); ++i) {
            Class<? extends LogAggregationFileController> fileController = fileControllers.get(i);
            String controllerName = fileControllerNames.get(i);
            conf.setClass(String.format("yarn.log-aggregation.file-controller.%s.class", controllerName), fileController, LogAggregationFileController.class);
            conf.set(String.format("yarn.log-aggregation.%s.remote-app-log-dir", controllerName), REMOTE_LOG_ROOT + controllerName + "/");
            conf.set(String.format("yarn.log-aggregation.%s.remote-app-log-dir-suffix", controllerName), controllerName);
        }
    }

    @Test
    public void testLogAggregationFileControllerFactory() throws Exception {
        this.enableFileControllers(ALL_FILE_CONTROLLERS, ALL_FILE_CONTROLLER_NAMES);
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(this.getConf());
        LinkedList list = factory.getConfiguredLogAggregationFileControllerList();
        Assert.assertEquals((String)"The expected number of LogAggregationFileController is not 3!", (long)3L, (long)list.size());
        Assert.assertTrue((String)"Test format is expected to be the first LogAggregationFileController!", (boolean)(list.get(0) instanceof TestLogAggregationFileController));
        Assert.assertTrue((String)"IFile format is expected to be the second LogAggregationFileController!", (boolean)(list.get(1) instanceof LogAggregationIndexedFileController));
        Assert.assertTrue((String)"TFile format is expected to be the first LogAggregationFileController!", (boolean)(list.get(2) instanceof LogAggregationTFileController));
        Assert.assertTrue((String)"Test format is expected to be used for writing!", (boolean)(factory.getFileControllerForWrite() instanceof TestLogAggregationFileController));
        this.verifyFileControllerInstance(factory, TestLogAggregationFileController.class);
    }

    @Test
    public void testClassConfUsed() {
        this.enableFileControllers(Collections.singletonList(LogAggregationTFileController.class), Collections.singletonList("TFile"));
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(this.getConf());
        LogAggregationFileController fc = factory.getFileControllerForWrite();
        Assert.assertEquals((String)WRONG_ROOT_LOG_DIR_MSG, (Object)"target/app-logs/TFile", (Object)fc.getRemoteRootLogDir().toString());
        Assert.assertEquals((String)WRONG_ROOT_LOG_DIR_SUFFIX_MSG, (Object)"TFile", (Object)fc.getRemoteRootLogDirSuffix());
    }

    @Test
    public void testNodemanagerConfigurationIsUsed() {
        Configuration conf = this.getConf();
        conf.set("yarn.log-aggregation.file-formats", "TFile");
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(conf);
        LogAggregationFileController fc = factory.getFileControllerForWrite();
        Assert.assertEquals((String)WRONG_ROOT_LOG_DIR_MSG, (Object)"target/app-logs/default", (Object)fc.getRemoteRootLogDir().toString());
        Assert.assertEquals((String)WRONG_ROOT_LOG_DIR_SUFFIX_MSG, (Object)"log-tfile", (Object)fc.getRemoteRootLogDirSuffix());
    }

    @Test
    public void testDefaultConfUsed() {
        Configuration conf = this.getConf();
        conf.unset("yarn.nodemanager.remote-app-log-dir");
        conf.unset("yarn.nodemanager.remote-app-log-dir-suffix");
        conf.set("yarn.log-aggregation.file-formats", "TFile");
        LogAggregationFileControllerFactory factory = new LogAggregationFileControllerFactory(this.getConf());
        LogAggregationFileController fc = factory.getFileControllerForWrite();
        Assert.assertEquals((String)WRONG_ROOT_LOG_DIR_MSG, (Object)"/tmp/logs", (Object)fc.getRemoteRootLogDir().toString());
        Assert.assertEquals((String)WRONG_ROOT_LOG_DIR_SUFFIX_MSG, (Object)"logs-tfile", (Object)fc.getRemoteRootLogDirSuffix());
    }

    private static class TestLogAggregationFileController
    extends LogAggregationFileController {
        private TestLogAggregationFileController() {
        }

        public void initInternal(Configuration conf) {
        }

        public void closeWriter() {
        }

        public void write(AggregatedLogFormat.LogKey logKey, AggregatedLogFormat.LogValue logValue) throws IOException {
        }

        public void postWrite(LogAggregationFileControllerContext record) throws Exception {
        }

        public void initializeWriter(LogAggregationFileControllerContext context) throws IOException {
        }

        public boolean readAggregatedLogs(ContainerLogsRequest logRequest, OutputStream os) throws IOException {
            return false;
        }

        public List<ContainerLogMeta> readAggregatedLogsMeta(ContainerLogsRequest logRequest) throws IOException {
            return null;
        }

        public void renderAggregatedLogsBlock(HtmlBlock.Block html, View.ViewContext context) {
        }

        public String getApplicationOwner(Path aggregatedLogPath, ApplicationId appId) throws IOException {
            return null;
        }

        public Map<ApplicationAccessType, String> getApplicationAcls(Path aggregatedLogPath, ApplicationId appId) throws IOException {
            return null;
        }
    }
}

