/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebServicesTestUtils {
    public static long getXmlLong(Element element, String name) {
        String val = WebServicesTestUtils.getXmlString(element, name);
        return Long.parseLong(val);
    }

    public static int getXmlInt(Element element, String name) {
        String val = WebServicesTestUtils.getXmlString(element, name);
        return Integer.parseInt(val);
    }

    public static Boolean getXmlBoolean(Element element, String name) {
        String val = WebServicesTestUtils.getXmlString(element, name);
        return Boolean.parseBoolean(val);
    }

    public static float getXmlFloat(Element element, String name) {
        String val = WebServicesTestUtils.getXmlString(element, name);
        return Float.parseFloat(val);
    }

    public static List<String> getXmlStrings(Element element, String name) {
        NodeList id = element.getElementsByTagName(name);
        ArrayList<String> strings = new ArrayList<String>();
        int len = id.getLength();
        if (id.getLength() == 0) {
            return strings;
        }
        for (int i = 0; i < len; ++i) {
            String val;
            Node first;
            Element line = (Element)id.item(i);
            if (line == null || (first = line.getFirstChild()) == null || (val = first.getNodeValue()) == null) continue;
            strings.add(val);
        }
        return strings;
    }

    public static String getXmlString(Element element, String name) {
        NodeList id = element.getElementsByTagName(name);
        Element line = (Element)id.item(0);
        if (line == null) {
            return null;
        }
        Node first = line.getFirstChild();
        if (first == null) {
            return "";
        }
        String val = first.getNodeValue();
        if (val == null) {
            return "";
        }
        return val;
    }

    public static String getPropertyValue(Element element, String elementName, String propertyName) {
        NodeList id = element.getElementsByTagName(elementName);
        Element line = (Element)id.item(0);
        if (line == null) {
            return null;
        }
        NodeList properties = line.getChildNodes();
        for (int i = 0; i < properties.getLength(); ++i) {
            Element property = (Element)properties.item(i);
            if (!WebServicesTestUtils.getXmlString(property, "name").equals(propertyName)) continue;
            return WebServicesTestUtils.getXmlString(property, "value");
        }
        return null;
    }

    public static String getXmlAttrString(Element element, String name) {
        Attr at = element.getAttributeNode(name);
        if (at != null) {
            return at.getValue();
        }
        return null;
    }

    public static void checkStringMatch(String print, String expected, String got) {
        ((AbstractStringAssert)Assertions.assertThat((String)got).as(print, new Object[0])).matches((CharSequence)expected);
    }

    public static void checkStringContains(String print, String expected, String got) {
        ((AbstractStringAssert)Assertions.assertThat((String)got).as(print, new Object[0])).contains(new CharSequence[]{expected});
    }

    public static void checkStringEqual(String print, String expected, String got) {
        ((AbstractStringAssert)Assertions.assertThat((String)got).as(print, new Object[0])).isEqualTo((Object)expected);
    }

    public static void assertResponseStatusCode(Response.StatusType expected, Response.StatusType actual) {
        Assertions.assertThat((int)expected.getStatusCode()).isEqualTo(actual.getStatusCode());
    }

    public static void assertResponseStatusCode(String errmsg, Response.StatusType expected, Response.StatusType actual) {
        ((AbstractIntegerAssert)Assertions.assertThat((int)expected.getStatusCode()).withFailMessage(errmsg, new Object[0])).isEqualTo(actual.getStatusCode());
    }
}

