/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api;

import java.io.File;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.TestResourceUtils;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestResourcePBImpl {
    @Before
    public void setup() throws Exception {
        ResourceUtils.resetResourceTypes();
        String resourceTypesFile = "resource-types-5.xml";
        YarnConfiguration conf = new YarnConfiguration();
        TestResourceUtils.setupResourceTypes((Configuration)conf, resourceTypesFile);
    }

    @After
    public void teardown() {
        YarnConfiguration conf = new YarnConfiguration();
        File source = new File(conf.getClassLoader().getResource("resource-types-5.xml").getFile());
        File dest = new File(source.getParent(), "resource-types.xml");
        if (dest.exists()) {
            dest.delete();
        }
    }

    @Test
    public void testEmptyResourcePBInit() throws Exception {
        ResourcePBImpl res = new ResourcePBImpl();
        Assert.assertEquals((long)0L, (long)res.getMemorySize());
        Assert.assertEquals((Object)ResourceInformation.MEMORY_MB.getUnits(), (Object)res.getResourceInformation(ResourceInformation.MEMORY_MB.getName()).getUnits());
        Assert.assertEquals((Object)ResourceInformation.VCORES.getUnits(), (Object)res.getResourceInformation(ResourceInformation.VCORES.getName()).getUnits());
    }

    @Test
    public void testResourcePBInitFromOldPB() throws Exception {
        YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).build();
        ResourcePBImpl res = new ResourcePBImpl(proto);
        Assert.assertEquals((long)1024L, (long)res.getMemorySize());
        Assert.assertEquals((long)3L, (long)res.getVirtualCores());
        Assert.assertEquals((Object)ResourceInformation.MEMORY_MB.getUnits(), (Object)res.getResourceInformation(ResourceInformation.MEMORY_MB.getName()).getUnits());
        Assert.assertEquals((Object)ResourceInformation.VCORES.getUnits(), (Object)res.getResourceInformation(ResourceInformation.VCORES.getName()).getUnits());
    }

    @Test
    public void testGetMemory() {
        ResourcePBImpl res = new ResourcePBImpl();
        long memorySize = 0x80000000L;
        res.setMemorySize(memorySize);
        Assert.assertEquals((String)"No need to cast if both are long", (long)memorySize, (long)res.getMemorySize());
        Assert.assertEquals((String)"Cast to Integer.MAX_VALUE if the long is greater than Integer.MAX_VALUE", (long)Integer.MAX_VALUE, (long)res.getMemory());
    }

    @Test
    public void testGetVirtualCores() {
        ResourcePBImpl res = new ResourcePBImpl();
        long vcores = 0x80000000L;
        res.getResourceInformation("vcores").setValue(vcores);
        Assert.assertEquals((String)"No need to cast if both are long", (long)vcores, (long)res.getResourceInformation("vcores").getValue());
        Assert.assertEquals((String)"Cast to Integer.MAX_VALUE if the long is greater than Integer.MAX_VALUE", (long)Integer.MAX_VALUE, (long)res.getVirtualCores());
    }

    @Test
    public void testResourcePBWithExtraResources() throws Exception {
        YarnProtos.ResourceInformationProto riProto = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("resource1").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(4L).setUnits("T").setKey("resource1").build();
        YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto).build();
        ResourcePBImpl res = new ResourcePBImpl(proto);
        Assert.assertEquals((long)4000L, (long)res.getResourceInformation("resource1").getValue());
        Assert.assertEquals((Object)"G", (Object)res.getResourceInformation("resource1").getUnits());
        YarnProtos.ResourceInformationProto riProto1 = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("resource2").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(4L).setUnits("M").setKey("resource2").build();
        YarnProtos.ResourceProto proto1 = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto1).build();
        ResourcePBImpl res1 = new ResourcePBImpl(proto1);
        Assert.assertEquals((long)4000000000L, (long)res1.getResourceInformation("resource2").getValue());
        Assert.assertEquals((Object)"m", (Object)res1.getResourceInformation("resource2").getUnits());
        YarnProtos.ResourceInformationProto riProto2 = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("resource1").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(3L).setUnits("M").setKey("resource1").build();
        YarnProtos.ResourceProto proto2 = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto2).build();
        ResourcePBImpl res2 = new ResourcePBImpl(proto2);
        Assert.assertEquals((long)0L, (long)res2.getResourceInformation("resource1").getValue());
        Assert.assertEquals((Object)"G", (Object)res2.getResourceInformation("resource1").getUnits());
    }

    @Test
    public void testResourceTags() {
        YarnProtos.ResourceInformationProto riProto = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("yarn.io/test-volume").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(10L).setUnits("G").setKey("yarn.io/test-volume").addTags("tag_A").addTags("tag_B").addTags("tag_C").build();
        YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto).build();
        ResourcePBImpl res = new ResourcePBImpl(proto);
        Assert.assertNotNull((Object)res.getResourceInformation("yarn.io/test-volume"));
        Assert.assertEquals((long)10L, (long)res.getResourceInformation("yarn.io/test-volume").getValue());
        Assert.assertEquals((Object)"G", (Object)res.getResourceInformation("yarn.io/test-volume").getUnits());
        Assert.assertEquals((long)3L, (long)res.getResourceInformation("yarn.io/test-volume").getTags().size());
        Assert.assertFalse((boolean)res.getResourceInformation("yarn.io/test-volume").getTags().isEmpty());
        Assert.assertTrue((boolean)res.getResourceInformation("yarn.io/test-volume").getAttributes().isEmpty());
        boolean protoConvertExpected = false;
        YarnProtos.ResourceProto protoFormat = ProtoUtils.convertToProtoFormat((Resource)res);
        for (YarnProtos.ResourceInformationProto pf : protoFormat.getResourceValueMapList()) {
            if (!pf.getKey().equals("yarn.io/test-volume")) continue;
            protoConvertExpected = pf.getAttributesCount() == 0 && pf.getTagsCount() == 3;
        }
        Assert.assertTrue((String)"Expecting resource's protobuf message contains 0 attributes and 3 tags", (boolean)protoConvertExpected);
    }

    @Test
    public void testResourceAttributes() {
        YarnProtos.ResourceInformationProto riProto = YarnProtos.ResourceInformationProto.newBuilder().setType(YarnProtos.ResourceTypeInfoProto.newBuilder().setName("yarn.io/test-volume").setType(YarnProtos.ResourceTypesProto.COUNTABLE).getType()).setValue(10L).setUnits("G").setKey("yarn.io/test-volume").addAttributes(YarnProtos.StringStringMapProto.newBuilder().setKey("driver").setValue("test-driver").build()).addAttributes(YarnProtos.StringStringMapProto.newBuilder().setKey("mount").setValue("/mnt/data").build()).build();
        YarnProtos.ResourceProto proto = YarnProtos.ResourceProto.newBuilder().setMemory(1024L).setVirtualCores(3).addResourceValueMap(riProto).build();
        ResourcePBImpl res = new ResourcePBImpl(proto);
        Assert.assertNotNull((Object)res.getResourceInformation("yarn.io/test-volume"));
        Assert.assertEquals((long)10L, (long)res.getResourceInformation("yarn.io/test-volume").getValue());
        Assert.assertEquals((Object)"G", (Object)res.getResourceInformation("yarn.io/test-volume").getUnits());
        Assert.assertEquals((long)2L, (long)res.getResourceInformation("yarn.io/test-volume").getAttributes().size());
        Assert.assertTrue((boolean)res.getResourceInformation("yarn.io/test-volume").getTags().isEmpty());
        Assert.assertFalse((boolean)res.getResourceInformation("yarn.io/test-volume").getAttributes().isEmpty());
        boolean protoConvertExpected = false;
        YarnProtos.ResourceProto protoFormat = ProtoUtils.convertToProtoFormat((Resource)res);
        for (YarnProtos.ResourceInformationProto pf : protoFormat.getResourceValueMapList()) {
            if (!pf.getKey().equals("yarn.io/test-volume")) continue;
            protoConvertExpected = pf.getAttributesCount() == 2 && pf.getTagsCount() == 0;
        }
        Assert.assertTrue((String)"Expecting resource's protobuf message contains 2 attributes and 0 tags", (boolean)protoConvertExpected);
    }

    @Test
    public void testParsingResourceTags() {
        ResourceInformation info = (ResourceInformation)ResourceUtils.getResourceTypes().get("resource3");
        Assert.assertTrue((boolean)info.getAttributes().isEmpty());
        Assert.assertFalse((boolean)info.getTags().isEmpty());
        Assertions.assertThat((Iterable)info.getTags()).hasSize(2);
        info.getTags().remove("resource3_tag_1");
        info.getTags().remove("resource3_tag_2");
        Assert.assertTrue((boolean)info.getTags().isEmpty());
    }
}

