/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.yarn.api.records.impl.pb.SerializedExceptionPBImpl;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.junit.Assert;
import org.junit.Test;

public class TestSerializedExceptionPBImpl {
    @Test
    public void testSerializedException() throws Exception {
        SerializedExceptionPBImpl orig = new SerializedExceptionPBImpl();
        orig.init((Throwable)new Exception("test exception"));
        YarnProtos.SerializedExceptionProto proto = orig.getProto();
        SerializedExceptionPBImpl deser = new SerializedExceptionPBImpl(proto);
        Assert.assertEquals((Object)orig, (Object)deser);
        Assert.assertEquals((Object)orig.getMessage(), (Object)deser.getMessage());
        Assert.assertEquals((Object)orig.getRemoteTrace(), (Object)deser.getRemoteTrace());
        Assert.assertEquals((Object)orig.getCause(), (Object)deser.getCause());
    }

    @Test
    public void testDeserialize() throws Exception {
        Exception ex = new Exception("test exception");
        SerializedExceptionPBImpl pb = new SerializedExceptionPBImpl();
        try {
            pb.deSerialize();
            Assert.fail((String)"deSerialze should throw YarnRuntimeException");
        }
        catch (YarnRuntimeException e) {
            Assert.assertEquals(ClassNotFoundException.class, e.getCause().getClass());
        }
        pb.init((Throwable)ex);
        Assert.assertEquals((Object)ex.toString(), (Object)pb.deSerialize().toString());
    }

    @Test
    public void testBeforeInit() throws Exception {
        YarnProtos.SerializedExceptionProto defaultProto = YarnProtos.SerializedExceptionProto.newBuilder().build();
        SerializedExceptionPBImpl pb1 = new SerializedExceptionPBImpl();
        Assert.assertNull((Object)pb1.getCause());
        SerializedExceptionPBImpl pb2 = new SerializedExceptionPBImpl();
        Assert.assertEquals((Object)defaultProto, (Object)pb2.getProto());
        SerializedExceptionPBImpl pb3 = new SerializedExceptionPBImpl();
        Assert.assertEquals((Object)defaultProto.getTrace(), (Object)pb3.getRemoteTrace());
    }
}

