/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.appcatalog.controller;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hadoop.yarn.appcatalog.application.AppCatalogSolrClient;
import org.apache.hadoop.yarn.appcatalog.application.YarnServiceClient;
import org.apache.hadoop.yarn.appcatalog.model.AppEntry;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.solr.client.solrj.SolrServerException;

@Path(value="/app_list")
@Produces(value={"application/json"})
public class AppListController {
    @GET
    @Produces(value={"application/json"})
    public List<AppEntry> getList() {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        return sc.listAppEntries();
    }

    @DELETE
    @Path(value="{id}/{name}")
    @Produces(value={"application/json"})
    public Response delete(@PathParam(value="id") String id, @PathParam(value="name") String name) {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        sc.deleteApp(id);
        YarnServiceClient yc = new YarnServiceClient();
        yc.deleteApp(name);
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }

    @POST
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deploy(@PathParam(value="id") String id, Service service) {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        try {
            sc.deployApp(id, service);
        }
        catch (IOException | SolrServerException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.toString()).build();
        }
        YarnServiceClient yc = new YarnServiceClient();
        yc.createApp(service);
        String output = "{\"status\":\"Application deployed.\",\"id\":\"" + service.getName() + "\"}";
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)output).build();
    }
}

