/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.appcatalog.controller;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.hadoop.yarn.appcatalog.application.AppCatalogSolrClient;
import org.apache.hadoop.yarn.appcatalog.application.YarnServiceClient;
import org.apache.hadoop.yarn.appcatalog.model.AppEntry;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.solr.client.solrj.SolrServerException;

@Path(value="/app_details")
public class AppDetailsController {
    @Path(value="config/{id}")
    @GET
    @Produces(value={"application/json"})
    public AppEntry getDetails(@PathParam(value="id") String id) {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        return sc.findAppEntry(id);
    }

    @Path(value="status/{id}")
    @GET
    @Produces(value={"application/json"})
    public AppEntry getStatus(@PathParam(value="id") String id) {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        AppEntry appEntry = sc.findAppEntry(id);
        YarnServiceClient yc = new YarnServiceClient();
        yc.getStatus(appEntry);
        return appEntry;
    }

    @Path(value="stop/{id}")
    @POST
    @Produces(value={"application/json"})
    public Response stopApp(@PathParam(value="id") String id) {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        AppEntry app = sc.findAppEntry(id);
        Service yarnApp = app.getYarnfile();
        yarnApp.setState(ServiceState.STOPPED);
        try {
            YarnServiceClient yc = new YarnServiceClient();
            yc.stopApp(yarnApp);
        }
        catch (JsonProcessingException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok().build();
    }

    @Path(value="restart/{id}")
    @POST
    @Produces(value={"application/json"})
    public Response restartApp(@PathParam(value="id") String id) {
        AppCatalogSolrClient sc = new AppCatalogSolrClient();
        AppEntry app = sc.findAppEntry(id);
        Service yarnApp = app.getYarnfile();
        yarnApp.setState(ServiceState.STARTED);
        try {
            YarnServiceClient yc = new YarnServiceClient();
            yc.restartApp(yarnApp);
        }
        catch (JsonProcessingException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        return Response.ok().build();
    }

    @Path(value="upgrade/{id}")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response upgradeApp(@PathParam(value="id") String id, Service app) {
        try {
            AppCatalogSolrClient sc = new AppCatalogSolrClient();
            sc.upgradeApp(app);
            YarnServiceClient yc = new YarnServiceClient();
            yc.upgradeApp(app);
        }
        catch (IOException | SolrServerException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.toString()).build();
        }
        String output = "{\"status\":\"Application upgrade requested.\",\"id\":\"" + app.getName() + "\"}";
        return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)output).build();
    }
}

