/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.timelineservice;

import org.apache.hadoop.yarn.api.records.timelineservice.ApplicationEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntityType;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestApplicationEntity {
    TestApplicationEntity() {
    }

    @Test
    void testIsApplicationEntity() {
        TimelineEntity te = new TimelineEntity();
        te.setType(TimelineEntityType.YARN_APPLICATION.toString());
        Assertions.assertTrue((boolean)ApplicationEntity.isApplicationEntity((TimelineEntity)te));
        te = null;
        Assertions.assertEquals((Object)false, (Object)ApplicationEntity.isApplicationEntity((TimelineEntity)te));
        te = new TimelineEntity();
        te.setType(TimelineEntityType.YARN_CLUSTER.toString());
        Assertions.assertEquals((Object)false, (Object)ApplicationEntity.isApplicationEntity((TimelineEntity)te));
    }

    @Test
    void testGetApplicationEvent() {
        TimelineEntity te = null;
        TimelineEvent tEvent = ApplicationEntity.getApplicationEvent(te, (String)"no event");
        Assertions.assertEquals(null, (Object)tEvent);
        te = new TimelineEntity();
        te.setType(TimelineEntityType.YARN_APPLICATION.toString());
        TimelineEvent event = new TimelineEvent();
        event.setId("start_event");
        event.setTimestamp(System.currentTimeMillis());
        te.addEvent(event);
        tEvent = ApplicationEntity.getApplicationEvent((TimelineEntity)te, (String)"start_event");
        Assertions.assertEquals((Object)event, (Object)tEvent);
        te = new TimelineEntity();
        te.setType(TimelineEntityType.YARN_CLUSTER.toString());
        event = new TimelineEvent();
        event.setId("start_event_cluster");
        event.setTimestamp(System.currentTimeMillis());
        te.addEvent(event);
        tEvent = ApplicationEntity.getApplicationEvent((TimelineEntity)te, (String)"start_event_cluster");
        Assertions.assertEquals(null, (Object)tEvent);
    }
}

