/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestResource {
    TestResource() {
    }

    @Test
    void testCastToIntSafely() {
        Assertions.assertEquals((int)0, (int)Resource.castToIntSafely((long)0L));
        Assertions.assertEquals((int)1, (int)Resource.castToIntSafely((long)1L));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Resource.castToIntSafely((long)Integer.MAX_VALUE));
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Resource.castToIntSafely((long)0x80000000L), (String)"Cast to Integer.MAX_VALUE if the long is greater than Integer.MAX_VALUE");
        Assertions.assertEquals((int)Integer.MAX_VALUE, (int)Resource.castToIntSafely((long)Long.MAX_VALUE), (String)"Cast to Integer.MAX_VALUE if the long is greater than Integer.MAX_VALUE");
    }

    @Test
    public void testResourceFormatted() {
        Resource resource = (Resource)Mockito.spy(Resource.class);
        resource.setResources(new ResourceInformation[0]);
        Mockito.when((Object)resource.getVirtualCores()).thenReturn((Object)1);
        String expectedResult1 = "<memory:10 MB, vCores:1>";
        Assertions.assertEquals((Object)expectedResult1, (Object)resource.getFormattedString(10L));
        String expectedResult2 = "<memory:1 GB, vCores:1>";
        Assertions.assertEquals((Object)expectedResult2, (Object)resource.getFormattedString(1024L));
        String expectedResult3 = "<memory:1 TB, vCores:1>";
        Assertions.assertEquals((Object)expectedResult3, (Object)resource.getFormattedString(0x100000L));
        String expectedResult4 = "<memory:1 PB, vCores:1>";
        Assertions.assertEquals((Object)expectedResult4, (Object)resource.getFormattedString(0x40000000L));
    }
}

