/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.scheduler;

import com.codahale.metrics.Counter;
import com.codahale.metrics.CsvReporter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import com.codahale.metrics.Timer;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.sls.SLSRunner;
import org.apache.hadoop.yarn.sls.scheduler.CapacitySchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.FairSchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.FifoSchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.NodeUpdateSchedulerEventWrapper;
import org.apache.hadoop.yarn.sls.scheduler.RMNodeWrapper;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerMetrics;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.web.SLSWebApp;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLSCapacityScheduler
extends CapacityScheduler
implements SchedulerWrapper,
Configurable {
    private static final String EOL = System.getProperty("line.separator");
    private static final int SAMPLING_SIZE = 60;
    private ScheduledExecutorService pool;
    private Counter schedulerAllocateCounter;
    private Counter schedulerHandleCounter;
    private Map<SchedulerEventType, Counter> schedulerHandleCounterMap;
    private Timer schedulerAllocateTimer;
    private Timer schedulerHandleTimer;
    private Map<SchedulerEventType, Timer> schedulerHandleTimerMap;
    private List<Histogram> schedulerHistogramList;
    private Map<Histogram, Timer> histogramTimerMap;
    private Lock samplerLock;
    private Lock queueLock;
    private Configuration conf;
    private Map<ApplicationAttemptId, String> appQueueMap = new ConcurrentHashMap<ApplicationAttemptId, String>();
    private BufferedWriter jobRuntimeLogBW;
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private SLSWebApp web;
    private Map<ContainerId, Resource> preemptionContainerMap = new ConcurrentHashMap<ContainerId, Resource>();
    private MetricRegistry metrics;
    private SchedulerMetrics schedulerMetrics;
    private boolean metricsON;
    private String metricsOutputDir;
    private BufferedWriter metricsLogBW;
    private boolean running = false;
    private static Map<Class, Class> defaultSchedulerMetricsMap = new HashMap<Class, Class>();
    private Set<String> queueSet;
    private Set<String> trackedAppSet;
    public final Logger LOG = LoggerFactory.getLogger(SLSCapacityScheduler.class);

    public SLSCapacityScheduler() {
        this.samplerLock = new ReentrantLock();
        this.queueLock = new ReentrantLock();
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        super.setConf(conf);
        this.metricsON = conf.getBoolean("yarn.sls.metrics.switch", true);
        if (this.metricsON) {
            try {
                this.initMetrics();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ShutdownHookManager.get().addShutdownHook(new Runnable(){

            @Override
            public void run() {
                try {
                    if (SLSCapacityScheduler.this.metricsLogBW != null) {
                        SLSCapacityScheduler.this.metricsLogBW.write("]");
                        SLSCapacityScheduler.this.metricsLogBW.close();
                    }
                    if (SLSCapacityScheduler.this.web != null) {
                        SLSCapacityScheduler.this.web.stop();
                    }
                    SLSCapacityScheduler.this.tearDown();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, 30);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Allocation allocate(ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<ContainerId> containerIds, List<String> strings, List<String> strings2) {
        if (this.metricsON) {
            Timer.Context context = this.schedulerAllocateTimer.time();
            Allocation allocation = null;
            try {
                Allocation allocation2 = allocation = super.allocate(attemptId, resourceRequests, containerIds, strings, strings2);
                return allocation2;
            }
            finally {
                context.stop();
                this.schedulerAllocateCounter.inc();
                try {
                    this.updateQueueWithAllocateRequest(allocation, attemptId, resourceRequests, containerIds);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return super.allocate(attemptId, resourceRequests, containerIds, strings, strings2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(SchedulerEvent schedulerEvent) {
        ApplicationAttemptId appAttemptId;
        AppAttemptRemovedSchedulerEvent appRemoveEvent;
        if (!this.metricsON) {
            super.handle(schedulerEvent);
            return;
        }
        if (!this.running) {
            this.running = true;
        }
        Timer.Context handlerTimer = null;
        Timer.Context operationTimer = null;
        try {
            if (schedulerEvent.getType() == SchedulerEventType.NODE_UPDATE && schedulerEvent instanceof NodeUpdateSchedulerEvent) {
                NodeUpdateSchedulerEventWrapper eventWrapper = new NodeUpdateSchedulerEventWrapper((NodeUpdateSchedulerEvent)schedulerEvent);
                schedulerEvent = eventWrapper;
                this.updateQueueWithNodeUpdate(eventWrapper);
            } else if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_REMOVED && schedulerEvent instanceof AppAttemptRemovedSchedulerEvent) {
                appRemoveEvent = (AppAttemptRemovedSchedulerEvent)schedulerEvent;
                appAttemptId = appRemoveEvent.getApplicationAttemptID();
                String queue = this.appQueueMap.get(appAttemptId);
                SchedulerAppReport app = super.getSchedulerAppInfo(appAttemptId);
                if (!app.getLiveContainers().isEmpty()) {
                    RMContainer rmc = (RMContainer)app.getLiveContainers().iterator().next();
                    this.updateQueueMetrics(queue, rmc.getContainer().getResource().getMemory(), rmc.getContainer().getResource().getVirtualCores());
                }
            }
            handlerTimer = this.schedulerHandleTimer.time();
            operationTimer = this.schedulerHandleTimerMap.get(schedulerEvent.getType()).time();
            super.handle(schedulerEvent);
        }
        finally {
            if (handlerTimer != null) {
                handlerTimer.stop();
            }
            if (operationTimer != null) {
                operationTimer.stop();
            }
            this.schedulerHandleCounter.inc();
            this.schedulerHandleCounterMap.get(schedulerEvent.getType()).inc();
            if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_REMOVED && schedulerEvent instanceof AppAttemptRemovedSchedulerEvent) {
                SLSRunner.decreaseRemainingApps();
                appRemoveEvent = (AppAttemptRemovedSchedulerEvent)schedulerEvent;
                appAttemptId = appRemoveEvent.getApplicationAttemptID();
                this.appQueueMap.remove(appRemoveEvent.getApplicationAttemptID());
            } else if (schedulerEvent.getType() == SchedulerEventType.APP_ATTEMPT_ADDED && schedulerEvent instanceof AppAttemptAddedSchedulerEvent) {
                AppAttemptAddedSchedulerEvent appAddEvent = (AppAttemptAddedSchedulerEvent)schedulerEvent;
                SchedulerApplication app = (SchedulerApplication)this.applications.get(appAddEvent.getApplicationAttemptId().getApplicationId());
                this.appQueueMap.put(appAddEvent.getApplicationAttemptId(), app.getQueue().getQueueName());
            }
        }
    }

    private void updateQueueWithNodeUpdate(NodeUpdateSchedulerEventWrapper eventWrapper) {
        RMNodeWrapper node = (RMNodeWrapper)eventWrapper.getRMNode();
        List<UpdatedContainerInfo> containerList = node.getContainerUpdates();
        for (UpdatedContainerInfo info : containerList) {
            for (ContainerStatus status : info.getCompletedContainers()) {
                ContainerId containerId = status.getContainerId();
                SchedulerAppReport app = super.getSchedulerAppInfo(containerId.getApplicationAttemptId());
                if (app == null) continue;
                String queue = this.appQueueMap.get(containerId.getApplicationAttemptId());
                int releasedMemory = 0;
                int releasedVCores = 0;
                if (status.getExitStatus() == 0) {
                    for (RMContainer rmc : app.getLiveContainers()) {
                        if (rmc.getContainerId() != containerId) continue;
                        releasedMemory += rmc.getContainer().getResource().getMemory();
                        releasedVCores += rmc.getContainer().getResource().getVirtualCores();
                        break;
                    }
                } else if (status.getExitStatus() == -100 && this.preemptionContainerMap.containsKey(containerId)) {
                    Resource preResource = this.preemptionContainerMap.get(containerId);
                    releasedMemory += preResource.getMemory();
                    releasedVCores += preResource.getVirtualCores();
                    this.preemptionContainerMap.remove(containerId);
                }
                this.updateQueueMetrics(queue, releasedMemory, releasedVCores);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void updateQueueWithAllocateRequest(Allocation allocation, ApplicationAttemptId attemptId, List<ResourceRequest> resourceRequests, List<ContainerId> containerIds) throws IOException {
        Resource pendingResource = Resources.createResource((int)0, (int)0);
        Resource allocatedResource = Resources.createResource((int)0, (int)0);
        String queueName = this.appQueueMap.get(attemptId);
        for (ResourceRequest request : resourceRequests) {
            if (!request.getResourceName().equals("*")) continue;
            Resources.addTo((Resource)pendingResource, (Resource)Resources.multiply((Resource)request.getCapability(), (double)request.getNumContainers()));
        }
        for (Object container : allocation.getContainers()) {
            Resources.addTo((Resource)allocatedResource, (Resource)container.getResource());
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        SchedulerAppReport report = super.getSchedulerAppInfo(attemptId);
        for (ContainerId containerId : containerIds) {
            Container container = null;
            for (Object c : report.getLiveContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container != null) {
                Resources.subtractFrom((Resource)allocatedResource, (Resource)container.getResource());
                continue;
            }
            for (Object c : report.getReservedContainers()) {
                if (!c.getContainerId().equals((Object)containerId)) continue;
                container = c.getContainer();
                break;
            }
            if (container == null) continue;
            Resources.subtractFrom((Resource)pendingResource, (Resource)container.getResource());
        }
        HashSet preemptionContainers = new HashSet();
        if (allocation.getContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getContainerPreemptions());
        }
        if (allocation.getStrictContainerPreemptions() != null) {
            preemptionContainers.addAll(allocation.getStrictContainerPreemptions());
        }
        if (!preemptionContainers.isEmpty()) {
            for (ContainerId containerId : preemptionContainers) {
                if (this.preemptionContainerMap.containsKey(containerId)) continue;
                Container container = null;
                for (RMContainer c : report.getLiveContainers()) {
                    if (!c.getContainerId().equals((Object)containerId)) continue;
                    container = c.getContainer();
                    break;
                }
                if (container == null) continue;
                this.preemptionContainerMap.put(containerId, container.getResource());
            }
        }
        SortedMap sortedMap = this.metrics.getCounters();
        String[] names = new String[]{"counter.queue." + queueName + ".pending.memory", "counter.queue." + queueName + ".pending.cores", "counter.queue." + queueName + ".allocated.memory", "counter.queue." + queueName + ".allocated.cores"};
        int[] values = new int[]{pendingResource.getMemory(), pendingResource.getVirtualCores(), allocatedResource.getMemory(), allocatedResource.getVirtualCores()};
        for (int i = names.length - 1; i >= 0; --i) {
            void var10_14;
            if (!var10_14.containsKey(names[i])) {
                this.metrics.counter(names[i]);
                SortedMap sortedMap2 = this.metrics.getCounters();
            }
            ((Counter)var10_14.get(names[i])).inc((long)values[i]);
        }
        this.queueLock.lock();
        try {
            if (!this.schedulerMetrics.isTracked(queueName)) {
                this.schedulerMetrics.trackQueue(queueName);
            }
        }
        finally {
            this.queueLock.unlock();
        }
    }

    private void tearDown() throws IOException {
        if (this.jobRuntimeLogBW != null) {
            this.jobRuntimeLogBW.close();
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    private void initMetrics() throws Exception {
        this.metrics = new MetricRegistry();
        this.metricsOutputDir = this.conf.get("yarn.sls.metrics.output");
        int metricsWebAddressPort = this.conf.getInt("yarn.sls.metrics.web.address.port", 10001);
        String schedulerMetricsType = this.conf.get(CapacityScheduler.class.getName());
        Class schedulerMetricsClass = schedulerMetricsType == null ? defaultSchedulerMetricsMap.get(CapacityScheduler.class) : Class.forName(schedulerMetricsType);
        this.schedulerMetrics = (SchedulerMetrics)ReflectionUtils.newInstance((Class)schedulerMetricsClass, (Configuration)new Configuration());
        this.schedulerMetrics.init((ResourceScheduler)this, this.metrics);
        this.registerJvmMetrics();
        this.registerClusterResourceMetrics();
        this.registerContainerAppNumMetrics();
        this.registerSchedulerMetrics();
        this.initMetricsCSVOutput();
        this.web = new SLSWebApp(this, metricsWebAddressPort);
        this.web.start();
        this.pool = new ScheduledThreadPoolExecutor(2);
        this.pool.scheduleAtFixedRate(new HistogramsRunnable(), 0L, 1000L, TimeUnit.MILLISECONDS);
        this.pool.scheduleAtFixedRate(new MetricsLogRunnable(), 0L, 1000L, TimeUnit.MILLISECONDS);
        this.jobRuntimeLogBW = new BufferedWriter(new FileWriter(this.metricsOutputDir + "/jobruntime.csv"));
        this.jobRuntimeLogBW.write("JobID,real_start_time,real_end_time,simulate_start_time,simulate_end_time" + EOL);
        this.jobRuntimeLogBW.flush();
    }

    private void registerJvmMetrics() {
        this.metrics.register("variable.jvm.free.memory", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return Runtime.getRuntime().freeMemory();
            }
        });
        this.metrics.register("variable.jvm.max.memory", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return Runtime.getRuntime().maxMemory();
            }
        });
        this.metrics.register("variable.jvm.total.memory", (Metric)new Gauge<Long>(){

            public Long getValue() {
                return Runtime.getRuntime().totalMemory();
            }
        });
    }

    private void registerClusterResourceMetrics() {
        this.metrics.register("variable.cluster.allocated.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SLSCapacityScheduler.this.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SLSCapacityScheduler.this.getRootQueueMetrics().getAllocatedMB();
            }
        });
        this.metrics.register("variable.cluster.allocated.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SLSCapacityScheduler.this.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SLSCapacityScheduler.this.getRootQueueMetrics().getAllocatedVirtualCores();
            }
        });
        this.metrics.register("variable.cluster.available.memory", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SLSCapacityScheduler.this.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SLSCapacityScheduler.this.getRootQueueMetrics().getAvailableMB();
            }
        });
        this.metrics.register("variable.cluster.available.vcores", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SLSCapacityScheduler.this.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SLSCapacityScheduler.this.getRootQueueMetrics().getAvailableVirtualCores();
            }
        });
    }

    private void registerContainerAppNumMetrics() {
        this.metrics.register("variable.running.application", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SLSCapacityScheduler.this.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SLSCapacityScheduler.this.getRootQueueMetrics().getAppsRunning();
            }
        });
        this.metrics.register("variable.running.container", (Metric)new Gauge<Integer>(){

            public Integer getValue() {
                if (SLSCapacityScheduler.this.getRootQueueMetrics() == null) {
                    return 0;
                }
                return SLSCapacityScheduler.this.getRootQueueMetrics().getAllocatedContainers();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSchedulerMetrics() {
        this.samplerLock.lock();
        try {
            this.schedulerAllocateCounter = this.metrics.counter("counter.scheduler.operation.allocate");
            this.schedulerHandleCounter = this.metrics.counter("counter.scheduler.operation.handle");
            this.schedulerHandleCounterMap = new HashMap<SchedulerEventType, Counter>();
            for (SchedulerEventType e : SchedulerEventType.values()) {
                Counter counter = this.metrics.counter("counter.scheduler.operation.handle." + e);
                this.schedulerHandleCounterMap.put(e, counter);
            }
            int timeWindowSize = this.conf.getInt("yarn.sls.metrics.timer.window.size", 100);
            this.schedulerAllocateTimer = new Timer((Reservoir)new SlidingWindowReservoir(timeWindowSize));
            this.schedulerHandleTimer = new Timer((Reservoir)new SlidingWindowReservoir(timeWindowSize));
            this.schedulerHandleTimerMap = new HashMap<SchedulerEventType, Timer>();
            for (SchedulerEventType e : SchedulerEventType.values()) {
                Timer timer = new Timer((Reservoir)new SlidingWindowReservoir(timeWindowSize));
                this.schedulerHandleTimerMap.put(e, timer);
            }
            this.schedulerHistogramList = new ArrayList<Histogram>();
            this.histogramTimerMap = new HashMap<Histogram, Timer>();
            Histogram schedulerAllocateHistogram = new Histogram((Reservoir)new SlidingWindowReservoir(60));
            this.metrics.register("sampler.scheduler.operation.allocate.timecost", (Metric)schedulerAllocateHistogram);
            this.schedulerHistogramList.add(schedulerAllocateHistogram);
            this.histogramTimerMap.put(schedulerAllocateHistogram, this.schedulerAllocateTimer);
            Histogram schedulerHandleHistogram = new Histogram((Reservoir)new SlidingWindowReservoir(60));
            this.metrics.register("sampler.scheduler.operation.handle.timecost", (Metric)schedulerHandleHistogram);
            this.schedulerHistogramList.add(schedulerHandleHistogram);
            this.histogramTimerMap.put(schedulerHandleHistogram, this.schedulerHandleTimer);
            for (SchedulerEventType e : SchedulerEventType.values()) {
                Histogram histogram = new Histogram((Reservoir)new SlidingWindowReservoir(60));
                this.metrics.register("sampler.scheduler.operation.handle." + e + ".timecost", (Metric)histogram);
                this.schedulerHistogramList.add(histogram);
                this.histogramTimerMap.put(histogram, this.schedulerHandleTimerMap.get(e));
            }
        }
        finally {
            this.samplerLock.unlock();
        }
    }

    private void initMetricsCSVOutput() {
        int timeIntervalMS = this.conf.getInt("yarn.sls.metrics.record.interval.ms", 1000);
        File dir = new File(this.metricsOutputDir + "/metrics");
        if (!dir.exists() && !dir.mkdirs()) {
            this.LOG.error("Cannot create directory " + dir.getAbsoluteFile());
        }
        CsvReporter reporter = CsvReporter.forRegistry((MetricRegistry)this.metrics).formatFor(Locale.US).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(new File(this.metricsOutputDir + "/metrics"));
        reporter.start((long)timeIntervalMS, TimeUnit.MILLISECONDS);
    }

    @Override
    public void addAMRuntime(ApplicationId appId, long traceStartTimeMS, long traceEndTimeMS, long simulateStartTimeMS, long simulateEndTimeMS) {
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(appId).append(",").append(traceStartTimeMS).append(",").append(traceEndTimeMS).append(",").append(simulateStartTimeMS).append(",").append(simulateEndTimeMS);
            this.jobRuntimeLogBW.write(sb.toString() + EOL);
            this.jobRuntimeLogBW.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void updateQueueMetrics(String queue, int releasedMemory, int releasedVCores) {
        String name;
        SortedMap counterMap = this.metrics.getCounters();
        if (releasedMemory != 0) {
            name = "counter.queue." + queue + ".allocated.memory";
            if (!counterMap.containsKey(name)) {
                this.metrics.counter(name);
                counterMap = this.metrics.getCounters();
            }
            ((Counter)counterMap.get(name)).inc((long)(-releasedMemory));
        }
        if (releasedVCores != 0) {
            name = "counter.queue." + queue + ".allocated.cores";
            if (!counterMap.containsKey(name)) {
                this.metrics.counter(name);
                counterMap = this.metrics.getCounters();
            }
            ((Counter)counterMap.get(name)).inc((long)(-releasedVCores));
        }
    }

    @Override
    public void setQueueSet(Set<String> queues) {
        this.queueSet = queues;
    }

    @Override
    public Set<String> getQueueSet() {
        return this.queueSet;
    }

    @Override
    public void setTrackedAppSet(Set<String> apps) {
        this.trackedAppSet = apps;
    }

    @Override
    public Set<String> getTrackedAppSet() {
        return this.trackedAppSet;
    }

    @Override
    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    @Override
    public SchedulerMetrics getSchedulerMetrics() {
        return this.schedulerMetrics;
    }

    @Override
    public void addTrackedApp(ApplicationAttemptId appAttemptId, String oldAppId) {
        if (this.metricsON) {
            this.schedulerMetrics.trackApp(appAttemptId, oldAppId);
        }
    }

    @Override
    public void removeTrackedApp(ApplicationAttemptId appAttemptId, String oldAppId) {
        if (this.metricsON) {
            this.schedulerMetrics.untrackApp(appAttemptId, oldAppId);
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    static {
        defaultSchedulerMetricsMap.put(FairScheduler.class, FairSchedulerMetrics.class);
        defaultSchedulerMetricsMap.put(FifoScheduler.class, FifoSchedulerMetrics.class);
        defaultSchedulerMetricsMap.put(CapacityScheduler.class, CapacitySchedulerMetrics.class);
    }

    class MetricsLogRunnable
    implements Runnable {
        private boolean firstLine = true;

        public MetricsLogRunnable() {
            try {
                SLSCapacityScheduler.this.metricsLogBW = new BufferedWriter(new FileWriter(SLSCapacityScheduler.this.metricsOutputDir + "/realtimetrack.json"));
                SLSCapacityScheduler.this.metricsLogBW.write("[");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            if (SLSCapacityScheduler.this.running) {
                String metrics = SLSCapacityScheduler.this.web.generateRealTimeTrackingMetrics();
                try {
                    if (this.firstLine) {
                        SLSCapacityScheduler.this.metricsLogBW.write(metrics + EOL);
                        this.firstLine = false;
                    } else {
                        SLSCapacityScheduler.this.metricsLogBW.write("," + metrics + EOL);
                    }
                    SLSCapacityScheduler.this.metricsLogBW.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class HistogramsRunnable
    implements Runnable {
        HistogramsRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SLSCapacityScheduler.this.samplerLock.lock();
            try {
                for (Histogram histogram : SLSCapacityScheduler.this.schedulerHistogramList) {
                    Timer timer = SLSCapacityScheduler.this.histogramTimerMap.get(histogram);
                    histogram.update((int)timer.getSnapshot().getMean());
                }
            }
            finally {
                SLSCapacityScheduler.this.samplerLock.unlock();
            }
        }
    }
}

