/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomSeedGenerator {
    private static Logger LOG = LoggerFactory.getLogger(RandomSeedGenerator.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final ThreadLocal<MessageDigest> md5Holder = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            MessageDigest md5 = null;
            try {
                md5 = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new RuntimeException("Can't create MD5 digests", nsae);
            }
            return md5;
        }
    };

    public static long getSeed(String streamId, long masterSeed) {
        MessageDigest md5 = md5Holder.get();
        md5.reset();
        String str = streamId + "/" + masterSeed;
        byte[] digest = md5.digest(str.getBytes(UTF_8));
        long seed = 0L;
        for (int i = 0; i < 8; ++i) {
            seed = (seed << 8) + (long)(digest[i] + 128);
        }
        return seed;
    }
}

