/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.cli;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.apache.hadoop.registry.AbstractRegistryTest;
import org.apache.hadoop.registry.cli.RegistryCli;
import org.apache.hadoop.registry.operations.TestRegistryOperations;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRegistryCli
extends AbstractRegistryTest {
    protected static final Logger LOG = LoggerFactory.getLogger(TestRegistryOperations.class);
    private ByteArrayOutputStream sysOutStream;
    private PrintStream sysOut;
    private ByteArrayOutputStream sysErrStream;
    private PrintStream sysErr;
    private RegistryCli cli;

    @Before
    public void setUp() throws Exception {
        this.sysOutStream = new ByteArrayOutputStream();
        this.sysOut = new PrintStream(this.sysOutStream);
        this.sysErrStream = new ByteArrayOutputStream();
        this.sysErr = new PrintStream(this.sysErrStream);
        System.setOut(this.sysOut);
        this.cli = new RegistryCli(this.operations, this.createRegistryConfiguration(), this.sysOut, this.sysErr);
    }

    @After
    public void tearDown() throws Exception {
        this.cli.close();
    }

    private void assertResult(RegistryCli cli, int code, String ... args) throws Exception {
        int result = cli.run(args);
        TestRegistryCli.assertEquals((long)code, (long)result);
    }

    @Test
    public void testBadCommands() throws Exception {
        this.assertResult(this.cli, -1, new String[0]);
        this.assertResult(this.cli, -1, "foo");
    }

    @Test
    public void testInvalidNumArgs() throws Exception {
        this.assertResult(this.cli, -1, "ls");
        this.assertResult(this.cli, -1, "ls", "/path", "/extraPath");
        this.assertResult(this.cli, -1, "resolve");
        this.assertResult(this.cli, -1, "resolve", "/path", "/extraPath");
        this.assertResult(this.cli, -1, "mknode");
        this.assertResult(this.cli, -1, "mknode", "/path", "/extraPath");
        this.assertResult(this.cli, -1, "rm");
        this.assertResult(this.cli, -1, "rm", "/path", "/extraPath");
        this.assertResult(this.cli, -1, "bind");
        this.assertResult(this.cli, -1, "bind", "foo");
        this.assertResult(this.cli, -1, "bind", "-inet", "foo");
        this.assertResult(this.cli, -1, "bind", "-inet", "-api", "-p", "378", "-h", "host", "/foo");
        this.assertResult(this.cli, -1, "bind", "-inet", "-api", "Api", "-p", "-h", "host", "/foo");
        this.assertResult(this.cli, -1, "bind", "-inet", "-api", "Api", "-p", "378", "-h", "/foo");
        this.assertResult(this.cli, -1, "bind", "-inet", "-api", "Api", "-p", "378", "-h", "host");
        this.assertResult(this.cli, -1, "bind", "-api", "Api", "-p", "378", "-h", "host", "/foo");
        this.assertResult(this.cli, -1, "bind", "-webui", "foo");
        this.assertResult(this.cli, -1, "bind", "-webui", "-api", "Api", "/foo");
        this.assertResult(this.cli, -1, "bind", "-webui", "uriString", "-api", "/foo");
        this.assertResult(this.cli, -1, "bind", "-webui", "uriString", "-api", "Api");
        this.assertResult(this.cli, -1, "bind", "-rest", "foo");
        this.assertResult(this.cli, -1, "bind", "-rest", "uriString", "-api", "Api");
        this.assertResult(this.cli, -1, "bind", "-rest", "-api", "Api", "/foo");
        this.assertResult(this.cli, -1, "bind", "-rest", "uriString", "-api", "/foo");
        this.assertResult(this.cli, -1, "bind", "uriString", "-api", "Api", "/foo");
    }

    @Test
    public void testBadArgType() throws Exception {
        this.assertResult(this.cli, -1, "bind", "-inet", "-api", "Api", "-p", "fooPort", "-h", "host", "/dir");
    }

    @Test
    public void testBadPath() throws Exception {
        this.assertResult(this.cli, -1, "ls", "NonSlashPath");
        this.assertResult(this.cli, -1, "ls", "//");
        this.assertResult(this.cli, -1, "resolve", "NonSlashPath");
        this.assertResult(this.cli, -1, "resolve", "//");
        this.assertResult(this.cli, -1, "mknode", "NonSlashPath");
        this.assertResult(this.cli, -1, "mknode", "//");
        this.assertResult(this.cli, -1, "rm", "NonSlashPath");
        this.assertResult(this.cli, -1, "rm", "//");
        this.assertResult(this.cli, -1, "bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "NonSlashPath");
        this.assertResult(this.cli, -1, "bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "//");
        this.assertResult(this.cli, -1, "bind", "-webui", "uriString", "-api", "Api", "NonSlashPath");
        this.assertResult(this.cli, -1, "bind", "-webui", "uriString", "-api", "Api", "//");
        this.assertResult(this.cli, -1, "bind", "-rest", "uriString", "-api", "Api", "NonSlashPath");
        this.assertResult(this.cli, -1, "bind", "-rest", "uriString", "-api", "Api", "//");
    }

    @Test
    public void testNotExistingPaths() throws Exception {
        this.assertResult(this.cli, -1, "ls", "/nonexisting_path");
        this.assertResult(this.cli, -1, "ls", "/NonExistingDir/nonexisting_path");
        this.assertResult(this.cli, -1, "resolve", "/nonexisting_path");
        this.assertResult(this.cli, -1, "resolve", "/NonExistingDir/nonexisting_path");
        this.assertResult(this.cli, -1, "bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "/NonExistingDir/nonexisting_path");
        this.assertResult(this.cli, -1, "bind", "-webui", "uriString", "-api", "Api", "/NonExistingDir/nonexisting_path");
        this.assertResult(this.cli, -1, "bind", "-rest", "uriString", "-api", "Api", "/NonExistingDir/nonexisting_path");
    }

    @Test
    public void testValidCommands() throws Exception {
        this.assertResult(this.cli, 0, "bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "/foo");
        this.assertResult(this.cli, 0, "resolve", "/foo");
        this.assertResult(this.cli, 0, "rm", "/foo");
        this.assertResult(this.cli, -1, "resolve", "/foo");
        this.assertResult(this.cli, 0, "bind", "-webui", "uriString", "-api", "Api", "/foo");
        this.assertResult(this.cli, 0, "resolve", "/foo");
        this.assertResult(this.cli, 0, "rm", "/foo");
        this.assertResult(this.cli, -1, "resolve", "/foo");
        this.assertResult(this.cli, 0, "bind", "-rest", "uriString", "-api", "Api", "/foo");
        this.assertResult(this.cli, 0, "resolve", "/foo");
        this.assertResult(this.cli, 0, "rm", "/foo");
        this.assertResult(this.cli, -1, "resolve", "/foo");
        this.assertResult(this.cli, 0, "mknode", "/subdir");
        this.assertResult(this.cli, -1, "resolve", "/subdir");
        this.assertResult(this.cli, 0, "bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "/subdir/foo");
        this.assertResult(this.cli, 0, "resolve", "/subdir/foo");
        this.assertResult(this.cli, 0, "rm", "/subdir/foo");
        this.assertResult(this.cli, -1, "resolve", "/subdir/foo");
        this.assertResult(this.cli, 0, "bind", "-webui", "uriString", "-api", "Api", "/subdir/foo");
        this.assertResult(this.cli, 0, "resolve", "/subdir/foo");
        this.assertResult(this.cli, 0, "rm", "/subdir/foo");
        this.assertResult(this.cli, -1, "resolve", "/subdir/foo");
        this.assertResult(this.cli, 0, "bind", "-rest", "uriString", "-api", "Api", "/subdir/foo");
        this.assertResult(this.cli, 0, "resolve", "/subdir/foo");
        this.assertResult(this.cli, 0, "rm", "/subdir/foo");
        this.assertResult(this.cli, -1, "resolve", "/subdir/foo");
        this.assertResult(this.cli, 0, "rm", "/subdir");
        this.assertResult(this.cli, -1, "resolve", "/subdir");
        this.assertResult(this.cli, 0, "mknode", "/dir");
        this.assertResult(this.cli, -1, "resolve", "/dir");
        this.assertResult(this.cli, 0, "bind", "-inet", "-api", "Api", "-p", "378", "-h", "host", "/dir");
        this.assertResult(this.cli, 0, "resolve", "/dir");
        this.assertResult(this.cli, 0, "rm", "/dir");
        this.assertResult(this.cli, -1, "resolve", "/dir");
        this.assertResult(this.cli, 0, "mknode", "/dir");
        this.assertResult(this.cli, -1, "resolve", "/dir");
        this.assertResult(this.cli, 0, "bind", "-webui", "uriString", "-api", "Api", "/dir");
        this.assertResult(this.cli, 0, "resolve", "/dir");
        this.assertResult(this.cli, 0, "rm", "/dir");
        this.assertResult(this.cli, -1, "resolve", "/dir");
        this.assertResult(this.cli, 0, "mknode", "/dir");
        this.assertResult(this.cli, -1, "resolve", "/dir");
        this.assertResult(this.cli, 0, "bind", "-rest", "uriString", "-api", "Api", "/dir");
        this.assertResult(this.cli, 0, "resolve", "/dir");
        this.assertResult(this.cli, 0, "rm", "/dir");
        this.assertResult(this.cli, -1, "resolve", "/dir");
        this.assertResult(this.cli, 0, "rm", "/Nonexitent");
    }
}

