/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.secure;

import java.io.File;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.util.PlatformName;

class KerberosConfiguration
extends Configuration {
    private String principal;
    private String keytab;
    private boolean isInitiator;

    KerberosConfiguration(String principal, File keytab, boolean client) {
        this.principal = principal;
        this.keytab = keytab.getAbsolutePath();
        this.isInitiator = client;
    }

    public static Configuration createClientConfig(String principal, File keytab) {
        return new KerberosConfiguration(principal, keytab, true);
    }

    public static Configuration createServerConfig(String principal, File keytab) {
        return new KerberosConfiguration(principal, keytab, false);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        HashMap<String, String> options = new HashMap<String, String>();
        if (PlatformName.IBM_JAVA) {
            options.put("useKeytab", this.keytab.startsWith("file://") ? this.keytab : "file://" + this.keytab);
            options.put("principal", this.principal);
            options.put("refreshKrb5Config", "true");
            options.put("credsType", "both");
        } else {
            options.put("keyTab", this.keytab);
            options.put("principal", this.principal);
            options.put("useKeyTab", "true");
            options.put("storeKey", "true");
            options.put("doNotPrompt", "true");
            options.put("useTicketCache", "true");
            options.put("renewTGT", "true");
            options.put("refreshKrb5Config", "true");
            options.put("isInitiator", Boolean.toString(this.isInitiator));
        }
        String ticketCache = System.getenv("KRB5CCNAME");
        if (ticketCache != null) {
            if (PlatformName.IBM_JAVA) {
                System.setProperty("KRB5CCNAME", ticketCache);
                options.put("useDefaultCcache", "true");
                options.put("renewTGT", "true");
            } else {
                options.put("ticketCache", ticketCache);
            }
        }
        options.put("debug", "true");
        return new AppConfigurationEntry[]{new AppConfigurationEntry(KerberosUtil.getKrb5LoginModuleName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options)};
    }

    public String toString() {
        return "KerberosConfiguration with principal " + this.principal;
    }
}

