/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.fs.PathId;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.DirectShuffleMetaData;
import org.apache.hadoop.maprfs.MapRPathId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapRDirectShuffleMetaData
implements DirectShuffleMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(MapRDirectShuffleMetaData.class);
    private String nmHostName;
    private Map<String, PathId> mrDirPathIds = new HashMap<String, PathId>();

    public void setNodeManageHostName(String hostName) {
        this.nmHostName = hostName;
    }

    public void putDirPathId(String dir, PathId pathId) {
        this.mrDirPathIds.put(dir, pathId);
    }

    @Override
    public String getNodeManagerHostName() {
        return this.nmHostName;
    }

    @Override
    public Map<String, PathId> getMapReduceDirsPathIds() {
        return this.mrDirPathIds;
    }

    public void write(DataOutput out) throws IOException {
        LOG.debug("Writing metadata {} to binary stream. Hostname: {}, mrDirPathIds size: {}", new Object[]{this, this.nmHostName, this.mrDirPathIds.size()});
        WritableUtils.writeString((DataOutput)out, (String)this.nmHostName);
        WritableUtils.writeVInt((DataOutput)out, (int)this.mrDirPathIds.size());
        for (String dirName : this.mrDirPathIds.keySet()) {
            LOG.debug("Writing metadata {} to binary stream. DirName: {}, mrDirPathIds Fid: {}, Ips: {}", new Object[]{this, dirName, this.mrDirPathIds.get(dirName).getFid(), Arrays.toString(this.mrDirPathIds.get(dirName).getIPs())});
            WritableUtils.writeString((DataOutput)out, (String)dirName);
            this.mrDirPathIds.get(dirName).writeFields(out);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.nmHostName = WritableUtils.readString((DataInput)in);
        int size = WritableUtils.readVInt((DataInput)in);
        LOG.debug("Reading metadata {} to binary stream. Hostname: {}, mrDirPathIds size: {}", new Object[]{this, this.nmHostName, size});
        for (int i = 0; i < size; ++i) {
            String dirName = WritableUtils.readString((DataInput)in);
            MapRPathId pathId = new MapRPathId();
            pathId.readFields(in);
            this.mrDirPathIds.put(dirName, (PathId)pathId);
            LOG.debug("Reading metadata {} to binary stream. DirName: {}, mrDirPathIds Fid: {}, Ips: {}", new Object[]{this, dirName, this.mrDirPathIds.get(dirName).getFid(), Arrays.toString(this.mrDirPathIds.get(dirName).getIPs())});
        }
    }
}

