/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.delegation.web.HttpUserGroupInformation;

@InterfaceAudience.Private
public class KMSMDCFilter
implements Filter {
    private static final ThreadLocal<Data> DATA_TL = new ThreadLocal();

    public static UserGroupInformation getUgi() {
        Data data = DATA_TL.get();
        return data != null ? data.ugi : null;
    }

    public static String getMethod() {
        Data data = DATA_TL.get();
        return data != null ? data.method : null;
    }

    public static String getURL() {
        Data data = DATA_TL.get();
        return data != null ? data.url : null;
    }

    public static String getRemoteClientAddress() {
        Data data = DATA_TL.get();
        return data != null ? data.remoteClientAddress : null;
    }

    public void init(FilterConfig config) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            KMSMDCFilter.clearContext();
            UserGroupInformation ugi = HttpUserGroupInformation.get();
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            String method = httpServletRequest.getMethod();
            StringBuffer requestURL = httpServletRequest.getRequestURL();
            String queryString = httpServletRequest.getQueryString();
            if (queryString != null) {
                requestURL.append("?").append(queryString);
            }
            KMSMDCFilter.setContext(ugi, method, requestURL.toString(), request.getRemoteAddr());
            chain.doFilter(request, response);
        }
        finally {
            KMSMDCFilter.clearContext();
        }
    }

    public void destroy() {
    }

    @VisibleForTesting
    public static void setContext(UserGroupInformation ugi, String method, String requestURL, String remoteAddr) {
        DATA_TL.set(new Data(ugi, method, requestURL, remoteAddr));
    }

    private static void clearContext() {
        DATA_TL.remove();
    }

    private static class Data {
        private final UserGroupInformation ugi;
        private final String method;
        private final String url;
        private final String remoteClientAddress;

        private Data(UserGroupInformation ugi, String method, String url, String remoteClientAddress) {
            this.ugi = ugi;
            this.method = method;
            this.url = url;
            this.remoteClientAddress = remoteClientAddress;
        }
    }
}

