/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key.kms.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.kms.server.KMSConfiguration;
import org.apache.hadoop.crypto.key.kms.server.KMSWebServer;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.ThreadUtil;

public class MiniKMS {
    private String kmsConfDir;
    private String log4jConfFile;
    private String keyStore;
    private String keyStorePassword;
    private KMSWebServer jetty;
    private int inPort;
    private URL kmsURL;

    public MiniKMS(String kmsConfDir, String log4ConfFile, String keyStore, String password, int inPort) {
        this.kmsConfDir = kmsConfDir;
        this.log4jConfFile = log4ConfFile;
        this.keyStore = keyStore;
        this.keyStorePassword = password;
        this.inPort = inPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String inputResourceName, File outputFile) throws IOException {
        InputStream is = ThreadUtil.getResourceAsStream((String)inputResourceName);
        try (FileOutputStream os = new FileOutputStream(outputFile);){
            IOUtils.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public void start() throws Exception {
        File kmsFile;
        File coreFile;
        System.setProperty("kms.config.dir", this.kmsConfDir);
        File aclsFile = new File(this.kmsConfDir, "kms-acls.xml");
        if (!aclsFile.exists()) {
            this.copyResource("mini-kms-acls-default.xml", aclsFile);
        }
        if (!(coreFile = new File(this.kmsConfDir, "core-site.xml")).exists()) {
            Configuration core = new Configuration();
            FileWriter writer = new FileWriter(coreFile);
            core.writeXml((Writer)writer);
            ((Writer)writer).close();
        }
        if (!(kmsFile = new File(this.kmsConfDir, "kms-site.xml")).exists()) {
            Configuration kms = new Configuration(false);
            kms.set("hadoop.kms.key.provider.uri", "jceks://file@" + new Path(this.kmsConfDir, "kms.keystore").toUri());
            kms.set("hadoop.kms.authentication.type", "simple");
            FileWriter writer = new FileWriter(kmsFile);
            kms.writeXml((Writer)writer);
            ((Writer)writer).close();
        }
        System.setProperty("log4j.configuration", this.log4jConfFile);
        Configuration conf = KMSConfiguration.getKMSConf();
        conf.set("hadoop.kms.http.host", "localhost");
        conf.setInt("hadoop.kms.http.port", this.inPort);
        Configuration sslConf = null;
        if (this.keyStore != null) {
            conf.setBoolean("hadoop.kms.ssl.enabled", true);
            sslConf = SSLFactory.readSSLConfiguration((Configuration)conf, (SSLFactory.Mode)SSLFactory.Mode.SERVER);
            sslConf.set("ssl.server.keystore.location", this.keyStore);
            sslConf.set("ssl.server.keystore.password", this.keyStorePassword);
            sslConf.set("ssl.server.keystore.type", "jks");
        }
        this.jetty = new KMSWebServer(conf, sslConf);
        this.jetty.start();
        this.kmsURL = this.jetty.getKMSUrl();
    }

    public URL getKMSUrl() {
        return this.kmsURL;
    }

    public void stop() {
        if (this.jetty != null && this.jetty.isRunning()) {
            try {
                this.jetty.stop();
                this.jetty = null;
            }
            catch (Exception ex) {
                throw new RuntimeException("Could not stop MiniKMS embedded Jetty, " + ex.getMessage(), ex);
            }
        }
    }

    public static class Builder {
        private File kmsConfDir = new File("target/test-classes").getAbsoluteFile();
        private String log4jConfFile = "kms-log4j.properties";
        private File keyStoreFile;
        private String keyStorePassword;
        private int inPort;

        public Builder setKmsConfDir(File confDir) {
            Preconditions.checkNotNull((Object)confDir, (Object)"KMS conf dir is NULL");
            Preconditions.checkArgument((boolean)confDir.exists(), (Object)"KMS conf dir does not exist");
            this.kmsConfDir = confDir;
            return this;
        }

        public Builder setLog4jConfFile(String log4jConfFile) {
            Preconditions.checkNotNull((Object)log4jConfFile, (Object)"log4jconf file is NULL");
            this.log4jConfFile = log4jConfFile;
            return this;
        }

        public Builder setPort(int port) {
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"input port must be greater than 0");
            this.inPort = port;
            return this;
        }

        public Builder setSslConf(File keyStoreFile, String keyStorePassword) {
            Preconditions.checkNotNull((Object)keyStoreFile, (Object)"keystore file is NULL");
            Preconditions.checkNotNull((Object)keyStorePassword, (Object)"keystore password is NULL");
            Preconditions.checkArgument((boolean)keyStoreFile.exists(), (Object)"keystore file does not exist");
            this.keyStoreFile = keyStoreFile;
            this.keyStorePassword = keyStorePassword;
            return this;
        }

        public MiniKMS build() {
            Preconditions.checkArgument((boolean)this.kmsConfDir.exists(), (Object)"KMS conf dir does not exist");
            return new MiniKMS(this.kmsConfDir.getAbsolutePath(), this.log4jConfFile, this.keyStoreFile != null ? this.keyStoreFile.getAbsolutePath() : null, this.keyStorePassword, this.inPort);
        }
    }
}

