/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink;

import java.io.File;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.sink.RollingFileSystemSink;
import org.apache.hadoop.metrics2.sink.RollingFileSystemSinkTestBase;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.NullGroupsMapping;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class TestRollingFileSystemSinkWithSecureHdfs
extends RollingFileSystemSinkTestBase {
    private static final int NUM_DATANODES = 4;
    private static MiniKdc kdc;
    private static String sinkPrincipal;
    private static String sinkKeytab;
    private static String hdfsPrincipal;
    private static String hdfsKeytab;
    private static String spnegoPrincipal;
    private MiniDFSCluster cluster = null;
    private UserGroupInformation sink = null;

    @BeforeClass
    public static void initKdc() throws Exception {
        Properties kdcConf = MiniKdc.createConf();
        kdc = new MiniKdc(kdcConf, ROOT_TEST_DIR);
        kdc.start();
        File sinkKeytabFile = new File(ROOT_TEST_DIR, "sink.keytab");
        sinkKeytab = sinkKeytabFile.getAbsolutePath();
        kdc.createPrincipal(sinkKeytabFile, new String[]{"sink/localhost"});
        sinkPrincipal = "sink/localhost@" + kdc.getRealm();
        File hdfsKeytabFile = new File(ROOT_TEST_DIR, "hdfs.keytab");
        hdfsKeytab = hdfsKeytabFile.getAbsolutePath();
        kdc.createPrincipal(hdfsKeytabFile, new String[]{"hdfs/localhost", "HTTP/localhost"});
        hdfsPrincipal = "hdfs/localhost@" + kdc.getRealm();
        spnegoPrincipal = "HTTP/localhost@" + kdc.getRealm();
    }

    @Before
    public void initCluster() throws Exception {
        HdfsConfiguration conf = this.createSecureConfig("authentication,privacy");
        RollingFileSystemSink.hasFlushed = false;
        RollingFileSystemSink.suppliedConf = conf;
        this.cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(4).build();
        this.cluster.waitActive();
        this.createDirectoriesSecurely();
    }

    @After
    public void stopCluster() {
        if (this.cluster != null) {
            this.cluster.shutdown();
        }
        UserGroupInformation.setConfiguration((Configuration)new Configuration());
        RollingFileSystemSink.suppliedConf = null;
        RollingFileSystemSink.suppliedFilesystem = null;
    }

    @AfterClass
    public static void shutdownKdc() {
        if (kdc != null) {
            kdc.stop();
        }
    }

    @Test
    public void testWithSecureHDFS() throws Exception {
        final String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp/test";
        final MetricsSystem ms = this.initMetricsSystem(path, true, false, true);
        this.assertMetricsContents((String)this.sink.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                return TestRollingFileSystemSinkWithSecureHdfs.this.doWriteTest(ms, path, 1);
            }
        }));
    }

    @Test
    public void testMissingPropertiesWithSecureHDFS() throws Exception {
        String path = "hdfs://" + this.cluster.getNameNode().getHostAndPort() + "/tmp/test";
        this.initMetricsSystem(path, true, false);
        Assert.assertTrue((String)"No exception was generated initializing the sink against a secure cluster even though the principal and keytab properties were missing", (boolean)RollingFileSystemSinkTestBase.MockSink.errored);
    }

    protected void createDirectoriesSecurely() throws IOException, InterruptedException {
        Path tmp = new Path("/tmp");
        Path test = new Path(tmp, "test");
        UserGroupInformation hdfs = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)hdfsPrincipal, (String)hdfsKeytab);
        FileSystem fsForSuperUser = (FileSystem)hdfs.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return TestRollingFileSystemSinkWithSecureHdfs.this.cluster.getFileSystem();
            }
        });
        fsForSuperUser.mkdirs(tmp);
        fsForSuperUser.setPermission(tmp, new FsPermission(511));
        this.sink = UserGroupInformation.loginUserFromKeytabAndReturnUGI((String)sinkPrincipal, (String)sinkKeytab);
        FileSystem fsForSink = (FileSystem)this.sink.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(){

            @Override
            public FileSystem run() throws Exception {
                return TestRollingFileSystemSinkWithSecureHdfs.this.cluster.getFileSystem();
            }
        });
        fsForSink.mkdirs(test);
        RollingFileSystemSink.suppliedFilesystem = fsForSink;
    }

    protected HdfsConfiguration createSecureConfig(String dataTransferProtection) throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        SecurityUtil.setAuthenticationMethod((UserGroupInformation.AuthenticationMethod)UserGroupInformation.AuthenticationMethod.KERBEROS, (Configuration)conf);
        conf.set("dfs.namenode.kerberos.principal", hdfsPrincipal);
        conf.set("dfs.namenode.keytab.file", hdfsKeytab);
        conf.set("dfs.datanode.kerberos.principal", hdfsPrincipal);
        conf.set("dfs.datanode.keytab.file", hdfsKeytab);
        conf.set("rfssink.principal", sinkPrincipal);
        conf.set("rfssink.keytab", sinkKeytab);
        conf.set("dfs.web.authentication.kerberos.principal", spnegoPrincipal);
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.data.transfer.protection", dataTransferProtection);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        conf.setInt("ipc.client.connect.max.retries.on.sasl", 10);
        conf.set("hadoop.security.group.mapping", NullGroupsMapping.class.getName());
        String keystoresDir = methodDir.getAbsolutePath();
        String sslConfDir = KeyStoreTestUtil.getClasspathDir(((Object)((Object)this)).getClass());
        KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
        conf.set("dfs.client.https.keystore.resource", KeyStoreTestUtil.getClientSSLConfigFileName());
        conf.set("dfs.https.server.keystore.resource", KeyStoreTestUtil.getServerSSLConfigFileName());
        return conf;
    }
}

