/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.ReconfigurationException;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.AddBlockFlag;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicy;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockPlacementPolicyDefault;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeStorageInfo;
import org.apache.hadoop.net.Node;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRefreshBlockPlacementPolicy {
    private MiniDFSCluster cluster;
    private Configuration config;
    private static int counter = 0;

    @Before
    public void setup() throws IOException {
        this.config = new Configuration();
        this.config.setClass("dfs.block.replicator.classname", MockBlockPlacementPolicy.class, BlockPlacementPolicy.class);
        this.config.setClass("dfs.block.placement.ec.classname", MockBlockPlacementPolicy.class, BlockPlacementPolicy.class);
        this.cluster = new MiniDFSCluster.Builder(this.config).numDataNodes(9).build();
        this.cluster.waitActive();
    }

    @After
    public void cleanup() throws IOException {
        this.cluster.shutdown();
    }

    @Test
    public void testRefreshReplicationPolicy() throws Exception {
        Path file = new Path("/test-file");
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        this.verifyRefreshPolicy(dfs, file, () -> this.cluster.getNameNode().reconfigurePropertyImpl("dfs.block.replicator.classname", null));
    }

    @Test
    public void testRefreshEcPolicy() throws Exception {
        Path ecDir = new Path("/ec");
        Path file = new Path("/ec/test-file");
        DistributedFileSystem dfs = this.cluster.getFileSystem();
        dfs.mkdir(ecDir, FsPermission.createImmutable((short)755));
        dfs.setErasureCodingPolicy(ecDir, null);
        this.verifyRefreshPolicy(dfs, file, () -> this.cluster.getNameNode().reconfigurePropertyImpl("dfs.block.placement.ec.classname", null));
    }

    private void verifyRefreshPolicy(DistributedFileSystem dfs, Path file, Refresh func) throws IOException, ReconfigurationException {
        int lastCounter = counter;
        FSDataOutputStream out = dfs.create(file, true);
        out.write("test".getBytes());
        out.close();
        assert (counter > lastCounter);
        func.refresh();
        lastCounter = counter;
        dfs.delete(file, true);
        out = dfs.create(file, true);
        out.write("test".getBytes());
        out.close();
        Assert.assertEquals((long)lastCounter, (long)counter);
    }

    @FunctionalInterface
    private static interface Refresh {
        public void refresh() throws ReconfigurationException;
    }

    static class MockBlockPlacementPolicy
    extends BlockPlacementPolicyDefault {
        MockBlockPlacementPolicy() {
        }

        public DatanodeStorageInfo[] chooseTarget(String srcPath, int numOfReplicas, Node writer, List<DatanodeStorageInfo> chosen, boolean returnChosenNodes, Set<Node> excludedNodes, long blocksize, BlockStoragePolicy storagePolicy, EnumSet<AddBlockFlag> flags) {
            counter++;
            return super.chooseTarget(srcPath, numOfReplicas, writer, chosen, returnChosenNodes, excludedNodes, blocksize, storagePolicy, flags);
        }
    }
}

