/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathHandle;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.server.common.FileRegion;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.blockaliasmap.BlockAliasMap;
import org.apache.hadoop.hdfs.server.datanode.BlockScanner;
import org.apache.hadoop.hdfs.server.datanode.DNConf;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataSetLockManager;
import org.apache.hadoop.hdfs.server.datanode.DataStorage;
import org.apache.hadoop.hdfs.server.datanode.DirectoryScanner;
import org.apache.hadoop.hdfs.server.datanode.FinalizedProvidedReplica;
import org.apache.hadoop.hdfs.server.datanode.ProvidedReplica;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.ShortCircuitRegistry;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.TestProvidedReplicaImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ProvidedVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.TestFsDatasetImpl;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestProvidedImpl {
    private static final Logger LOG = LoggerFactory.getLogger(TestFsDatasetImpl.class);
    private static final String BASE_DIR = new FileSystemTestHelper().getTestRootDir();
    private static final int NUM_LOCAL_INIT_VOLUMES = 1;
    private static final int NUM_PROVIDED_INIT_VOLUMES = 1;
    private static final String[] BLOCK_POOL_IDS = new String[]{"bpid-0", "bpid-1"};
    private static final int NUM_PROVIDED_BLKS = 10;
    private static final long BLK_LEN = 131072L;
    private static final int MIN_BLK_ID = 0;
    private static final int CHOSEN_BP_ID = 0;
    private static String providedBasePath = BASE_DIR;
    private Configuration conf;
    private DataNode datanode;
    private DataStorage storage;
    private FsDatasetImpl dataset;
    private DataSetLockManager manager = new DataSetLockManager();
    private static Map<Long, String> blkToPathMap;
    private static List<FsVolumeImpl> providedVolumes;
    private static long spaceUsed;

    private static Storage.StorageDirectory createLocalStorageDirectory(File root, Configuration conf) throws SecurityException, IOException {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(StorageLocation.parse((String)root.toURI().toString()));
        DataStorage.createStorageID((Storage.StorageDirectory)sd, (boolean)false, (Configuration)conf);
        return sd;
    }

    private static Storage.StorageDirectory createProvidedStorageDirectory(String confString, Configuration conf) throws SecurityException, IOException {
        Storage.StorageDirectory sd = new Storage.StorageDirectory(StorageLocation.parse((String)confString));
        DataStorage.createStorageID((Storage.StorageDirectory)sd, (boolean)false, (Configuration)conf);
        return sd;
    }

    private static void createStorageDirs(DataStorage storage, Configuration conf, int numDirs, int numProvidedDirs) throws IOException {
        File loc;
        int i;
        ArrayList<Storage.StorageDirectory> dirs = new ArrayList<Storage.StorageDirectory>();
        ArrayList<String> dirStrings = new ArrayList<String>();
        FileUtils.deleteDirectory((File)new File(BASE_DIR));
        for (i = 0; i < numDirs; ++i) {
            loc = new File(BASE_DIR, "data" + i);
            dirStrings.add(new Path(loc.toString()).toUri().toString());
            loc.mkdirs();
            dirs.add(TestProvidedImpl.createLocalStorageDirectory(loc, conf));
            Mockito.when((Object)storage.getStorageDir(i)).thenReturn((Object)((Storage.StorageDirectory)dirs.get(i)));
        }
        for (i = numDirs; i < numDirs + numProvidedDirs; ++i) {
            loc = new File(BASE_DIR, "data" + i);
            providedBasePath = loc.getAbsolutePath();
            loc.mkdirs();
            String dirString = "[PROVIDED]" + new Path(loc.toString()).toUri().toString();
            dirStrings.add(dirString);
            dirs.add(TestProvidedImpl.createProvidedStorageDirectory(dirString, conf));
            Mockito.when((Object)storage.getStorageDir(i)).thenReturn((Object)((Storage.StorageDirectory)dirs.get(i)));
        }
        String dataDir = StringUtils.join((CharSequence)",", dirStrings);
        conf.set("dfs.datanode.data.dir", dataDir);
        Mockito.when((Object)storage.dirIterator()).thenReturn(dirs.iterator());
        Mockito.when((Object)storage.getNumStorageDirs()).thenReturn((Object)(numDirs + numProvidedDirs));
    }

    private int getNumVolumes() {
        int n;
        block8: {
            FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();
            try {
                n = volumes.size();
                if (volumes == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (volumes != null) {
                        try {
                            volumes.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return 0;
                }
            }
            volumes.close();
        }
        return n;
    }

    @Before
    public void setUp() throws IOException {
        this.datanode = (DataNode)Mockito.mock(DataNode.class);
        this.storage = (DataStorage)Mockito.mock(DataStorage.class);
        this.conf = new Configuration();
        this.conf.setLong("dfs.datanode.scan.period.hours", 0L);
        Mockito.when((Object)this.datanode.getConf()).thenReturn((Object)this.conf);
        Mockito.when((Object)this.datanode.getDataSetLockManager()).thenReturn((Object)this.manager);
        DNConf dnConf = new DNConf((Configurable)this.datanode);
        Mockito.when((Object)this.datanode.getDnConf()).thenReturn((Object)dnConf);
        spaceUsed = 0L;
        BlockScanner disabledBlockScanner = new BlockScanner(this.datanode, this.conf);
        Mockito.when((Object)this.datanode.getBlockScanner()).thenReturn((Object)disabledBlockScanner);
        ShortCircuitRegistry shortCircuitRegistry = new ShortCircuitRegistry(this.conf);
        Mockito.when((Object)this.datanode.getShortCircuitRegistry()).thenReturn((Object)shortCircuitRegistry);
        this.conf.setClass("dfs.provided.aliasmap.class", TestFileRegionBlockAliasMap.class, BlockAliasMap.class);
        blkToPathMap = new HashMap<Long, String>();
        providedVolumes = new LinkedList<FsVolumeImpl>();
        TestProvidedImpl.createStorageDirs(this.storage, this.conf, 1, 1);
        this.dataset = new FsDatasetImpl(this.datanode, this.storage, this.conf);
        FsDatasetSpi.FsVolumeReferences volumes = this.dataset.getFsVolumeReferences();
        for (int i = 0; i < volumes.size(); ++i) {
            FsVolumeSpi vol = volumes.get(i);
            if (vol.getStorageType() != StorageType.PROVIDED) continue;
            providedVolumes.add((FsVolumeImpl)vol);
        }
        for (String bpid : BLOCK_POOL_IDS) {
            this.dataset.addBlockPool(bpid, this.conf);
        }
    }

    @Test
    public void testReserved() throws Exception {
        for (FsVolumeSpi fsVolumeSpi : providedVolumes) {
            Assert.assertEquals((long)0L, (long)((FsVolumeImpl)fsVolumeSpi).getReserved());
        }
    }

    @Test
    public void testProvidedVolumeImpl() throws IOException {
        Assert.assertEquals((long)2L, (long)this.getNumVolumes());
        Assert.assertEquals((long)1L, (long)providedVolumes.size());
        Assert.assertEquals((long)0L, (long)this.dataset.getNumFailedVolumes());
        for (int i = 0; i < providedVolumes.size(); ++i) {
            Assert.assertEquals((Object)"DS-PROVIDED", (Object)providedVolumes.get(i).getStorageID());
            Assert.assertEquals((Object)StorageType.PROVIDED, (Object)providedVolumes.get(i).getStorageType());
            long space = providedVolumes.get(i).getBlockPoolUsed(BLOCK_POOL_IDS[0]);
            Assert.assertEquals((long)spaceUsed, (long)space);
            Assert.assertEquals((long)10L, (long)providedVolumes.get(i).getNumBlocks());
            providedVolumes.get(i).shutdownBlockPool(BLOCK_POOL_IDS[1], null);
            try {
                Assert.assertEquals((long)0L, (long)providedVolumes.get(i).getBlockPoolUsed(BLOCK_POOL_IDS[1]));
                Assert.assertTrue((boolean)false);
                continue;
            }
            catch (IOException e) {
                LOG.info("Expected exception: " + e);
            }
        }
    }

    @Test
    public void testBlockLoad() throws IOException {
        for (int i = 0; i < providedVolumes.size(); ++i) {
            FsVolumeImpl vol = providedVolumes.get(i);
            ReplicaMap volumeMap = new ReplicaMap();
            vol.getVolumeMap(volumeMap, null);
            Assert.assertEquals((long)vol.getBlockPoolList().length, (long)BLOCK_POOL_IDS.length);
            for (int j = 0; j < BLOCK_POOL_IDS.length; ++j) {
                if (j == 0) continue;
                Assert.assertEquals(null, (Object)volumeMap.replicas(BLOCK_POOL_IDS[j]));
            }
            Assert.assertEquals((long)10L, (long)volumeMap.replicas(BLOCK_POOL_IDS[0]).size());
        }
    }

    @Test
    public void testProvidedBlockRead() throws IOException {
        for (int id = 0; id < 10; ++id) {
            ExtendedBlock eb = new ExtendedBlock(BLOCK_POOL_IDS[0], (long)id, 131072L, 0L);
            InputStream ins = this.dataset.getBlockInputStream(eb, 0L);
            String filepath = blkToPathMap.get(id);
            TestProvidedReplicaImpl.verifyReplicaContents(new File(filepath), ins, 0L, 131072L);
        }
    }

    @Test
    public void testProvidedBlockIterator() throws IOException {
        for (int i = 0; i < providedVolumes.size(); ++i) {
            long blkId;
            ExtendedBlock eb;
            FsVolumeImpl vol = providedVolumes.get(i);
            FsVolumeSpi.BlockIterator iter = vol.newBlockIterator(BLOCK_POOL_IDS[0], "temp");
            HashSet<Long> blockIdsUsed = new HashSet<Long>();
            Assert.assertEquals((Object)BLOCK_POOL_IDS[0], (Object)iter.getBlockPoolId());
            while (!iter.atEnd()) {
                eb = iter.nextBlock();
                blkId = eb.getBlockId();
                Assert.assertTrue((blkId >= 0L && blkId < 10L ? 1 : 0) != 0);
                Assert.assertTrue((!blockIdsUsed.contains(blkId) ? 1 : 0) != 0);
                blockIdsUsed.add(blkId);
            }
            Assert.assertEquals((long)10L, (long)blockIdsUsed.size());
            iter.rewind();
            while (!iter.atEnd()) {
                eb = iter.nextBlock();
                blkId = eb.getBlockId();
                Assert.assertTrue((boolean)blockIdsUsed.contains(blkId));
                blockIdsUsed.remove(blkId);
            }
            Assert.assertEquals((long)0L, (long)blockIdsUsed.size());
            FsVolumeSpi.BlockIterator nonProvidedBpIter = vol.newBlockIterator(BLOCK_POOL_IDS[1], "temp");
            Assert.assertEquals(null, (Object)nonProvidedBpIter.nextBlock());
        }
    }

    private int getBlocksInProvidedVolumes(String basePath, int numBlocks, int minBlockId) throws IOException {
        TestFileRegionIterator fileRegionIterator = new TestFileRegionIterator(basePath, minBlockId, numBlocks);
        int totalBlocks = 0;
        for (int i = 0; i < providedVolumes.size(); ++i) {
            ProvidedVolumeImpl vol = (ProvidedVolumeImpl)providedVolumes.get(i);
            vol.setFileRegionProvider(BLOCK_POOL_IDS[0], (BlockAliasMap)new TestFileRegionBlockAliasMap(fileRegionIterator, minBlockId, numBlocks));
            ReplicaMap volumeMap = new ReplicaMap();
            vol.getVolumeMap(BLOCK_POOL_IDS[0], volumeMap, null);
            totalBlocks += volumeMap.size(BLOCK_POOL_IDS[0]);
        }
        return totalBlocks;
    }

    @Test
    public void testProvidedVolumeContents() throws IOException {
        int expectedBlocks = 5;
        int minId = 0;
        int blocksFound = this.getBlocksInProvidedVolumes(providedBasePath + "/test1/", expectedBlocks, minId);
        Assert.assertEquals((String)("Number of blocks in provided volumes should be " + expectedBlocks), (long)expectedBlocks, (long)blocksFound);
        blocksFound = this.getBlocksInProvidedVolumes("file:/" + providedBasePath + "/test1/", expectedBlocks, minId);
        Assert.assertEquals((String)("Number of blocks in provided volumes should be " + expectedBlocks), (long)expectedBlocks, (long)blocksFound);
        blocksFound = this.getBlocksInProvidedVolumes("randomtest1/", expectedBlocks, minId);
        Assert.assertEquals((String)"Number of blocks in provided volumes should be 0", (long)0L, (long)blocksFound);
    }

    @Test
    public void testProvidedVolumeContainsBlock() throws URISyntaxException {
        Assert.assertEquals((Object)true, (Object)ProvidedVolumeImpl.containsBlock(null, null));
        Assert.assertEquals((Object)false, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("file:/a"), null));
        Assert.assertEquals((Object)true, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("file:/a/b/c/"), (URI)new URI("file:/a/b/c/d/e.file")));
        Assert.assertEquals((Object)true, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("/a/b/c/"), (URI)new URI("file:/a/b/c/d/e.file")));
        Assert.assertEquals((Object)true, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("/a/b/c"), (URI)new URI("file:/a/b/c/d/e.file")));
        Assert.assertEquals((Object)true, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("/a/b/c/"), (URI)new URI("/a/b/c/d/e.file")));
        Assert.assertEquals((Object)true, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("file:/a/b/c/"), (URI)new URI("/a/b/c/d/e.file")));
        Assert.assertEquals((Object)false, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("/a/b/e"), (URI)new URI("file:/a/b/c/d/e.file")));
        Assert.assertEquals((Object)false, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("file:/a/b/e"), (URI)new URI("file:/a/b/c/d/e.file")));
        Assert.assertEquals((Object)true, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("s3a:/bucket1/dir1/"), (URI)new URI("s3a:/bucket1/dir1/temp.txt")));
        Assert.assertEquals((Object)false, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("s3a:/bucket2/dir1/"), (URI)new URI("s3a:/bucket1/dir1/temp.txt")));
        Assert.assertEquals((Object)false, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("s3a:/bucket1/dir1/"), (URI)new URI("s3a:/bucket1/temp.txt")));
        Assert.assertEquals((Object)false, (Object)ProvidedVolumeImpl.containsBlock((URI)new URI("/bucket1/dir1/"), (URI)new URI("s3a:/bucket1/dir1/temp.txt")));
    }

    @Test
    public void testProvidedReplicaSuffixExtraction() {
        Assert.assertEquals((Object)"B.txt", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("file:///A/"), (Path)new Path("file:///A/B.txt")));
        Assert.assertEquals((Object)"B/C.txt", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("file:///A/"), (Path)new Path("file:///A/B/C.txt")));
        Assert.assertEquals((Object)"B/C/D.txt", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("file:///A/"), (Path)new Path("file:///A/B/C/D.txt")));
        Assert.assertEquals((Object)"D.txt", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("file:///A/B/C/"), (Path)new Path("file:///A/B/C/D.txt")));
        Assert.assertEquals((Object)"file:/A/B/C/D.txt", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("file:///X/B/C/"), (Path)new Path("file:///A/B/C/D.txt")));
        Assert.assertEquals((Object)"D.txt", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("/A/B/C"), (Path)new Path("/A/B/C/D.txt")));
        Assert.assertEquals((Object)"D.txt", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("/A/B/C/"), (Path)new Path("/A/B/C/D.txt")));
        Assert.assertEquals((Object)"data/current.csv", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("wasb:///users/alice/"), (Path)new Path("wasb:///users/alice/data/current.csv")));
        Assert.assertEquals((Object)"current.csv", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("wasb:///users/alice/data"), (Path)new Path("wasb:///users/alice/data/current.csv")));
        Assert.assertEquals((Object)"wasb:/users/alice/data/current.csv", (Object)ProvidedVolumeImpl.getSuffix((Path)new Path("wasb:///users/bob/"), (Path)new Path("wasb:///users/alice/data/current.csv")));
    }

    @Test
    public void testProvidedReplicaPrefix() throws Exception {
        for (int i = 0; i < providedVolumes.size(); ++i) {
            FsVolumeImpl vol = providedVolumes.get(i);
            ReplicaMap volumeMap = new ReplicaMap();
            vol.getVolumeMap(volumeMap, null);
            Path expectedPrefix = new Path(StorageLocation.normalizeFileURI((URI)new File(providedBasePath).toURI()));
            for (ReplicaInfo info : volumeMap.replicas(BLOCK_POOL_IDS[0])) {
                ProvidedReplica pInfo = (ProvidedReplica)info;
                Assert.assertEquals((Object)expectedPrefix, (Object)pInfo.getPathPrefix());
            }
        }
    }

    @Test
    public void testScannerWithProvidedVolumes() throws Exception {
        DirectoryScanner scanner = new DirectoryScanner((FsDatasetSpi)this.dataset, this.conf);
        Collection reports = scanner.getVolumeReports();
        for (DirectoryScanner.ScanInfoVolumeReport report : reports) {
            Assert.assertEquals((long)0L, (long)report.getScanInfo(BLOCK_POOL_IDS[0]).size());
        }
    }

    @Test
    public void testProvidedReplicaWithPathHandle() throws Exception {
        Configuration conf = new Configuration();
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        int chunkSize = 512;
        Random r = new Random(12345L);
        byte[] data = new byte[chunkSize];
        r.nextBytes(data);
        Path file = new Path("/testfile");
        try (FSDataOutputStream fout = fs.create(file);){
            fout.write(data);
        }
        PathHandle pathHandle = fs.getPathHandle(fs.getFileStatus(file), new Options.HandleOpt[]{Options.HandleOpt.changed((boolean)true), Options.HandleOpt.moved((boolean)true)});
        FinalizedProvidedReplica replica = new FinalizedProvidedReplica(0L, file.toUri(), 0L, (long)chunkSize, 0L, pathHandle, null, conf, (FileSystem)fs);
        byte[] content = new byte[chunkSize];
        IOUtils.readFully((InputStream)replica.getDataInputStream(0L), (byte[])content, (int)0, (int)chunkSize);
        Assert.assertArrayEquals((byte[])data, (byte[])content);
        fs.rename(file, new Path("/testfile.1"));
        IOUtils.readFully((InputStream)replica.getDataInputStream(0L), (byte[])content, (int)0, (int)chunkSize);
        Assert.assertArrayEquals((byte[])data, (byte[])content);
        replica.setPathHandle(null);
        try {
            replica.getDataInputStream(0L);
            Assert.fail((String)"Expected an exception");
        }
        catch (IOException e) {
            LOG.info("Expected exception " + e);
        }
    }

    static {
        spaceUsed = 0L;
    }

    public static class TestFileRegionBlockAliasMap
    extends BlockAliasMap<FileRegion> {
        private int minId;
        private int numBlocks;
        private Iterator<FileRegion> suppliedIterator;

        TestFileRegionBlockAliasMap() {
            this(null, 0, 10);
        }

        TestFileRegionBlockAliasMap(Iterator<FileRegion> iterator, int minId, int numBlocks) {
            this.suppliedIterator = iterator;
            this.minId = minId;
            this.numBlocks = numBlocks;
        }

        public BlockAliasMap.Reader<FileRegion> getReader(BlockAliasMap.Reader.Options opts, String blockPoolId) throws IOException {
            if (!blockPoolId.equals(BLOCK_POOL_IDS[0])) {
                return null;
            }
            BlockAliasMap.Reader<FileRegion> reader = new BlockAliasMap.Reader<FileRegion>(){

                public Iterator<FileRegion> iterator() {
                    if (suppliedIterator == null) {
                        return new TestFileRegionIterator(providedBasePath, minId, numBlocks);
                    }
                    return suppliedIterator;
                }

                public void close() throws IOException {
                }

                public Optional<FileRegion> resolve(Block ident) throws IOException {
                    return null;
                }
            };
            return reader;
        }

        public BlockAliasMap.Writer<FileRegion> getWriter(BlockAliasMap.Writer.Options opts, String blockPoolId) throws IOException {
            return null;
        }

        public void refresh() throws IOException {
        }

        public void close() throws IOException {
        }
    }

    public static class TestFileRegionIterator
    implements Iterator<FileRegion> {
        private int numBlocks;
        private int currentCount;
        private String basePath;

        public TestFileRegionIterator(String basePath, int minID, int numBlocks) {
            this.currentCount = minID;
            this.numBlocks = numBlocks;
            this.basePath = basePath;
        }

        @Override
        public boolean hasNext() {
            return this.currentCount < this.numBlocks;
        }

        @Override
        public FileRegion next() {
            FileRegion region = null;
            if (this.hasNext()) {
                File newFile = new File(this.basePath, "file" + this.currentCount);
                if (!newFile.exists()) {
                    try {
                        LOG.info("Creating file for blkid " + this.currentCount);
                        blkToPathMap.put(Long.valueOf(this.currentCount), newFile.getAbsolutePath());
                        LOG.info("Block id " + this.currentCount + " corresponds to file " + newFile.getAbsolutePath());
                        newFile.createNewFile();
                        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(newFile.getAbsolutePath()), "utf-8");
                        int i = 0;
                        while ((long)i < 32768L) {
                            ((Writer)writer).write(this.currentCount);
                            ++i;
                        }
                        ((Writer)writer).flush();
                        ((Writer)writer).close();
                        spaceUsed += 131072L;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                region = new FileRegion((long)this.currentCount, new Path(newFile.toString()), 0L, 131072L);
                ++this.currentCount;
            }
            return region;
        }

        @Override
        public void remove() {
        }

        public void resetMinBlockId(int minId) {
            this.currentCount = minId;
        }

        public void resetBlockCount(int numBlocks) {
            this.numBlocks = numBlocks;
        }
    }
}

