/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset.impl;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.common.HdfsServerConstants;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeFaultInjector;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.hdfs.server.datanode.ReplicaInfo;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsDatasetImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.FsVolumeImpl;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.impl.ReplicaMap;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.Time;
import org.junit.Assert;
import org.junit.Test;

public class TestDatanodeRestart {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFinalizedReplicas() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.client-write-packet-size", 512);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(3).build();
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        try {
            String TopDir = "/test";
            DFSTestUtil util = new DFSTestUtil.Builder().setName("TestDatanodeRestart").setNumFiles(2).build();
            util.createFiles((FileSystem)fs, "/test", (short)3);
            util.waitReplication((FileSystem)fs, "/test", (short)3);
            util.checkFiles((FileSystem)fs, "/test");
            cluster.restartDataNodes();
            cluster.waitActive();
            util.checkFiles((FileSystem)fs, "/test");
        }
        finally {
            cluster.shutdown();
        }
    }

    public void testRbwReplicas() throws IOException {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.blocksize", 1024L);
        conf.setInt("dfs.client-write-packet-size", 512);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(2).build();
        cluster.waitActive();
        try {
            this.testRbwReplicas(cluster, false);
            this.testRbwReplicas(cluster, true);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRbwReplicas(MiniDFSCluster cluster, boolean isCorrupt) throws IOException {
        FSDataOutputStream out = null;
        DistributedFileSystem fs = cluster.getFileSystem();
        Path src = new Path("/test.txt");
        try {
            int fileLen = 515;
            byte[] writeBuf = new byte[515];
            new Random().nextBytes(writeBuf);
            out = fs.create(src);
            out.write(writeBuf);
            out.hflush();
            DataNode dn = cluster.getDataNodes().get(0);
            try (FsDatasetSpi.FsVolumeReferences volumes = TestDatanodeRestart.dataset(dn).getFsVolumeReferences();){
                for (FsVolumeSpi vol : volumes) {
                    FsVolumeImpl volume = (FsVolumeImpl)vol;
                    File currentDir = volume.getCurrentDir().getParentFile().getParentFile();
                    File rbwDir = new File(currentDir, "rbw");
                    for (File file : rbwDir.listFiles()) {
                        if (!isCorrupt || !Block.isBlockFilename((File)file)) continue;
                        new RandomAccessFile(file, "rw").setLength(514L);
                    }
                }
            }
            cluster.restartDataNodes();
            cluster.waitActive();
            dn = cluster.getDataNodes().get(0);
            String bpid = cluster.getNamesystem().getBlockPoolId();
            ReplicaMap replicas = TestDatanodeRestart.dataset((DataNode)dn).volumeMap;
            Assert.assertEquals((long)1L, (long)replicas.size(bpid));
            ReplicaInfo replica = (ReplicaInfo)replicas.replicas(bpid).iterator().next();
            Assert.assertEquals((Object)HdfsServerConstants.ReplicaState.RWR, (Object)replica.getState());
            if (isCorrupt) {
                Assert.assertEquals((long)512L, (long)replica.getNumBytes());
            } else {
                Assert.assertEquals((long)515L, (long)replica.getNumBytes());
            }
            TestDatanodeRestart.dataset(dn).invalidate(bpid, new Block[]{replica});
        }
        catch (Throwable throwable) {
            IOUtils.closeStream(out);
            if (fs.exists(src)) {
                fs.delete(src, false);
            }
            fs.close();
            throw throwable;
        }
        IOUtils.closeStream((Closeable)out);
        if (fs.exists(src)) {
            fs.delete(src, false);
        }
        fs.close();
    }

    private static FsDatasetImpl dataset(DataNode dn) {
        return (FsDatasetImpl)DataNodeTestUtils.getFSDataset(dn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWaitForRegistrationOnRestart() throws Exception {
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.datanode.bp-ready.timeout", 5L);
        conf.setInt("dfs.client.socket-timeout", 5000);
        DataNodeFaultInjector dnFaultInjector = new DataNodeFaultInjector(){

            public void noRegistration() throws IOException {
                throw new IOException("no reg found for testing");
            }
        };
        DataNodeFaultInjector oldDnInjector = DataNodeFaultInjector.get();
        DataNodeFaultInjector.set((DataNodeFaultInjector)dnFaultInjector);
        MiniDFSCluster cluster = null;
        long start = 0L;
        Path file = new Path("/reg");
        try {
            int numDNs = 1;
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(numDNs).build();
            cluster.waitActive();
            start = Time.monotonicNow();
            DistributedFileSystem fileSys = cluster.getFileSystem();
            try {
                DFSTestUtil.createFile((FileSystem)fileSys, file, 10240L, (short)1, 0L);
                throw new IOException("Did not fail!");
            }
            catch (RemoteException e) {
                long elapsed = Time.monotonicNow() - start;
                if (elapsed < 5000L || elapsed > 10000L) {
                    throw new IOException(elapsed + " milliseconds passed.", e);
                }
                DataNodeFaultInjector.set((DataNodeFaultInjector)oldDnInjector);
                DFSTestUtil.createFile((FileSystem)fileSys, file, 10240L, (short)1, 0L);
                fileSys.append(file);
                DataNodeFaultInjector.set((DataNodeFaultInjector)dnFaultInjector);
                byte[] buffer = new byte[8];
                start = Time.monotonicNow();
                try {
                    fileSys.open(file).read(0L, buffer, 0, 1);
                    throw new IOException("Did not fail!");
                }
                catch (IOException e2) {
                    long elapsed2 = Time.monotonicNow() - start;
                    if (e2.getMessage().contains("readBlockLength")) {
                        throw new IOException("Failed, but with unexpected exception:", e2);
                    }
                    if (elapsed2 < 5000L || elapsed2 > 10000L) {
                        throw new IOException(elapsed2 + " milliseconds passed.", e2);
                    }
                    DataNodeFaultInjector.set((DataNodeFaultInjector)oldDnInjector);
                    fileSys.open(file).read(0L, buffer, 0, 1);
                    DataNodeFaultInjector.set((DataNodeFaultInjector)oldDnInjector);
                    if (cluster != null) {
                        cluster.shutdown();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            DataNodeFaultInjector.set((DataNodeFaultInjector)oldDnInjector);
            if (cluster != null) {
                cluster.shutdown();
            }
            throw throwable;
        }
    }
}

