/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import org.apache.hadoop.hdfs.DFSClientFaultInjector;
import org.apache.hadoop.hdfs.protocol.datatransfer.PacketHeader;
import org.apache.hadoop.hdfs.util.ByteArrayManager;
import org.apache.htrace.core.Span;
import org.apache.htrace.core.SpanId;
import org.apache.htrace.core.TraceScope;

class DFSPacket {
    public static final long HEART_BEAT_SEQNO = -1L;
    private static SpanId[] EMPTY = new SpanId[0];
    private final long seqno;
    private final long offsetInBlock;
    private boolean syncBlock;
    private int numChunks;
    private final int maxChunks;
    private byte[] buf;
    private final boolean lastPacketInBlock;
    private int checksumStart;
    private int checksumPos;
    private final int dataStart;
    private int dataPos;
    private SpanId[] traceParents = EMPTY;
    private int traceParentsUsed;
    private TraceScope scope;

    DFSPacket(byte[] buf, int chunksPerPkt, long offsetInBlock, long seqno, int checksumSize, boolean lastPacketInBlock) {
        this.lastPacketInBlock = lastPacketInBlock;
        this.numChunks = 0;
        this.offsetInBlock = offsetInBlock;
        this.seqno = seqno;
        this.buf = buf;
        this.checksumPos = this.checksumStart = PacketHeader.PKT_MAX_HEADER_LEN;
        this.dataPos = this.dataStart = this.checksumStart + chunksPerPkt * checksumSize;
        this.maxChunks = chunksPerPkt;
    }

    synchronized void writeData(byte[] inarray, int off, int len) throws ClosedChannelException {
        this.checkBuffer();
        if (this.dataPos + len > this.buf.length) {
            throw new BufferOverflowException();
        }
        System.arraycopy(inarray, off, this.buf, this.dataPos, len);
        this.dataPos += len;
    }

    synchronized void writeChecksum(byte[] inarray, int off, int len) throws ClosedChannelException {
        this.checkBuffer();
        if (len == 0) {
            return;
        }
        if (this.checksumPos + len > this.dataStart) {
            throw new BufferOverflowException();
        }
        System.arraycopy(inarray, off, this.buf, this.checksumPos, len);
        this.checksumPos += len;
    }

    synchronized void writeTo(DataOutputStream stm) throws IOException {
        this.checkBuffer();
        int dataLen = this.dataPos - this.dataStart;
        int checksumLen = this.checksumPos - this.checksumStart;
        int pktLen = 4 + dataLen + checksumLen;
        PacketHeader header = new PacketHeader(pktLen, this.offsetInBlock, this.seqno, this.lastPacketInBlock, dataLen, this.syncBlock);
        if (this.checksumPos != this.dataStart) {
            System.arraycopy(this.buf, this.checksumStart, this.buf, this.dataStart - checksumLen, checksumLen);
            this.checksumPos = this.dataStart;
            this.checksumStart = this.checksumPos - checksumLen;
        }
        int headerStart = this.checksumStart - header.getSerializedSize();
        assert (this.checksumStart + 1 >= header.getSerializedSize());
        assert (headerStart >= 0);
        assert (headerStart + header.getSerializedSize() == this.checksumStart);
        System.arraycopy(header.getBytes(), 0, this.buf, headerStart, header.getSerializedSize());
        if (DFSClientFaultInjector.get().corruptPacket()) {
            int n = headerStart + header.getSerializedSize() + checksumLen + dataLen - 1;
            this.buf[n] = (byte)(this.buf[n] ^ 0xFF);
        }
        stm.write(this.buf, headerStart, header.getSerializedSize() + checksumLen + dataLen);
        if (DFSClientFaultInjector.get().uncorruptPacket()) {
            int n = headerStart + header.getSerializedSize() + checksumLen + dataLen - 1;
            this.buf[n] = (byte)(this.buf[n] ^ 0xFF);
        }
    }

    private synchronized void checkBuffer() throws ClosedChannelException {
        if (this.buf == null) {
            throw new ClosedChannelException();
        }
    }

    synchronized void releaseBuffer(ByteArrayManager bam) {
        bam.release(this.buf);
        this.buf = null;
    }

    synchronized long getLastByteOffsetBlock() {
        return this.offsetInBlock + (long)this.dataPos - (long)this.dataStart;
    }

    boolean isHeartbeatPacket() {
        return this.seqno == -1L;
    }

    boolean isLastPacketInBlock() {
        return this.lastPacketInBlock;
    }

    long getSeqno() {
        return this.seqno;
    }

    synchronized int getNumChunks() {
        return this.numChunks;
    }

    synchronized void incNumChunks() {
        ++this.numChunks;
    }

    int getMaxChunks() {
        return this.maxChunks;
    }

    synchronized void setSyncBlock(boolean syncBlock) {
        this.syncBlock = syncBlock;
    }

    public String toString() {
        return "packet seqno: " + this.seqno + " offsetInBlock: " + this.offsetInBlock + " lastPacketInBlock: " + this.lastPacketInBlock + " lastByteOffsetInBlock: " + this.getLastByteOffsetBlock();
    }

    public void addTraceParent(Span span) {
        if (span == null) {
            return;
        }
        this.addTraceParent(span.getSpanId());
    }

    public void addTraceParent(SpanId id) {
        if (!id.isValid()) {
            return;
        }
        if (this.traceParentsUsed == this.traceParents.length) {
            int newLength = this.traceParents.length == 0 ? 8 : this.traceParents.length * 2;
            this.traceParents = Arrays.copyOf(this.traceParents, newLength);
        }
        this.traceParents[this.traceParentsUsed] = id;
        ++this.traceParentsUsed;
    }

    public SpanId[] getTraceParents() {
        int len = this.traceParentsUsed;
        Arrays.sort(this.traceParents, 0, len);
        int j = 0;
        SpanId prevVal = SpanId.INVALID;
        for (int i = 0; i != len; ++i) {
            SpanId val = this.traceParents[i];
            if (val.equals((Object)prevVal)) continue;
            this.traceParents[j] = val;
            ++j;
            prevVal = val;
        }
        if (j < this.traceParents.length) {
            this.traceParents = Arrays.copyOf(this.traceParents, j);
            this.traceParentsUsed = this.traceParents.length;
        }
        return this.traceParents;
    }

    public void setTraceScope(TraceScope scope) {
        this.scope = scope;
    }

    public TraceScope getTraceScope() {
        return this.scope;
    }
}

