/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.metrics.StateStoreMetrics;
import org.apache.hadoop.hdfs.server.federation.router.security.token.SQLConnectionFactory;
import org.apache.hadoop.hdfs.server.federation.store.StateStoreUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreOperationResult;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreSerializableImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.federation.store.records.DisabledNameservice;
import org.apache.hadoop.hdfs.server.federation.store.records.MembershipState;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.server.federation.store.records.Query;
import org.apache.hadoop.hdfs.server.federation.store.records.QueryResult;
import org.apache.hadoop.hdfs.server.federation.store.records.RouterState;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStoreMySQLImpl
extends StateStoreSerializableImpl {
    public static final String SQL_STATE_STORE_CONF_PREFIX = "state-store-mysql.";
    public static final String CONNECTION_URL = "state-store-mysql.connection.url";
    public static final String CONNECTION_USERNAME = "state-store-mysql.connection.username";
    public static final String CONNECTION_PASSWORD = "state-store-mysql.connection.password";
    public static final String CONNECTION_DRIVER = "state-store-mysql.connection.driver";
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreMySQLImpl.class);
    private SQLConnectionFactory connectionFactory;
    private boolean initialized = false;
    private static final Set<String> VALID_TABLES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(MembershipState.class.getSimpleName(), RouterState.class.getSimpleName(), MountTable.class.getSimpleName(), DisabledNameservice.class.getSimpleName())));

    @Override
    public boolean initDriver() {
        Configuration conf = this.getConf();
        this.connectionFactory = new MySQLStateStoreHikariDataSourceConnectionFactory(conf);
        this.initialized = true;
        LOG.info("MySQL state store connection factory initialized");
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends BaseRecord> boolean initRecordStorage(String className, Class<T> clazz) {
        Connection connection;
        String tableName = this.getAndValidateTableNameForClass(clazz);
        try {
            connection = this.connectionFactory.getConnection();
            try (ResultSet resultSet = connection.getMetaData().getTables(null, null, tableName, null);){
                if (resultSet.next()) {
                    boolean bl = true;
                    return bl;
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            LOG.error("Could not check if table {} able exists", (Object)tableName);
        }
        try {
            connection = this.connectionFactory.getConnection();
            try {
                boolean bl;
                block31: {
                    Statement statement = connection.createStatement();
                    try {
                        String sql = String.format("CREATE TABLE %s (recordKey VARCHAR (255) NOT NULL,recordValue VARCHAR (2047) NOT NULL, PRIMARY KEY(recordKey))", tableName);
                        statement.execute(sql);
                        bl = true;
                        if (statement == null) break block31;
                    }
                    catch (Throwable throwable) {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    statement.close();
                }
                return bl;
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            LOG.error(String.format("Cannot create table %s for record type %s.", tableName, className), (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public boolean isDriverReady() {
        return this.initialized;
    }

    @Override
    public void close() throws Exception {
        this.connectionFactory.shutdown();
    }

    @Override
    public <T extends BaseRecord> QueryResult<T> get(Class<T> clazz) throws IOException {
        String tableName = this.getAndValidateTableNameForClass(clazz);
        this.verifyDriverReady();
        long start = Time.monotonicNow();
        StateStoreMetrics metrics = this.getMetrics();
        ArrayList<T> ret = new ArrayList<T>();
        try (Connection connection = this.connectionFactory.getConnection();
             PreparedStatement statement = connection.prepareStatement(String.format("SELECT * FROM %s", tableName));
             ResultSet result = statement.executeQuery();){
            while (result.next()) {
                String recordValue = result.getString("recordValue");
                T record = this.newRecord(recordValue, clazz, false);
                ret.add(record);
            }
        }
        catch (SQLException e) {
            if (metrics != null) {
                metrics.addFailure(Time.monotonicNow() - start);
            }
            String msg = "Cannot fetch records for " + clazz.getSimpleName();
            LOG.error(msg, (Throwable)e);
            throw new IOException(msg, e);
        }
        if (metrics != null) {
            metrics.addRead(Time.monotonicNow() - start);
        }
        return new QueryResult(ret, this.getTime());
    }

    @Override
    public <T extends BaseRecord> StateStoreOperationResult putAll(List<T> records, boolean allowUpdate, boolean errorIfExists) throws IOException {
        if (records.isEmpty()) {
            return StateStoreOperationResult.getDefaultSuccessResult();
        }
        this.verifyDriverReady();
        StateStoreMetrics metrics = this.getMetrics();
        long start = Time.monotonicNow();
        boolean success = true;
        ArrayList<String> failedRecordsKeys = new ArrayList<String>();
        for (BaseRecord record : records) {
            String tableName = this.getAndValidateTableNameForClass(record.getClass());
            String primaryKey = StateStoreMySQLImpl.getPrimaryKey(record);
            String data = this.serializeString(record);
            if (this.recordExists(tableName, primaryKey)) {
                if (allowUpdate) {
                    record.setDateModified(this.getTime());
                    if (this.updateRecord(tableName, primaryKey, data)) continue;
                    LOG.error("Cannot write {} into table {}", (Object)primaryKey, (Object)tableName);
                    failedRecordsKeys.add(StateStoreMySQLImpl.getOriginalPrimaryKey(primaryKey));
                    success = false;
                    continue;
                }
                if (errorIfExists) {
                    LOG.error("Attempted to insert record {} that already exists in table {} and updates are disallowed.", (Object)primaryKey, (Object)tableName);
                    failedRecordsKeys.add(StateStoreMySQLImpl.getOriginalPrimaryKey(primaryKey));
                    success = false;
                    continue;
                }
                LOG.debug("Not updating {} as updates are not allowed", (Object)record);
                continue;
            }
            if (this.insertRecord(tableName, primaryKey, data)) continue;
            LOG.error("Cannot write {} in table {}", (Object)primaryKey, (Object)tableName);
            failedRecordsKeys.add(StateStoreMySQLImpl.getOriginalPrimaryKey(primaryKey));
            success = false;
        }
        long end = Time.monotonicNow();
        if (metrics != null) {
            if (success) {
                metrics.addWrite(end - start);
            } else {
                metrics.addFailure(end - start);
            }
        }
        return new StateStoreOperationResult(failedRecordsKeys, success);
    }

    @Override
    public <T extends BaseRecord> boolean removeAll(Class<T> clazz) throws IOException {
        this.verifyDriverReady();
        long startTimeMs = Time.monotonicNow();
        StateStoreMetrics metrics = this.getMetrics();
        boolean success = true;
        String tableName = this.getAndValidateTableNameForClass(clazz);
        try (Connection connection = this.connectionFactory.getConnection(true);
             PreparedStatement truncateTable = connection.prepareStatement(String.format("TRUNCATE TABLE %s", tableName));){
            truncateTable.execute();
        }
        catch (SQLException e) {
            LOG.error("Could not remove all records in table {}", (Object)tableName, (Object)e);
            success = false;
        }
        if (metrics != null) {
            long durationMs = Time.monotonicNow() - startTimeMs;
            if (success) {
                metrics.addRemove(durationMs);
            } else {
                metrics.addFailure(durationMs);
            }
        }
        return success;
    }

    @Override
    public <T extends BaseRecord> int remove(Class<T> clazz, Query<T> query) throws IOException {
        int removed;
        StateStoreMetrics metrics;
        long startTimeMs;
        block8: {
            this.verifyDriverReady();
            if (query == null) {
                return 0;
            }
            startTimeMs = Time.monotonicNow();
            metrics = this.getMetrics();
            removed = 0;
            try {
                QueryResult<T> result = this.get(clazz);
                List<T> existingRecords = result.getRecords();
                List<BaseRecord> recordsToRemove = StateStoreUtils.filterMultiple(query, existingRecords);
                boolean success = true;
                for (BaseRecord recordToRemove : recordsToRemove) {
                    String primaryKey;
                    String tableName = this.getAndValidateTableNameForClass(clazz);
                    if (this.removeRecord(tableName, primaryKey = StateStoreMySQLImpl.getPrimaryKey(recordToRemove))) {
                        ++removed;
                        continue;
                    }
                    LOG.error("Cannot remove record {} from table {}", (Object)primaryKey, (Object)tableName);
                    success = false;
                }
                if (!success) {
                    LOG.error("Cannot remove records {} query {}", clazz, query);
                    if (metrics != null) {
                        metrics.addFailure(Time.monotonicNow() - startTimeMs);
                    }
                }
            }
            catch (IOException e) {
                LOG.error("Cannot remove records {} query {}", new Object[]{clazz, query, e});
                if (metrics == null) break block8;
                metrics.addFailure(Time.monotonicNow() - startTimeMs);
            }
        }
        if (removed > 0 && metrics != null) {
            metrics.addRemove(Time.monotonicNow() - startTimeMs);
        }
        return removed;
    }

    protected boolean insertRecord(String tableName, String key, String data) {
        try (Connection connection = this.connectionFactory.getConnection(true);
             PreparedStatement statement = connection.prepareStatement(String.format("INSERT INTO %s (recordKey, recordValue) VALUES (?, ?)", tableName));){
            statement.setString(1, key);
            statement.setString(2, data);
            statement.execute();
        }
        catch (SQLException e) {
            LOG.error("Failed to insert record {} into table {}", new Object[]{key, tableName, e});
            return false;
        }
        return true;
    }

    protected boolean updateRecord(String tableName, String key, String data) {
        try (Connection connection = this.connectionFactory.getConnection(true);
             PreparedStatement statement = connection.prepareStatement(String.format("UPDATE %s SET recordValue = ? WHERE recordKey = ?", tableName));){
            statement.setString(1, data);
            statement.setString(2, key);
            statement.execute();
        }
        catch (SQLException e) {
            LOG.error("Failed to update record {} in table {}", new Object[]{key, tableName, e});
            return false;
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    protected boolean recordExists(String tableName, String key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected boolean removeRecord(String tableName, String key) {
        try (Connection connection = this.connectionFactory.getConnection(true);){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement(String.format("DELETE FROM %s WHERE recordKey = ?", tableName));
                try {
                    statement.setString(1, key);
                    statement.execute();
                    bl = true;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOG.error("Failed to remove record {} in table {}", new Object[]{key, tableName, e});
            return false;
        }
    }

    private <T extends BaseRecord> String getAndValidateTableNameForClass(Class<T> clazz) {
        String tableName = StateStoreUtils.getRecordName(clazz);
        if (VALID_TABLES.contains(tableName)) {
            return tableName;
        }
        throw new IllegalArgumentException(tableName + " is not a valid table name");
    }

    static class MySQLStateStoreHikariDataSourceConnectionFactory
    implements SQLConnectionFactory {
        protected static final String HIKARI_PROPS = "state-store-mysql.connection.hikari.";
        private final HikariDataSource dataSource;

        MySQLStateStoreHikariDataSourceConnectionFactory(Configuration conf) {
            Properties properties = new Properties();
            properties.setProperty("jdbcUrl", conf.get(StateStoreMySQLImpl.CONNECTION_URL));
            properties.setProperty("username", conf.get(StateStoreMySQLImpl.CONNECTION_USERNAME));
            properties.setProperty("password", conf.get(StateStoreMySQLImpl.CONNECTION_PASSWORD));
            properties.setProperty("driverClassName", conf.get(StateStoreMySQLImpl.CONNECTION_DRIVER));
            properties.putAll((Map<?, ?>)conf.getPropsWithPrefix(HIKARI_PROPS));
            HikariConfig hikariConfig = new HikariConfig(properties);
            this.dataSource = new HikariDataSource(hikariConfig);
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.dataSource.getConnection();
        }

        @Override
        public void shutdown() {
            this.dataSource.close();
        }
    }
}

