/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.records;

import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.server.federation.resolver.RemoteLocation;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.router.RouterQuotaUsage;
import org.apache.hadoop.hdfs.server.federation.store.driver.StateStoreSerializer;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.security.UserGroupInformation;

public abstract class MountTable
extends BaseRecord {
    public static final String ERROR_MSG_NO_SOURCE_PATH = "Invalid entry, no source path specified ";
    public static final String ERROR_MSG_MUST_START_WITH_BACK_SLASH = "Invalid entry, all mount points must start with / ";
    public static final String ERROR_MSG_NO_DEST_PATH_SPECIFIED = "Invalid entry, no destination paths specified ";
    public static final String ERROR_MSG_INVAILD_DEST_NS = "Invalid entry, invalid destination nameservice ";
    public static final String ERROR_MSG_INVAILD_DEST_PATH = "Invalid entry, invalid destination path ";
    public static final String ERROR_MSG_ALL_DEST_MUST_START_WITH_BACK_SLASH = "Invalid entry, all destination must start with / ";
    private static final String ERROR_MSG_FAULT_TOLERANT_MULTI_DEST = "Invalid entry, fault tolerance requires multiple destinations ";
    private static final String ERROR_MSG_FAULT_TOLERANT_ALL = "Invalid entry, fault tolerance only supported for ALL order ";
    public static final Comparator<String> PATH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String s1 = o1.replace('/', ' ');
            String s2 = o2.replace('/', ' ');
            return s1.compareTo(s2);
        }
    };
    public static final Comparator<MountTable> SOURCE_COMPARATOR = new Comparator<MountTable>(){

        @Override
        public int compare(MountTable m1, MountTable m2) {
            String src1 = m1.getSourcePath();
            String src2 = m2.getSourcePath();
            return PATH_COMPARATOR.compare(src1, src2);
        }
    };

    public static MountTable newInstance() {
        MountTable record = StateStoreSerializer.newRecord(MountTable.class);
        record.init();
        return record;
    }

    public static MountTable newInstance(String src, Map<String, String> destinations, long dateCreated, long dateModified) throws IOException {
        MountTable record = MountTable.newInstance(src, destinations);
        record.setDateCreated(dateCreated);
        record.setDateModified(dateModified);
        return record;
    }

    public static MountTable newInstance(String src, Map<String, String> destinations) throws IOException {
        MountTable record = MountTable.newInstance();
        record.setSourcePath(MountTable.normalizeFileSystemPath(src));
        LinkedList<RemoteLocation> locations = new LinkedList<RemoteLocation>();
        for (Map.Entry<String, String> entry : destinations.entrySet()) {
            String nsId = entry.getKey();
            String path = MountTable.normalizeFileSystemPath(entry.getValue());
            RemoteLocation location = new RemoteLocation(nsId, path, src);
            locations.add(location);
        }
        record.setDestinations(locations);
        UserGroupInformation ugi = NameNode.getRemoteUser();
        record.setOwnerName(ugi.getShortUserName());
        String group = ugi.getGroups().isEmpty() ? ugi.getShortUserName() : ugi.getPrimaryGroupName();
        record.setGroupName(group);
        record.setMode(new FsPermission(493));
        RouterQuotaUsage quota = new RouterQuotaUsage.Builder().fileAndDirectoryCount(0L).quota(-1L).spaceConsumed(0L).spaceQuota(-1L).build();
        record.setQuota(quota);
        record.validate();
        return record;
    }

    public abstract String getSourcePath();

    public abstract void setSourcePath(String var1);

    public abstract List<RemoteLocation> getDestinations();

    public abstract void setDestinations(List<RemoteLocation> var1);

    public abstract boolean addDestination(String var1, String var2);

    public abstract boolean isReadOnly();

    public abstract void setReadOnly(boolean var1);

    public abstract DestinationOrder getDestOrder();

    public abstract void setDestOrder(DestinationOrder var1);

    public abstract boolean isFaultTolerant();

    public abstract void setFaultTolerant(boolean var1);

    public abstract String getOwnerName();

    public abstract void setOwnerName(String var1);

    public abstract String getGroupName();

    public abstract void setGroupName(String var1);

    public abstract FsPermission getMode();

    public abstract void setMode(FsPermission var1);

    public abstract RouterQuotaUsage getQuota();

    public abstract void setQuota(RouterQuotaUsage var1);

    public RemoteLocation getDefaultLocation() {
        List<RemoteLocation> dests = this.getDestinations();
        if (dests == null || dests.isEmpty()) {
            return null;
        }
        return dests.get(0);
    }

    @Override
    public boolean like(BaseRecord o) {
        if (o instanceof MountTable) {
            MountTable other = (MountTable)o;
            if (this.getSourcePath() != null && !this.getSourcePath().equals(other.getSourcePath())) {
                return false;
            }
            return this.getDestinations() == null || this.getDestinations().equals(other.getDestinations());
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getSourcePath());
        sb.append("->");
        List<RemoteLocation> destinations = this.getDestinations();
        sb.append(destinations);
        if (destinations != null && destinations.size() > 1) {
            sb.append("[").append((Object)this.getDestOrder()).append("]");
        }
        if (this.isReadOnly()) {
            sb.append("[RO]");
        }
        if (this.isFaultTolerant()) {
            sb.append("[FT]");
        }
        if (this.getOwnerName() != null) {
            sb.append("[owner:").append(this.getOwnerName()).append("]");
        }
        if (this.getGroupName() != null) {
            sb.append("[group:").append(this.getGroupName()).append("]");
        }
        if (this.getMode() != null) {
            sb.append("[mode:").append(this.getMode()).append("]");
        }
        if (this.getQuota() != null) {
            sb.append("[quota:").append((Object)this.getQuota()).append("]");
        }
        return sb.toString();
    }

    public SortedMap<String, String> getPrimaryKeys() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("sourcePath", this.getSourcePath());
        return map;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getSourcePath() == null || this.getSourcePath().length() == 0) {
            throw new IllegalArgumentException(ERROR_MSG_NO_SOURCE_PATH + this);
        }
        if (!this.getSourcePath().startsWith("/")) {
            throw new IllegalArgumentException(ERROR_MSG_MUST_START_WITH_BACK_SLASH + this);
        }
        if (this.getDestinations() == null || this.getDestinations().size() == 0) {
            throw new IllegalArgumentException(ERROR_MSG_NO_DEST_PATH_SPECIFIED + this);
        }
        for (RemoteLocation loc : this.getDestinations()) {
            String nsId = loc.getNameserviceId();
            if (nsId == null || nsId.length() == 0) {
                throw new IllegalArgumentException(ERROR_MSG_INVAILD_DEST_NS + this);
            }
            if (loc.getDest() == null || loc.getDest().length() == 0) {
                throw new IllegalArgumentException(ERROR_MSG_INVAILD_DEST_PATH + this);
            }
            if (loc.getDest().startsWith("/")) continue;
            throw new IllegalArgumentException(ERROR_MSG_ALL_DEST_MUST_START_WITH_BACK_SLASH + this);
        }
        if (this.isFaultTolerant()) {
            if (this.getDestinations().size() < 2) {
                throw new IllegalArgumentException(ERROR_MSG_FAULT_TOLERANT_MULTI_DEST + this);
            }
            if (!this.isAll()) {
                throw new IllegalArgumentException(ERROR_MSG_FAULT_TOLERANT_ALL + this);
            }
        }
    }

    @Override
    public long getExpirationMs() {
        return 0L;
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.getSourcePath()).append(this.getDestinations()).append(this.isReadOnly()).append((Object)this.getDestOrder()).append(this.isFaultTolerant()).append(this.getQuota().getQuota()).append(this.getQuota().getSpaceQuota()).toHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MountTable) {
            MountTable other = (MountTable)obj;
            return new EqualsBuilder().append((Object)this.getSourcePath(), (Object)other.getSourcePath()).append(this.getDestinations(), other.getDestinations()).append(this.isReadOnly(), other.isReadOnly()).append((Object)this.getDestOrder(), (Object)other.getDestOrder()).append(this.isFaultTolerant(), other.isFaultTolerant()).append(this.getQuota().getQuota(), other.getQuota().getQuota()).append(this.getQuota().getSpaceQuota(), other.getQuota().getSpaceQuota()).isEquals();
        }
        return false;
    }

    public boolean isAll() {
        DestinationOrder order = this.getDestOrder();
        return DestinationOrder.FOLDER_ALL.contains((Object)order);
    }

    private static String normalizeFileSystemPath(String path) {
        Path normalizedPath = new Path(path);
        return normalizedPath.toString();
    }
}

