/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.net.InetSocketAddress;
import javax.servlet.ServletContext;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.server.federation.router.IsRouterActiveServlet;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterFsckServlet;
import org.apache.hadoop.hdfs.server.federation.router.RouterNetworkTopologyServlet;
import org.apache.hadoop.hdfs.server.federation.router.RouterWebHdfsMethods;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.service.AbstractService;

public class RouterHttpServer
extends AbstractService {
    protected static final String NAMENODE_ATTRIBUTE_KEY = "name.node";
    private Configuration conf;
    private final Router router;
    private HttpServer2 httpServer;
    private InetSocketAddress httpAddress;
    private InetSocketAddress httpsAddress;

    public RouterHttpServer(Router router) {
        super(RouterHttpServer.class.getName());
        this.router = router;
    }

    protected void serviceInit(Configuration configuration) throws Exception {
        this.conf = configuration;
        this.httpAddress = this.conf.getSocketAddr("dfs.federation.router.http-bind-host", "dfs.federation.router.http-address", "0.0.0.0:50071", 50071);
        this.httpsAddress = this.conf.getSocketAddr("dfs.federation.router.https-bind-host", "dfs.federation.router.https-address", "0.0.0.0:50072", 50072);
        super.serviceInit(this.conf);
    }

    protected void serviceStart() throws Exception {
        String webApp = "router";
        HttpServer2.Builder builder = DFSUtil.httpServerTemplateForNNAndJN((Configuration)this.conf, (InetSocketAddress)this.httpAddress, (InetSocketAddress)this.httpsAddress, (String)webApp, (String)"dfs.federation.router.kerberos.internal.spnego.principal", (String)"dfs.federation.router.keytab.file");
        this.httpServer = builder.build();
        String httpKeytab = this.conf.get(DFSUtil.getSpnegoKeytabKey((Configuration)this.conf, (String)"dfs.federation.router.keytab.file"));
        NameNodeHttpServer.initWebHdfs((Configuration)this.conf, (String)this.httpAddress.getHostName(), (String)httpKeytab, (HttpServer2)this.httpServer, (String)RouterWebHdfsMethods.class.getPackage().getName());
        this.httpServer.setAttribute(NAMENODE_ATTRIBUTE_KEY, (Object)this.router);
        this.httpServer.setAttribute("current.conf", (Object)this.conf);
        RouterHttpServer.setupServlets(this.httpServer, this.conf);
        this.httpServer.start();
        InetSocketAddress listenAddress = this.httpServer.getConnectorAddress(0);
        if (listenAddress != null) {
            this.httpAddress = new InetSocketAddress(this.httpAddress.getHostName(), listenAddress.getPort());
        }
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.httpServer != null) {
            this.httpServer.stop();
        }
        super.serviceStop();
    }

    private static void setupServlets(HttpServer2 httpServer, Configuration conf) {
        httpServer.addInternalServlet("isActive", "/isActive", IsRouterActiveServlet.class);
        httpServer.addInternalServlet("fsck", "/fsck", RouterFsckServlet.class, true);
        httpServer.addInternalServlet("topology", "/topology", RouterNetworkTopologyServlet.class);
    }

    public InetSocketAddress getHttpAddress() {
        return this.httpAddress;
    }

    public InetSocketAddress getHttpsAddress() {
        return this.httpsAddress;
    }

    static Configuration getConfFromContext(ServletContext context) {
        return (Configuration)context.getAttribute("current.conf");
    }

    public static Router getRouterFromContext(ServletContext context) {
        return (Router)((Object)context.getAttribute(NAMENODE_ATTRIBUTE_KEY));
    }
}

