/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterHttpServer;
import org.apache.hadoop.hdfs.server.namenode.NetworkTopologyServlet;
import org.apache.hadoop.util.StringUtils;

public class RouterNetworkTopologyServlet
extends NetworkTopologyServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        ServletContext context = this.getServletContext();
        String format = RouterNetworkTopologyServlet.parseAcceptHeader((HttpServletRequest)request);
        if ("text".equals(format)) {
            response.setContentType("text/plain; charset=UTF-8");
        } else if ("json".equals(format)) {
            response.setContentType("application/json; charset=UTF-8");
        }
        Router router = RouterHttpServer.getRouterFromContext(context);
        DatanodeInfo[] datanodeReport = router.getRpcServer().getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
        List<DatanodeInfo> datanodeInfos = Arrays.asList(datanodeReport);
        try (PrintStream out = new PrintStream((OutputStream)response.getOutputStream(), false, "UTF-8");){
            this.printTopology(out, datanodeInfos, format);
        }
        catch (Throwable t) {
            String errMsg = "Print network topology failed. " + StringUtils.stringifyException((Throwable)t);
            response.sendError(410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }
}

