/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.gridmix;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.ClusterStatus;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Utils;
import org.apache.hadoop.mapred.gridmix.CompressionEmulationUtil;
import org.apache.hadoop.mapred.gridmix.GridmixJob;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;

class GenerateData
extends GridmixJob {
    public static final String GRIDMIX_GEN_BYTES = "gridmix.gen.bytes";
    public static final String GRIDMIX_GEN_CHUNK = "gridmix.gen.bytes.per.file";
    public static final String GRIDMIX_VAL_BYTES = "gendata.val.bytes";
    public static final String GRIDMIX_GEN_INTERVAL = "gendata.interval.mb";
    public static final String GRIDMIX_GEN_BLOCKSIZE = "gridmix.gen.blocksize";
    public static final String GRIDMIX_GEN_REPLICATION = "gridmix.gen.replicas";
    static final String JOB_NAME = "GRIDMIX_GENERATE_INPUT_DATA";

    public GenerateData(Configuration conf, Path outdir, long genbytes) throws IOException {
        super(conf, 0L, JOB_NAME);
        this.job.getConfiguration().setLong(GRIDMIX_GEN_BYTES, genbytes);
        FileOutputFormat.setOutputPath((Job)this.job, (Path)outdir);
    }

    static DataStatistics publishDataStatistics(Path inputDir, long genBytes, Configuration conf) throws IOException {
        if (CompressionEmulationUtil.isCompressionEmulationEnabled(conf)) {
            return CompressionEmulationUtil.publishCompressedDataStatistics(inputDir, conf, genBytes);
        }
        return GenerateData.publishPlainDataStatistics(conf, inputDir);
    }

    static DataStatistics publishPlainDataStatistics(Configuration conf, Path inputDir) throws IOException {
        FileSystem fs = inputDir.getFileSystem(conf);
        long dataSize = 0L;
        long fileCount = 0L;
        RemoteIterator iter = fs.listFiles(inputDir, true);
        Utils.OutputFileUtils.OutputFilesFilter filter = new Utils.OutputFileUtils.OutputFilesFilter();
        while (iter.hasNext()) {
            LocatedFileStatus lStatus = (LocatedFileStatus)iter.next();
            if (!filter.accept(lStatus.getPath())) continue;
            dataSize += lStatus.getLen();
            ++fileCount;
        }
        LOG.info("Total size of input data : " + StringUtils.humanReadableInt((long)dataSize));
        LOG.info("Total number of input data files : " + fileCount);
        return new DataStatistics(dataSize, fileCount, false);
    }

    @Override
    public Job call() throws IOException, InterruptedException, ClassNotFoundException {
        UserGroupInformation ugi = UserGroupInformation.getLoginUser();
        ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Job>(){

            @Override
            public Job run() throws IOException, ClassNotFoundException, InterruptedException {
                if (CompressionEmulationUtil.isCompressionEmulationEnabled(GenerateData.this.job.getConfiguration())) {
                    CompressionEmulationUtil.configure(GenerateData.this.job);
                } else {
                    this.configureRandomBytesDataGenerator();
                }
                GenerateData.this.job.submit();
                return GenerateData.this.job;
            }

            private void configureRandomBytesDataGenerator() {
                GenerateData.this.job.setMapperClass(GenDataMapper.class);
                GenerateData.this.job.setNumReduceTasks(0);
                GenerateData.this.job.setMapOutputKeyClass(NullWritable.class);
                GenerateData.this.job.setMapOutputValueClass(BytesWritable.class);
                GenerateData.this.job.setInputFormatClass(GenDataFormat.class);
                GenerateData.this.job.setOutputFormatClass(RawBytesOutputFormat.class);
                GenerateData.this.job.setJarByClass(GenerateData.class);
                try {
                    FileInputFormat.addInputPath((Job)GenerateData.this.job, (Path)new Path("ignored"));
                }
                catch (IOException e) {
                    GridmixJob.LOG.error("Error while adding input path ", (Throwable)e);
                }
            }
        });
        return this.job;
    }

    @Override
    protected boolean canEmulateCompression() {
        return false;
    }

    static class RawBytesOutputFormat
    extends FileOutputFormat<NullWritable, BytesWritable> {
        RawBytesOutputFormat() {
        }

        public RecordWriter<NullWritable, BytesWritable> getRecordWriter(TaskAttemptContext job) throws IOException {
            return new ChunkWriter(this.getDefaultWorkFile(job, ""), job.getConfiguration());
        }

        static class ChunkWriter
        extends RecordWriter<NullWritable, BytesWritable> {
            private final Path outDir;
            private final FileSystem fs;
            private final int blocksize;
            private final short replicas;
            private final FsPermission genPerms = new FsPermission(511);
            private final long maxFileBytes;
            private long accFileBytes = 0L;
            private long fileIdx = -1L;
            private OutputStream fileOut = null;

            public ChunkWriter(Path outDir, Configuration conf) throws IOException {
                this.outDir = outDir;
                this.fs = outDir.getFileSystem(conf);
                this.blocksize = conf.getInt(GenerateData.GRIDMIX_GEN_BLOCKSIZE, 0x10000000);
                this.replicas = (short)conf.getInt(GenerateData.GRIDMIX_GEN_REPLICATION, 3);
                this.maxFileBytes = conf.getLong(GenerateData.GRIDMIX_GEN_CHUNK, 0x40000000L);
                this.nextDestination();
            }

            private void nextDestination() throws IOException {
                if (this.fileOut != null) {
                    this.fileOut.close();
                }
                this.fileOut = this.fs.create(new Path(this.outDir, "segment-" + ++this.fileIdx), this.genPerms, false, 65536, this.replicas, (long)this.blocksize, null);
                this.accFileBytes = 0L;
            }

            public void write(NullWritable key, BytesWritable value) throws IOException {
                int written = 0;
                int total = value.getLength();
                while (written < total) {
                    if (this.accFileBytes >= this.maxFileBytes) {
                        this.nextDestination();
                    }
                    int write = (int)Math.min((long)(total - written), this.maxFileBytes - this.accFileBytes);
                    this.fileOut.write(value.getBytes(), written, write);
                    written += write;
                    this.accFileBytes += (long)write;
                }
            }

            public void close(TaskAttemptContext ctxt) throws IOException {
                this.fileOut.close();
            }
        }
    }

    static class GenSplit
    extends InputSplit
    implements Writable {
        private long bytes;
        private int nLoc;
        private String[] locations;

        public GenSplit() {
        }

        public GenSplit(long bytes, String[] locations) {
            this(bytes, locations.length, locations);
        }

        public GenSplit(long bytes, int nLoc, String[] locations) {
            this.bytes = bytes;
            this.nLoc = nLoc;
            this.locations = Arrays.copyOf(locations, nLoc);
        }

        public long getLength() {
            return this.bytes;
        }

        public String[] getLocations() {
            return this.locations;
        }

        public void readFields(DataInput in) throws IOException {
            this.bytes = in.readLong();
            this.nLoc = in.readInt();
            if (null == this.locations || this.locations.length < this.nLoc) {
                this.locations = new String[this.nLoc];
            }
            for (int i = 0; i < this.nLoc; ++i) {
                this.locations[i] = Text.readString((DataInput)in);
            }
        }

        public void write(DataOutput out) throws IOException {
            out.writeLong(this.bytes);
            out.writeInt(this.nLoc);
            for (int i = 0; i < this.nLoc; ++i) {
                Text.writeString((DataOutput)out, (String)this.locations[i]);
            }
        }
    }

    static class GenDataFormat
    extends InputFormat<NullWritable, LongWritable> {
        GenDataFormat() {
        }

        public List<InputSplit> getSplits(JobContext jobCtxt) throws IOException {
            JobClient client = new JobClient(new JobConf(jobCtxt.getConfiguration()));
            ClusterStatus stat = client.getClusterStatus(true);
            long toGen = jobCtxt.getConfiguration().getLong(GenerateData.GRIDMIX_GEN_BYTES, -1L);
            if (toGen < 0L) {
                throw new IOException("Invalid/missing generation bytes: " + toGen);
            }
            int nTrackers = stat.getTaskTrackers();
            long bytesPerTracker = toGen / (long)nTrackers;
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>(nTrackers);
            Pattern trackerPattern = Pattern.compile("tracker_([^:]*):.*");
            Matcher m = trackerPattern.matcher("");
            for (String tracker : stat.getActiveTrackerNames()) {
                m.reset(tracker);
                if (!m.find()) {
                    System.err.println("Skipping node: " + tracker);
                    continue;
                }
                String name = m.group(1);
                splits.add(new GenSplit(bytesPerTracker, new String[]{name}));
            }
            return splits;
        }

        public RecordReader<NullWritable, LongWritable> createRecordReader(InputSplit split, final TaskAttemptContext taskContext) throws IOException {
            return new RecordReader<NullWritable, LongWritable>(){
                long written = 0L;
                long write = 0L;
                long RINTERVAL;
                long toWrite;
                final NullWritable key = NullWritable.get();
                final LongWritable val = new LongWritable();

                public void initialize(InputSplit split, TaskAttemptContext ctxt) throws IOException, InterruptedException {
                    this.toWrite = split.getLength();
                    this.RINTERVAL = ctxt.getConfiguration().getInt(GenerateData.GRIDMIX_GEN_INTERVAL, 10) << 20;
                }

                public boolean nextKeyValue() throws IOException {
                    this.written += this.write;
                    this.write = Math.min(this.toWrite - this.written, this.RINTERVAL);
                    this.val.set(this.write);
                    return this.written < this.toWrite;
                }

                public float getProgress() throws IOException {
                    return (float)this.written / (float)this.toWrite;
                }

                public NullWritable getCurrentKey() {
                    return this.key;
                }

                public LongWritable getCurrentValue() {
                    return this.val;
                }

                public void close() throws IOException {
                    taskContext.setStatus("Wrote " + this.toWrite);
                }
            };
        }
    }

    public static class GenDataMapper
    extends Mapper<NullWritable, LongWritable, NullWritable, BytesWritable> {
        private BytesWritable val;
        private final Random r = new Random();

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            this.val = new BytesWritable(new byte[context.getConfiguration().getInt(GenerateData.GRIDMIX_VAL_BYTES, 0x100000)]);
        }

        public void map(NullWritable key, LongWritable value, Mapper.Context context) throws IOException, InterruptedException {
            for (long bytes = value.get(); bytes > 0L; bytes -= (long)this.val.getLength()) {
                this.r.nextBytes(this.val.getBytes());
                this.val.setSize((int)Math.min((long)this.val.getLength(), bytes));
                context.write((Object)key, (Object)this.val);
            }
        }
    }

    static class DataStatistics {
        private long dataSize;
        private long numFiles;
        private boolean isDataCompressed;

        DataStatistics(long dataSize, long numFiles, boolean isCompressed) {
            this.dataSize = dataSize;
            this.numFiles = numFiles;
            this.isDataCompressed = isCompressed;
        }

        long getDataSize() {
            return this.dataSize;
        }

        long getNumFiles() {
            return this.numFiles;
        }

        boolean isDataCompressed() {
            return this.isDataCompressed;
        }
    }
}

