/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.fedbalance.procedure;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.tools.fedbalance.procedure.BalanceProcedure;

public class MultiPhaseProcedure
extends BalanceProcedure {
    private int totalPhase;
    private int currentPhase = 0;
    private Configuration conf;
    private FileSystem fs;
    private Path path;

    public MultiPhaseProcedure() {
    }

    public MultiPhaseProcedure(String name, long delay, int totalPhase, Configuration config, String spath) throws IOException {
        super(name, delay);
        this.totalPhase = totalPhase;
        this.conf = config;
        this.path = new Path(spath);
        this.fs = this.path.getFileSystem(config);
    }

    public boolean execute() throws IOException {
        if (this.currentPhase < this.totalPhase) {
            LOG.info("Current phase {}", (Object)this.currentPhase);
            Path phase = new Path(this.path, "phase-" + this.currentPhase);
            if (!this.fs.exists(phase)) {
                this.fs.mkdirs(phase);
            }
            ++this.currentPhase;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.totalPhase);
        out.writeInt(this.currentPhase);
        this.conf.write(out);
        Text.writeString((DataOutput)out, (String)this.path.toString());
    }

    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this.totalPhase = in.readInt();
        this.currentPhase = in.readInt();
        this.conf = new Configuration(false);
        this.conf.readFields(in);
        this.path = new Path(Text.readString((DataInput)in));
        this.fs = this.path.getFileSystem(this.conf);
    }
}

