/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.mapred;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.maprfs.AbstractMapRFileSystem;
import org.apache.hadoop.tools.CopyListingFileStatus;
import org.apache.hadoop.tools.DistCpOptions;
import org.apache.hadoop.tools.mapred.CopyMapper;
import org.apache.hadoop.tools.util.DistCpUtils;
import org.apache.hadoop.tools.util.RetriableCommand;
import org.apache.hadoop.tools.util.ThrottledInputStream;
import org.apache.hadoop.util.Progressable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetriableFileCopyCommand
extends RetriableCommand {
    private static Logger LOG = LoggerFactory.getLogger(RetriableFileCopyCommand.class);
    private static int BUFFER_SIZE = 8192;
    private boolean skipCrc = false;
    private CopyMapper.FileAction action;

    public RetriableFileCopyCommand(String description, CopyMapper.FileAction action) {
        super(description);
        this.action = action;
    }

    public RetriableFileCopyCommand(boolean skipCrc, String description, CopyMapper.FileAction action) {
        this(description, action);
        this.skipCrc = skipCrc;
    }

    @Override
    protected Object doExecute(Object ... arguments) throws Exception {
        assert (arguments.length == 4) : "Unexpected argument list.";
        CopyListingFileStatus source = (CopyListingFileStatus)((Object)arguments[0]);
        assert (!source.isDirectory()) : "Unexpected file-status. Expected file.";
        Path target = (Path)arguments[1];
        Mapper.Context context = (Mapper.Context)arguments[2];
        EnumSet fileAttributes = (EnumSet)arguments[3];
        return this.doCopy(source, target, context, fileAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doCopy(CopyListingFileStatus source, Path target, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes) throws IOException {
        boolean toAppend = this.action == CopyMapper.FileAction.APPEND;
        Path targetPath = toAppend ? target : DistCpUtils.getTmpFile(target, context, source.isSplit());
        Configuration configuration = context.getConfiguration();
        FileSystem targetFS = target.getFileSystem(configuration);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Copying " + source.getPath() + " to " + target);
                LOG.debug("Target file path: " + targetPath);
            }
            Path sourcePath = source.getPath();
            FileSystem sourceFS = sourcePath.getFileSystem(configuration);
            FileChecksum sourceChecksum = fileAttributes.contains((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE) ? sourceFS.getFileChecksum(sourcePath) : null;
            long offset = this.action == CopyMapper.FileAction.APPEND ? targetFS.getFileStatus(target).getLen() : source.getChunkOffset();
            long bytesRead = this.copyToFile(targetPath, targetFS, source, offset, context, fileAttributes, sourceChecksum);
            if (!source.isSplit()) {
                this.compareFileLengths(source, targetPath, configuration, bytesRead + offset);
            }
            if (!(bytesRead == 0L || this.skipCrc || source.isSymlink() || source.isSplit())) {
                this.compareCheckSums(sourceFS, source.getPath(), sourceChecksum, targetFS, targetPath);
            }
            if (!toAppend && !source.isSplit()) {
                this.promoteTmpToTarget(targetPath, target, targetFS);
            }
            long l = bytesRead;
            return l;
        }
        finally {
            if (!toAppend && targetFS.exists(targetPath) && !source.isSplit()) {
                targetFS.delete(targetPath, false);
            }
        }
    }

    private Options.ChecksumOpt getChecksumOpt(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileChecksum sourceChecksum) {
        if (fileAttributes.contains((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE) && sourceChecksum != null) {
            return sourceChecksum.getChecksumOpt();
        }
        return null;
    }

    private long copyToFile(Path targetPath, FileSystem targetFS, CopyListingFileStatus sourceFileStatus, long sourceOffset, Mapper.Context context, EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileChecksum sourceChecksum) throws IOException {
        BufferedOutputStream outStream;
        if (sourceFileStatus.isSymlink() && targetFS instanceof AbstractMapRFileSystem) {
            AbstractMapRFileSystem mapRFileSystem = (AbstractMapRFileSystem)targetFS;
            mapRFileSystem.createSymlink(sourceFileStatus.getSymlink(), targetPath, false);
            return sourceFileStatus.getLen();
        }
        FsPermission permission = FsPermission.getFileDefault().applyUMask(FsPermission.getUMask((Configuration)targetFS.getConf()));
        if (!(this.action != CopyMapper.FileAction.OVERWRITE || sourceFileStatus.isSplit() && targetFS.exists(targetPath))) {
            short repl = RetriableFileCopyCommand.getReplicationFactor(fileAttributes, sourceFileStatus, targetFS, targetPath);
            long blockSize = RetriableFileCopyCommand.getBlockSize(fileAttributes, sourceFileStatus, targetFS, targetPath);
            FSDataOutputStream out = targetFS.create(targetPath, permission, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), BUFFER_SIZE, repl, blockSize, (Progressable)context, this.getChecksumOpt(fileAttributes, sourceChecksum));
            if (targetFS instanceof AbstractMapRFileSystem) {
                out.seek(sourceFileStatus.getChunkOffset());
            }
            outStream = new BufferedOutputStream((OutputStream)out);
        } else {
            FSDataOutputStream out = targetFS.append(targetPath, BUFFER_SIZE);
            if (targetFS instanceof AbstractMapRFileSystem) {
                out.seek(sourceFileStatus.getChunkOffset());
            }
            outStream = new BufferedOutputStream((OutputStream)out);
        }
        return this.copyBytes(sourceFileStatus, sourceOffset, outStream, BUFFER_SIZE, context);
    }

    private void compareFileLengths(FileStatus sourceFileStatus, Path target, Configuration configuration, long targetLen) throws IOException {
        Path sourcePath = sourceFileStatus.getPath();
        FileSystem fs = sourcePath.getFileSystem(configuration);
        if (fs.getFileStatus(sourcePath).getLen() != targetLen) {
            throw new IOException("Mismatch in length of source:" + sourcePath + " and target:" + target);
        }
    }

    private void compareCheckSums(FileSystem sourceFS, Path source, FileChecksum sourceChecksum, FileSystem targetFS, Path target) throws IOException {
        if (!DistCpUtils.checksumsAreEqual(sourceFS, source, sourceChecksum, targetFS, target)) {
            StringBuilder errorMessage = new StringBuilder("Check-sum mismatch between ").append(source).append(" and ").append(target).append(".");
            if (sourceFS.getFileStatus(source).getBlockSize() != targetFS.getFileStatus(target).getBlockSize()) {
                errorMessage.append(" Source and target differ in block-size.").append(" Use -pb to preserve block-sizes during copy.").append(" Alternatively, skip checksum-checks altogether, using -skipCrc.").append(" (NOTE: By skipping checksums, one runs the risk of masking data-corruption during file-transfer.)");
            }
            throw new IOException(errorMessage.toString());
        }
    }

    private void promoteTmpToTarget(Path tmpTarget, Path target, FileSystem fs) throws IOException {
        if (fs.exists(target) && !fs.delete(target, false) || !fs.exists(target.getParent()) && !fs.mkdirs(target.getParent()) || !fs.rename(tmpTarget, target)) {
            throw new IOException("Failed to promote tmp-file:" + tmpTarget + " to: " + target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    long copyBytes(CopyListingFileStatus source2, long sourceOffset, OutputStream outStream, int bufferSize, Mapper.Context context) throws IOException {
        Path source = source2.getPath();
        byte[] buf = new byte[bufferSize];
        ThrottledInputStream inStream = null;
        long totalBytesRead = 0L;
        long chunkLength = source2.getChunkLength();
        boolean finished = false;
        try {
            inStream = RetriableFileCopyCommand.getInputStream(source, context.getConfiguration());
            RetriableFileCopyCommand.seekIfRequired(inStream, sourceOffset);
            int bytesRead = RetriableFileCopyCommand.readBytes(inStream, buf);
            while (bytesRead >= 0) {
                if (chunkLength > 0L && totalBytesRead + (long)bytesRead >= chunkLength) {
                    bytesRead = (int)(chunkLength - totalBytesRead);
                    finished = true;
                }
                totalBytesRead += (long)bytesRead;
                if (this.action == CopyMapper.FileAction.APPEND) {
                    sourceOffset += (long)bytesRead;
                }
                outStream.write(buf, 0, bytesRead);
                this.updateContextStatus(totalBytesRead, context, source2);
                if (finished) break;
                bytesRead = RetriableFileCopyCommand.readBytes(inStream, buf);
            }
            outStream.close();
            outStream = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outStream, inStream});
            throw throwable;
        }
        IOUtils.cleanupWithLogger((Logger)LOG, (Closeable[])new Closeable[]{outStream, inStream});
        return totalBytesRead;
    }

    private void updateContextStatus(long totalBytesRead, Mapper.Context context, FileStatus sourceFileStatus) {
        StringBuilder message = new StringBuilder(DistCpUtils.getFormatter().format((float)totalBytesRead * 100.0f / (float)sourceFileStatus.getLen()));
        message.append("% ").append(this.description).append(" [").append(DistCpUtils.getStringDescriptionFor(totalBytesRead)).append('/').append(DistCpUtils.getStringDescriptionFor(sourceFileStatus.getLen())).append(']');
        context.setStatus(message.toString());
    }

    private static int readBytes(ThrottledInputStream inStream, byte[] buf) throws IOException {
        try {
            return inStream.read(buf);
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static void seekIfRequired(ThrottledInputStream inStream, long sourceOffset) throws IOException {
        try {
            if (sourceOffset != inStream.getPos()) {
                inStream.seek(sourceOffset);
            }
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static ThrottledInputStream getInputStream(Path path, Configuration conf) throws IOException {
        try {
            FileSystem fs = path.getFileSystem(conf);
            long bandwidthMB = conf.getInt("distcp.map.bandwidth.mb", 100);
            FSDataInputStream in = fs.open(path);
            return new ThrottledInputStream((InputStream)in, bandwidthMB * 1024L * 1024L);
        }
        catch (IOException e) {
            throw new CopyReadException(e);
        }
    }

    private static short getReplicationFactor(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileStatus sourceFile, FileSystem targetFS, Path tmpTargetPath) {
        return fileAttributes.contains((Object)DistCpOptions.FileAttribute.REPLICATION) ? sourceFile.getReplication() : targetFS.getDefaultReplication(tmpTargetPath);
    }

    private static long getBlockSize(EnumSet<DistCpOptions.FileAttribute> fileAttributes, FileStatus sourceFile, FileSystem targetFS, Path tmpTargetPath) {
        boolean preserve = fileAttributes.contains((Object)DistCpOptions.FileAttribute.BLOCKSIZE) || fileAttributes.contains((Object)DistCpOptions.FileAttribute.CHECKSUMTYPE);
        return preserve ? sourceFile.getBlockSize() : targetFS.getDefaultBlockSize(tmpTargetPath);
    }

    public static class CopyReadException
    extends IOException {
        public CopyReadException(Throwable rootCause) {
            super(rootCause);
        }
    }
}

