/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.jcajce;

import java.security.PrivateKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DefaultTlsCredentialedSigner;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.SignatureScheme;
import org.bouncycastle.tls.crypto.TlsCryptoParameters;
import org.bouncycastle.tls.crypto.TlsSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.ECUtil;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSA13Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsECDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd25519Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsEd448Signer;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsMLDSASigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSAPSSSigner;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsRSASigner;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JcaDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(JcaTlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        TlsSigner signer;
        String algorithm = privateKey.getAlgorithm();
        if (privateKey instanceof RSAPrivateKey || "RSA".equalsIgnoreCase(algorithm) || "RSASSA-PSS".equalsIgnoreCase(algorithm)) {
            int signatureScheme;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isRSAPSS(signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new JcaTlsRSAPSSSigner(crypto, privateKey, signatureScheme);
            }
            signer = new JcaTlsRSASigner(crypto, privateKey);
        } else if (privateKey instanceof DSAPrivateKey || "DSA".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsDSASigner(crypto, privateKey);
        } else if (ECUtil.isECPrivateKey(privateKey)) {
            int signatureScheme;
            if (signatureAndHashAlgorithm != null && SignatureScheme.isECDSA(signatureScheme = SignatureScheme.from(signatureAndHashAlgorithm))) {
                return new JcaTlsECDSA13Signer(crypto, privateKey, signatureScheme);
            }
            signer = new JcaTlsECDSASigner(crypto, privateKey);
        } else if ("Ed25519".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsEd25519Signer(crypto, privateKey);
        } else if ("Ed448".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsEd448Signer(crypto, privateKey);
        } else if ("ML-DSA-44".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsMLDSASigner(crypto, privateKey, 2308);
        } else if ("ML-DSA-65".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsMLDSASigner(crypto, privateKey, 2309);
        } else if ("ML-DSA-87".equalsIgnoreCase(algorithm)) {
            signer = new JcaTlsMLDSASigner(crypto, privateKey, 2310);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public JcaDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, JcaTlsCrypto crypto, PrivateKey privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, JcaDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey, certificate, signatureAndHashAlgorithm), certificate, signatureAndHashAlgorithm);
    }
}

