/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.ssl;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.client.ConnectionConfigurator;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.KeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLHostnameVerifier;
import org.apache.hadoop.util.PlatformName;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SSLFactory
implements ConnectionConfigurator {
    static final Logger LOG = LoggerFactory.getLogger(SSLFactory.class);
    public static final String SSL_CLIENT_CONF_KEY = "hadoop.ssl.client.conf";
    public static final String SSL_CLIENT_CONF_DEFAULT = "ssl-client.xml";
    public static final String SSL_SERVER_CONF_KEY = "hadoop.ssl.server.conf";
    public static final String SSL_SERVER_CONF_DEFAULT = "ssl-server.xml";
    public static final String SSL_REQUIRE_CLIENT_CERT_KEY = "hadoop.ssl.require.client.cert";
    public static final boolean SSL_REQUIRE_CLIENT_CERT_DEFAULT = false;
    public static final String SSL_HOSTNAME_VERIFIER_KEY = "hadoop.ssl.hostname.verifier";
    public static final String SSL_ENABLED_PROTOCOLS_KEY = "hadoop.ssl.enabled.protocols";
    public static final String SSL_ENABLED_PROTOCOLS_DEFAULT = "TLSv1.2";
    public static final String SSL_SERVER_NEED_CLIENT_AUTH = "ssl.server.need.client.auth";
    public static final boolean SSL_SERVER_NEED_CLIENT_AUTH_DEFAULT = false;
    public static final String SSL_SERVER_KEYSTORE_LOCATION = "ssl.server.keystore.location";
    public static final String SSL_SERVER_KEYSTORE_PASSWORD = "ssl.server.keystore.password";
    public static final String SSL_SERVER_KEYSTORE_TYPE = "ssl.server.keystore.type";
    public static final String SSL_SERVER_KEYSTORE_TYPE_DEFAULT = "jks";
    public static final String SSL_SERVER_KEYSTORE_KEYPASSWORD = "ssl.server.keystore.keypassword";
    public static final String SSL_SERVER_TRUSTSTORE_LOCATION = "ssl.server.truststore.location";
    public static final String SSL_SERVER_TRUSTSTORE_PASSWORD = "ssl.server.truststore.password";
    public static final String SSL_SERVER_TRUSTSTORE_TYPE = "ssl.server.truststore.type";
    public static final String SSL_SERVER_TRUSTSTORE_TYPE_DEFAULT = "jks";
    public static final String SSL_CLIENT_KEYSTORE_TYPE = "ssl.client.keystore.type";
    public static final String SSL_CLIENT_KEYSTORE_TYPE_DEFAULT = "jks";
    public static final String SSL_SERVER_EXCLUDE_CIPHER_LIST = "ssl.server.exclude.cipher.list";
    public static final String SSL_SERVER_INCLUDE_CIPHER_LIST = "ssl.server.include.cipher.list";
    public static final String KEY_MANAGER_SSLCERTIFICATE = PlatformName.IBM_JAVA ? "ibmX509" : KeyManagerFactory.getDefaultAlgorithm();
    public static final String TRUST_MANAGER_SSLCERTIFICATE = PlatformName.IBM_JAVA ? "ibmX509" : TrustManagerFactory.getDefaultAlgorithm();
    public static final String KEYSTORES_FACTORY_CLASS_KEY = "hadoop.ssl.keystores.factory.class";
    private Configuration conf;
    private Mode mode;
    private boolean requireClientCert;
    private SSLContext context;
    private SSLSocketFactory socketFactory;
    private HostnameVerifier hostnameVerifier;
    private KeyStoresFactory keystoresFactory;
    private String[] enabledProtocols = null;
    private List<String> excludeCiphers;
    private List<String> includeCiphers;

    public SSLFactory(Mode mode, Configuration conf) {
        this.conf = conf;
        if (mode == null) {
            throw new IllegalArgumentException("mode cannot be NULL");
        }
        this.mode = mode;
        Configuration sslConf = SSLFactory.readSSLConfiguration(conf, mode);
        this.requireClientCert = sslConf.getBoolean(SSL_REQUIRE_CLIENT_CERT_KEY, false);
        Class<KeyStoresFactory> klass = conf.getClass(KEYSTORES_FACTORY_CLASS_KEY, FileBasedKeyStoresFactory.class, KeyStoresFactory.class);
        this.keystoresFactory = ReflectionUtils.newInstance(klass, sslConf);
        this.enabledProtocols = conf.getStrings(SSL_ENABLED_PROTOCOLS_KEY, SSL_ENABLED_PROTOCOLS_DEFAULT);
        this.excludeCiphers = Arrays.asList(sslConf.getTrimmedStrings(SSL_SERVER_EXCLUDE_CIPHER_LIST));
        this.includeCiphers = Arrays.asList(sslConf.getTrimmedStrings(SSL_SERVER_INCLUDE_CIPHER_LIST));
        if (LOG.isDebugEnabled()) {
            LOG.debug("will exclude cipher suites: {}", (Object)StringUtils.join((CharSequence)",", this.excludeCiphers));
            LOG.debug("will include cipher suites: {}", (Object)StringUtils.join((CharSequence)",", this.includeCiphers));
        }
    }

    public static Configuration readSSLConfiguration(Configuration conf, Mode mode) {
        Configuration sslConf = new Configuration(false);
        sslConf.setBoolean(SSL_REQUIRE_CLIENT_CERT_KEY, conf.getBoolean(SSL_REQUIRE_CLIENT_CERT_KEY, false));
        String sslConfResource = mode == Mode.CLIENT ? conf.get(SSL_CLIENT_CONF_KEY, SSL_CLIENT_CONF_DEFAULT) : conf.get(SSL_SERVER_CONF_KEY, SSL_SERVER_CONF_DEFAULT);
        sslConf.addResource(sslConfResource);
        if (sslConf.getResource(sslConfResource) == null) {
            LOG.debug("{} can't be loaded form classpath, fallback using SSL config from input configuration.", (Object)sslConfResource);
            sslConf = conf;
        }
        return sslConf;
    }

    public void init() throws GeneralSecurityException, IOException {
        this.keystoresFactory.init(this.mode);
        this.context = SSLContext.getInstance("TLS");
        this.context.init(this.keystoresFactory.getKeyManagers(), this.keystoresFactory.getTrustManagers(), null);
        this.context.getDefaultSSLParameters().setProtocols(this.enabledProtocols);
        if (this.mode == Mode.CLIENT) {
            this.socketFactory = this.context.getSocketFactory();
        }
        this.hostnameVerifier = this.getHostnameVerifier(this.conf);
    }

    private HostnameVerifier getHostnameVerifier(Configuration conf) throws GeneralSecurityException, IOException {
        return SSLFactory.getHostnameVerifier(StringUtils.toUpperCase(conf.get(SSL_HOSTNAME_VERIFIER_KEY, "DEFAULT").trim()));
    }

    public static HostnameVerifier getHostnameVerifier(String verifier) throws GeneralSecurityException, IOException {
        SSLHostnameVerifier hostnameVerifier;
        if (verifier.equals("DEFAULT")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT;
        } else if (verifier.equals("DEFAULT_AND_LOCALHOST")) {
            hostnameVerifier = SSLHostnameVerifier.DEFAULT_AND_LOCALHOST;
        } else if (verifier.equals("STRICT")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT;
        } else if (verifier.equals("STRICT_IE6")) {
            hostnameVerifier = SSLHostnameVerifier.STRICT_IE6;
        } else if (verifier.equals("ALLOW_ALL")) {
            hostnameVerifier = SSLHostnameVerifier.ALLOW_ALL;
        } else {
            throw new GeneralSecurityException("Invalid hostname verifier: " + verifier);
        }
        return hostnameVerifier;
    }

    public void destroy() {
        this.keystoresFactory.destroy();
    }

    public KeyStoresFactory getKeystoresFactory() {
        return this.keystoresFactory;
    }

    public SSLEngine createSSLEngine() throws GeneralSecurityException, IOException {
        SSLEngine sslEngine = this.context.createSSLEngine();
        if (this.mode == Mode.CLIENT) {
            sslEngine.setUseClientMode(true);
        } else {
            sslEngine.setUseClientMode(false);
            sslEngine.setNeedClientAuth(this.requireClientCert);
            this.callSetEnabledCipherSuites(sslEngine);
        }
        sslEngine.setEnabledProtocols(this.enabledProtocols);
        return sslEngine;
    }

    private void callSetEnabledCipherSuites(SSLEngine sslEngine) {
        Stream<String> cipherSuites = Arrays.stream(sslEngine.getSupportedCipherSuites());
        if (CollectionUtils.isNotEmpty(this.includeCiphers)) {
            cipherSuites = cipherSuites.filter(s -> this.includeCiphers.contains(s));
        }
        if (CollectionUtils.isNotEmpty(this.excludeCiphers)) {
            cipherSuites = cipherSuites.filter(s -> !this.excludeCiphers.contains(s));
        }
        String[] enabledCipherSuites = (String[])cipherSuites.toArray(String[]::new);
        LOG.debug("Enabled cipher suites: {}", (Object)StringUtils.join((CharSequence)",", enabledCipherSuites));
        sslEngine.setEnabledCipherSuites(enabledCipherSuites);
    }

    public SSLServerSocketFactory createSSLServerSocketFactory() throws GeneralSecurityException, IOException {
        if (this.mode != Mode.SERVER) {
            throw new IllegalStateException("Factory is not in SERVER mode. Actual mode is " + this.mode.toString());
        }
        return this.context.getServerSocketFactory();
    }

    public SSLSocketFactory createSSLSocketFactory() throws GeneralSecurityException, IOException {
        if (this.mode != Mode.CLIENT) {
            throw new IllegalStateException("Factory is not in CLIENT mode. Actual mode is " + this.mode.toString());
        }
        return this.socketFactory;
    }

    public HostnameVerifier getHostnameVerifier() {
        if (this.mode != Mode.CLIENT) {
            throw new IllegalStateException("Factory is not in CLIENT mode. Actual mode is " + this.mode.toString());
        }
        return this.hostnameVerifier;
    }

    public boolean isClientCertRequired() {
        return this.requireClientCert;
    }

    public HttpURLConnection configure(HttpURLConnection conn) throws IOException {
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection sslConn = (HttpsURLConnection)conn;
            try {
                sslConn.setSSLSocketFactory(this.createSSLSocketFactory());
            }
            catch (GeneralSecurityException ex) {
                throw new IOException(ex);
            }
            sslConn.setHostnameVerifier(this.getHostnameVerifier());
            conn = sslConn;
        }
        return conn;
    }

    @InterfaceAudience.Private
    public static enum Mode {
        CLIENT,
        SERVER;

    }
}

