/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.StoreResponse;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdConstants;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContext;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdFramer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdObjectMapper;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdResponseHeaders;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdResponseStatus;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.EmptyByteBuf;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

@JsonPropertyOrder(value={"frame", "headers", "content"})
public final class RntbdResponse
implements ReferenceCounted {
    @JsonSerialize(using=PayloadSerializer.class)
    @JsonProperty
    private final ByteBuf content;
    @JsonProperty
    private final RntbdResponseStatus frame;
    @JsonProperty
    private final RntbdResponseHeaders headers;
    private AtomicInteger referenceCount = new AtomicInteger();

    public RntbdResponse(UUID activityId, int statusCode, Map<String, String> map, ByteBuf content) {
        this.headers = RntbdResponseHeaders.fromMap(map, content.readableBytes() > 0);
        this.content = content.retain();
        HttpResponseStatus status = HttpResponseStatus.valueOf((int)statusCode);
        int length = 24 + this.headers.computeLength();
        this.frame = new RntbdResponseStatus(length, status, activityId);
    }

    private RntbdResponse(RntbdResponseStatus frame, RntbdResponseHeaders headers, ByteBuf content) {
        this.frame = frame;
        this.headers = headers;
        this.content = content.retain();
    }

    public UUID getActivityId() {
        return this.frame.getActivityId();
    }

    @JsonIgnore
    public ByteBuf getContent() {
        return this.content;
    }

    @JsonIgnore
    public RntbdResponseHeaders getHeaders() {
        return this.headers;
    }

    public InputStreamReader getResponseStreamReader() {
        ByteBufInputStream istream = new ByteBufInputStream(this.content.retain(), true);
        return new InputStreamReader((InputStream)istream);
    }

    @JsonIgnore
    public HttpResponseStatus getStatus() {
        return this.frame.getStatus();
    }

    static RntbdResponse decode(ByteBuf in) {
        EmptyByteBuf content;
        in.markReaderIndex();
        RntbdResponseStatus frame = RntbdResponseStatus.decode(in);
        RntbdResponseHeaders headers = RntbdResponseHeaders.decode(in.readSlice(frame.getHeadersLength()));
        boolean hasPayload = headers.isPayloadPresent();
        if (hasPayload) {
            if (!RntbdFramer.canDecodePayload(in)) {
                in.resetReaderIndex();
                return null;
            }
            content = in.readSlice(in.readIntLE());
        } else {
            content = new EmptyByteBuf(in.alloc());
        }
        return new RntbdResponse(frame, headers, (ByteBuf)content);
    }

    public void encode(ByteBuf out) {
        int start = out.writerIndex();
        this.frame.encode(out);
        this.headers.encode(out);
        int length = out.writerIndex() - start;
        if (length != this.frame.getLength()) {
            throw new IllegalStateException();
        }
        if (this.hasPayload()) {
            out.writeIntLE(this.content.readableBytes());
            out.writeBytes(this.content);
        } else if (this.content.readableBytes() > 0) {
            throw new IllegalStateException();
        }
    }

    @JsonIgnore
    public <T> T getHeader(RntbdConstants.RntbdResponseHeader header) {
        Object value = this.headers.get(header).getValue();
        return (T)value;
    }

    public boolean hasPayload() {
        return this.headers.isPayloadPresent();
    }

    public int refCnt() {
        return this.referenceCount.get();
    }

    public boolean release() {
        return this.release(1);
    }

    public boolean release(int decrement) {
        return this.referenceCount.getAndAccumulate(decrement, (value, n) -> {
            if ((value -= Math.min(value, n)) == 0) {
                assert (this.headers != null && this.content != null);
                this.headers.releaseBuffers();
                this.content.release();
            }
            return value;
        }) == 0;
    }

    public ReferenceCounted retain() {
        this.referenceCount.incrementAndGet();
        return this;
    }

    public ReferenceCounted retain(int increment) {
        this.referenceCount.addAndGet(increment);
        return this;
    }

    StoreResponse toStoreResponse(RntbdContext context) {
        Objects.requireNonNull(context);
        int length = this.content.readableBytes();
        return new StoreResponse(this.getStatus().code(), this.headers.asList(context, this.getActivityId()), length == 0 ? null : this.content.readCharSequence(length, StandardCharsets.UTF_8).toString());
    }

    public String toString() {
        ObjectWriter writer = RntbdObjectMapper.writer();
        try {
            return writer.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException error) {
            throw new CorruptedFrameException((Throwable)error);
        }
    }

    public ReferenceCounted touch() {
        return this;
    }

    public ReferenceCounted touch(Object hint) {
        return this;
    }

    private static class PayloadSerializer
    extends StdSerializer<ByteBuf> {
        public PayloadSerializer() {
            super(ByteBuf.class, true);
        }

        public void serialize(ByteBuf value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            int length = value.readableBytes();
            generator.writeStartObject();
            generator.writeObjectField("length", (Object)length);
            generator.writeObjectField("content", (Object)ByteBufUtil.hexDump((ByteBuf)value, (int)0, (int)length));
            generator.writeEndObject();
        }
    }
}

