/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.terracotta.management.sequence;

import java.util.concurrent.atomic.AtomicInteger;

class IntCyclicRangeCounter {
    private final AtomicInteger counter;
    private final int min;
    private final int max;

    IntCyclicRangeCounter(int min, int max) {
        this.min = min;
        this.max = max;
        if (min >= max) {
            throw new IllegalArgumentException("min >= maxValue");
        }
        if (min < 0) {
            throw new IllegalArgumentException("min < 0");
        }
        this.counter = new AtomicInteger(min);
    }

    int getAndIncrement() {
        int next;
        int current;
        while (!this.counter.compareAndSet(current, next = (current = this.counter.get()) == this.max ? this.min : current + 1)) {
        }
        return current;
    }
}

