/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.AbfsStatistic;
import org.apache.hadoop.fs.azurebfs.services.AbfsClientThrottlingAnalyzer;
import org.apache.hadoop.fs.azurebfs.services.AbfsCounters;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsThrottlingIntercept;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AbfsClientThrottlingIntercept
implements AbfsThrottlingIntercept {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsClientThrottlingIntercept.class);
    private static final String RANGE_PREFIX = "bytes=";
    private static AbfsClientThrottlingIntercept singleton;
    private static final ReentrantLock LOCK;
    private final AbfsClientThrottlingAnalyzer readThrottler;
    private final AbfsClientThrottlingAnalyzer writeThrottler;
    private final String accountName;

    public AbfsClientThrottlingIntercept(String accountName, AbfsConfiguration abfsConfiguration) {
        this.accountName = accountName;
        this.readThrottler = this.setAnalyzer("read " + accountName, abfsConfiguration);
        this.writeThrottler = this.setAnalyzer("write " + accountName, abfsConfiguration);
        LOG.debug("Client-side throttling is enabled for the ABFS file system for the account : {}", (Object)accountName);
    }

    private AbfsClientThrottlingIntercept(AbfsConfiguration abfsConfiguration) {
        this.accountName = "";
        this.readThrottler = this.setAnalyzer("read", abfsConfiguration);
        this.writeThrottler = this.setAnalyzer("write", abfsConfiguration);
        LOG.debug("Client-side throttling is enabled for the ABFS file system using singleton intercept");
    }

    private AbfsClientThrottlingAnalyzer setAnalyzer(String name, AbfsConfiguration abfsConfiguration) {
        return new AbfsClientThrottlingAnalyzer(name, abfsConfiguration);
    }

    AbfsClientThrottlingAnalyzer getReadThrottler() {
        return this.readThrottler;
    }

    AbfsClientThrottlingAnalyzer getWriteThrottler() {
        return this.writeThrottler;
    }

    static AbfsClientThrottlingIntercept initializeSingleton(AbfsConfiguration abfsConfiguration) {
        if (singleton == null) {
            LOCK.lock();
            try {
                if (singleton == null) {
                    singleton = new AbfsClientThrottlingIntercept(abfsConfiguration);
                    LOG.debug("Client-side throttling is enabled for the ABFS file system.");
                }
            }
            finally {
                LOCK.unlock();
            }
        }
        return singleton;
    }

    private boolean updateBytesTransferred(boolean isThrottledOperation, AbfsHttpOperation abfsHttpOperation) {
        return isThrottledOperation && abfsHttpOperation.getExpectedBytesToBeSent() > 0;
    }

    @Override
    public void updateMetrics(AbfsRestOperationType operationType, AbfsHttpOperation abfsHttpOperation) {
        if (abfsHttpOperation == null) {
            return;
        }
        int status = abfsHttpOperation.getStatusCode();
        long contentLength = 0L;
        boolean isFailedOperation = status < 200 || status >= 500;
        boolean isThrottledOperation = status == 503;
        switch (operationType) {
            case Append: {
                contentLength = abfsHttpOperation.getBytesSent();
                if (contentLength == 0L && this.updateBytesTransferred(isThrottledOperation, abfsHttpOperation)) {
                    LOG.debug("Updating metrics due to throttling for path {}", (Object)abfsHttpOperation.getConnUrl().getPath());
                    contentLength = abfsHttpOperation.getExpectedBytesToBeSent();
                }
                if (contentLength <= 0L) break;
                this.writeThrottler.addBytesTransferred(contentLength, isFailedOperation);
                break;
            }
            case ReadFile: {
                String range = abfsHttpOperation.getRequestProperty("Range");
                contentLength = AbfsClientThrottlingIntercept.getContentLengthIfKnown(range);
                if (contentLength <= 0L) break;
                this.readThrottler.addBytesTransferred(contentLength, isFailedOperation);
                break;
            }
        }
    }

    @Override
    public void sendingRequest(AbfsRestOperationType operationType, AbfsCounters abfsCounters) {
        switch (operationType) {
            case ReadFile: {
                if (!this.readThrottler.suspendIfNecessary() || abfsCounters == null) break;
                abfsCounters.incrementCounter(AbfsStatistic.READ_THROTTLES, 1L);
                break;
            }
            case Append: {
                if (!this.writeThrottler.suspendIfNecessary() || abfsCounters == null) break;
                abfsCounters.incrementCounter(AbfsStatistic.WRITE_THROTTLES, 1L);
                break;
            }
        }
    }

    private static long getContentLengthIfKnown(String range) {
        String[] offsets;
        long contentLength = 0L;
        if (range != null && range.startsWith(RANGE_PREFIX) && (offsets = range.substring(RANGE_PREFIX.length()).split("-")).length == 2) {
            contentLength = Long.parseLong(offsets[1]) - Long.parseLong(offsets[0]) + 1L;
        }
        return contentLength;
    }

    static {
        LOCK = new ReentrantLock();
    }
}

