/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoProtocolVersion;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.NameNodeProxies;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.hadoop.hdfs.protocol.AddErasureCodingPolicyResponse;
import org.apache.hadoop.hdfs.protocol.BlockStoragePolicy;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveEntry;
import org.apache.hadoop.hdfs.protocol.CacheDirectiveInfo;
import org.apache.hadoop.hdfs.protocol.CachePoolEntry;
import org.apache.hadoop.hdfs.protocol.CachePoolInfo;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.DirectoryListing;
import org.apache.hadoop.hdfs.protocol.ECBlockGroupStats;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicy;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyInfo;
import org.apache.hadoop.hdfs.protocol.ErasureCodingPolicyState;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.protocol.HdfsFileStatus;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.hdfs.protocol.ReplicatedBlockStats;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReport;
import org.apache.hadoop.hdfs.protocol.SnapshotDiffReportListing;
import org.apache.hadoop.hdfs.protocol.SnapshotException;
import org.apache.hadoop.hdfs.protocol.SnapshottableDirectoryStatus;
import org.apache.hadoop.hdfs.security.token.block.ExportedBlockKeys;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManagerTestUtil;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.metrics.NamenodeBeanMetrics;
import org.apache.hadoop.hdfs.server.federation.metrics.RBFMetrics;
import org.apache.hadoop.hdfs.server.federation.resolver.FileSubclusterResolver;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcClient;
import org.apache.hadoop.hdfs.server.federation.router.RouterRpcServer;
import org.apache.hadoop.hdfs.server.namenode.FSDirectory;
import org.apache.hadoop.hdfs.server.namenode.FSNamesystem;
import org.apache.hadoop.hdfs.server.namenode.INodeDirectory;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeAdapter;
import org.apache.hadoop.hdfs.server.protocol.BlocksWithLocations;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.NamenodeProtocol;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.io.EnumSetWritable;
import org.apache.hadoop.io.erasurecode.ECSchema;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.thirdparty.com.google.common.collect.Maps;
import org.assertj.core.api.Assertions;
import org.codehaus.jettison.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRouterRpc {
    private static final Logger LOG = LoggerFactory.getLogger(TestRouterRpc.class);
    private static final int NUM_SUBCLUSTERS = 2;
    private static final int NUM_DNS = 6;
    private static final Comparator<ErasureCodingPolicyInfo> EC_POLICY_CMP = new Comparator<ErasureCodingPolicyInfo>(){

        @Override
        public int compare(ErasureCodingPolicyInfo ec0, ErasureCodingPolicyInfo ec1) {
            String name0 = ec0.getPolicy().getName();
            String name1 = ec1.getPolicy().getName();
            return name0.compareTo(name1);
        }
    };
    private static MiniRouterDFSCluster cluster;
    private MiniRouterDFSCluster.RouterContext router;
    private String ns;
    private MiniRouterDFSCluster.NamenodeContext namenode;
    private ClientProtocol routerProtocol;
    private ClientProtocol nnProtocol;
    private NamenodeProtocol routerNamenodeProtocol;
    private NamenodeProtocol nnNamenodeProtocol;
    private NamenodeProtocol nnNamenodeProtocol1;
    private FileSystem routerFS;
    private FileSystem nnFS;
    private String routerFile;
    private String nnFile;

    @BeforeClass
    public static void globalSetUp() throws Exception {
        Configuration namenodeConf = new Configuration();
        namenodeConf.setBoolean("hadoop.caller.context.enabled", true);
        namenodeConf.setBoolean("dfs.namenode.redundancy.considerLoad", false);
        cluster = new MiniRouterDFSCluster(false, 2);
        cluster.setNumDatanodesPerNameservice(6);
        cluster.addNamenodeOverrides(namenodeConf);
        cluster.setIndependentDNs();
        Configuration conf = new Configuration();
        conf.setInt("dfs.ls.limit", 5);
        cluster.addNamenodeOverrides(conf);
        cluster.startCluster();
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().build();
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
    }

    @AfterClass
    public static void tearDown() {
        cluster.shutdown();
    }

    @Before
    public void testSetup() throws Exception {
        cluster.installMockLocations();
        cluster.deleteAllFiles();
        cluster.createTestDirectoriesNamenode();
        Thread.sleep(100L);
        MiniRouterDFSCluster.RouterContext rndRouter = cluster.getRandomRouter();
        this.setRouter(rndRouter);
        String ns0 = cluster.getNameservices().get(0);
        this.setNs(ns0);
        this.setNamenode(cluster.getNamenode(ns0, null));
        Random rnd = new Random();
        String randomFile = "testfile-" + rnd.nextInt();
        this.nnFile = cluster.getNamenodeTestDirectoryForNS(this.ns) + "/" + randomFile;
        this.routerFile = cluster.getFederatedTestDirectoryForNS(this.ns) + "/" + randomFile;
        FederationTestUtils.createFile(this.nnFS, this.nnFile, 32L);
        FederationTestUtils.verifyFileExists(this.nnFS, this.nnFile);
    }

    @Test
    public void testRpcService() throws IOException {
        Router testRouter = new Router();
        List<String> nss = cluster.getNameservices();
        String ns0 = nss.get(0);
        Configuration routerConfig = cluster.generateRouterConfiguration(ns0, null);
        RouterRpcServer server = new RouterRpcServer(routerConfig, testRouter, testRouter.getNamenodeResolver(), testRouter.getSubclusterResolver());
        server.init(routerConfig);
        Assert.assertEquals((Object)Service.STATE.INITED, (Object)server.getServiceState());
        server.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)server.getServiceState());
        server.stop();
        Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)server.getServiceState());
        server.close();
        testRouter.close();
    }

    protected MiniRouterDFSCluster getCluster() {
        return cluster;
    }

    protected MiniRouterDFSCluster.RouterContext getRouterContext() {
        return this.router;
    }

    protected void setRouter(MiniRouterDFSCluster.RouterContext r) throws IOException, URISyntaxException {
        this.router = r;
        this.routerProtocol = r.getClient().getNamenode();
        this.routerFS = r.getFileSystem();
        this.routerNamenodeProtocol = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)this.router.getConf(), (URI)this.router.getFileSystem().getUri(), NamenodeProtocol.class).getProxy();
    }

    protected FileSystem getRouterFileSystem() {
        return this.routerFS;
    }

    protected FileSystem getNamenodeFileSystem() {
        return this.nnFS;
    }

    protected ClientProtocol getRouterProtocol() {
        return this.routerProtocol;
    }

    protected ClientProtocol getNamenodeProtocol() {
        return this.nnProtocol;
    }

    protected MiniRouterDFSCluster.NamenodeContext getNamenode() {
        return this.namenode;
    }

    protected void setNamenodeFile(String filename) {
        this.nnFile = filename;
    }

    protected String getNamenodeFile() {
        return this.nnFile;
    }

    protected void setRouterFile(String filename) {
        this.routerFile = filename;
    }

    protected String getRouterFile() {
        return this.routerFile;
    }

    protected void setNamenode(MiniRouterDFSCluster.NamenodeContext nn) throws IOException, URISyntaxException {
        this.namenode = nn;
        this.nnProtocol = nn.getClient().getNamenode();
        this.nnFS = nn.getFileSystem();
        String ns0 = cluster.getNameservices().get(0);
        MiniRouterDFSCluster.NamenodeContext nn0 = cluster.getNamenode(ns0, null);
        this.nnNamenodeProtocol = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)nn0.getConf(), (URI)nn0.getFileSystem().getUri(), NamenodeProtocol.class).getProxy();
        String ns1 = cluster.getNameservices().get(1);
        MiniRouterDFSCluster.NamenodeContext nn1 = cluster.getNamenode(ns1, null);
        this.nnNamenodeProtocol1 = (NamenodeProtocol)NameNodeProxies.createProxy((Configuration)nn1.getConf(), (URI)nn1.getFileSystem().getUri(), NamenodeProtocol.class).getProxy();
    }

    protected String getNs() {
        return this.ns;
    }

    protected void setNs(String nameservice) {
        this.ns = nameservice;
    }

    protected static void compareResponses(ClientProtocol protocol1, ClientProtocol protocol2, Method m, Object[] paramList) {
        Object return1 = null;
        Exception exception1 = null;
        try {
            return1 = m.invoke((Object)protocol1, paramList);
        }
        catch (Exception ex) {
            exception1 = ex;
        }
        Object return2 = null;
        Exception exception2 = null;
        try {
            return2 = m.invoke((Object)protocol2, paramList);
        }
        catch (Exception ex) {
            exception2 = ex;
        }
        Assert.assertEquals((Object)return1, (Object)return2);
        if (exception1 == null && exception2 == null) {
            return;
        }
        Assert.assertEquals(exception1.getCause().getClass(), exception2.getCause().getClass());
    }

    @Test
    public void testProxyListFiles() throws IOException, InterruptedException, URISyntaxException, NoSuchMethodException, SecurityException {
        FileStatus[] iterator;
        TreeSet<String> requiredPaths = new TreeSet<String>();
        FileSubclusterResolver fileResolver = this.router.getRouter().getSubclusterResolver();
        for (String mount : fileResolver.getMountPoints("/")) {
            requiredPaths.add(mount);
        }
        String defaultNs = cluster.getNameservices().get(0);
        MiniRouterDFSCluster.NamenodeContext nn = cluster.getNamenode(defaultNs, null);
        for (FileStatus file : iterator = nn.getFileSystem().listStatus(new Path("/"))) {
            requiredPaths.add(file.getPath().getName());
        }
        DirectoryListing listing = this.routerProtocol.getListing("/", HdfsFileStatus.EMPTY_NAME, false);
        Iterator requiredPathsIterator = requiredPaths.iterator();
        for (HdfsFileStatus f : listing.getPartialListing()) {
            String fileName = (String)requiredPathsIterator.next();
            String currentFile = f.getFullPath(new Path("/")).getName();
            Assert.assertEquals((Object)currentFile, (Object)fileName);
        }
        Assert.assertEquals((long)requiredPaths.size(), (long)listing.getPartialListing().length);
        Method m = ClientProtocol.class.getMethod("getListing", String.class, byte[].class, Boolean.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, HdfsFileStatus.EMPTY_NAME, false});
    }

    @Test
    public void testProxyListFilesLargeDir() throws IOException {
        int i;
        for (MiniRouterDFSCluster.RouterContext rc : cluster.getRouters()) {
            MockResolver resolver = (MockResolver)rc.getRouter().getSubclusterResolver();
            resolver.addLocation("/parent", this.ns, "/parent");
            resolver.addLocation("/parent/file-0", this.ns, "/parent/file-0");
            resolver.addLocation("/parent/file-7", this.ns, "/parent/file-7");
        }
        FileStatus[] result = this.routerFS.listStatus(new Path("/parent"));
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertEquals((Object)"file-0", (Object)result[0].getPath().getName());
        Assert.assertEquals((Object)"file-7", (Object)result[1].getPath().getName());
        MiniRouterDFSCluster.NamenodeContext nn = cluster.getNamenode(this.ns, null);
        FileSystem nnFileSystem = nn.getFileSystem();
        for (i = 1; i < 9; ++i) {
            FederationTestUtils.createFile(nnFileSystem, "/parent/file-" + i, 32L);
        }
        result = this.routerFS.listStatus(new Path("/parent"));
        Assert.assertEquals((long)9L, (long)result.length);
        for (i = 0; i < 9; ++i) {
            Assert.assertEquals((Object)("file-" + i), (Object)result[i].getPath().getName());
        }
        for (MiniRouterDFSCluster.RouterContext rc : cluster.getRouters()) {
            MockResolver resolver = (MockResolver)rc.getRouter().getSubclusterResolver();
            resolver.addLocation("/parent/file-9", this.ns, "/parent/file-9");
        }
        Assert.assertFalse((boolean)FederationTestUtils.verifyFileExists(nnFileSystem, "/parent/file-9"));
        result = this.routerFS.listStatus(new Path("/parent"));
        Assert.assertEquals((long)10L, (long)result.length);
        for (int i2 = 0; i2 < 10; ++i2) {
            Assert.assertEquals((Object)("file-" + i2), (Object)result[i2].getPath().getName());
        }
    }

    @Test
    public void testProxyListFilesWithConflict() throws IOException, InterruptedException {
        MiniRouterDFSCluster.NamenodeContext nn = cluster.getNamenode(this.ns, null);
        FileSystem nnFs = nn.getFileSystem();
        FederationTestUtils.addDirectory(nnFs, cluster.getFederatedTestDirectoryForNS(this.ns));
        FileSystem routerFs = this.router.getFileSystem();
        int initialCount = FederationTestUtils.countContents(routerFs, "/");
        int newCount = FederationTestUtils.countContents(routerFs, "/");
        Assert.assertEquals((long)initialCount, (long)newCount);
        Assert.assertEquals((long)1L, (long)FederationTestUtils.countContents(routerFs, cluster.getFederatedPathForNS(this.ns)));
        Assert.assertEquals((long)1L, (long)FederationTestUtils.countContents(nnFs, cluster.getNamenodePathForNS(this.ns)));
    }

    protected void testRename(MiniRouterDFSCluster.RouterContext testRouter, String filename, String renamedFile, boolean exceptionExpected) throws IOException {
        FileContext fileContext;
        FederationTestUtils.createFile(testRouter.getFileSystem(), filename, 32L);
        FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), filename);
        boolean exceptionThrown = false;
        try {
            DFSClient client = testRouter.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename(filename, renamedFile);
        }
        catch (Exception ex) {
            exceptionThrown = true;
        }
        if (exceptionExpected) {
            Assert.assertTrue((boolean)exceptionThrown);
            fileContext = testRouter.getFileContext();
            Assert.assertTrue((boolean)fileContext.delete(new Path(filename), true));
        } else {
            Assert.assertFalse((boolean)exceptionThrown);
            Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedFile));
            fileContext = testRouter.getFileContext();
            Assert.assertTrue((boolean)fileContext.delete(new Path(renamedFile), true));
        }
    }

    protected void testRename2(MiniRouterDFSCluster.RouterContext testRouter, String filename, String renamedFile, boolean exceptionExpected) throws IOException {
        FileContext fileContext;
        FederationTestUtils.createFile(testRouter.getFileSystem(), filename, 32L);
        FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), filename);
        boolean exceptionThrown = false;
        try {
            DFSClient client = testRouter.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            clientProtocol.rename2(filename, renamedFile, new Options.Rename[0]);
        }
        catch (Exception ex) {
            exceptionThrown = true;
        }
        Assert.assertEquals((Object)exceptionExpected, (Object)exceptionThrown);
        if (exceptionExpected) {
            fileContext = testRouter.getFileContext();
            Assert.assertTrue((boolean)fileContext.delete(new Path(filename), true));
        } else {
            Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(testRouter.getFileSystem(), renamedFile));
            fileContext = testRouter.getFileContext();
            Assert.assertTrue((boolean)fileContext.delete(new Path(renamedFile), true));
        }
    }

    @Test
    public void testProxyRenameFiles() throws IOException, InterruptedException {
        Thread.sleep(5000L);
        List<String> nss = cluster.getNameservices();
        String ns0 = nss.get(0);
        String ns1 = nss.get(1);
        String filename = cluster.getFederatedTestDirectoryForNS(ns0) + "/testrename";
        String renamedFile = filename + "-append";
        this.testRename(this.router, filename, renamedFile, false);
        this.testRename2(this.router, filename, renamedFile, false);
        filename = cluster.getFederatedTestDirectoryForNS(ns0) + "/testrename";
        renamedFile = cluster.getFederatedTestDirectoryForNS(ns1) + "/testrename";
        this.testRename(this.router, filename, renamedFile, true);
        this.testRename2(this.router, filename, renamedFile, true);
    }

    @Test
    public void testProxyChownFiles() throws Exception {
        String newUsername = "TestUser";
        String newGroup = "TestGroup";
        this.routerProtocol.setOwner(this.routerFile, newUsername, newGroup);
        FileStatus file = FederationTestUtils.getFileStatus(this.namenode.getFileSystem(), this.nnFile);
        Assert.assertEquals((Object)file.getOwner(), (Object)newUsername);
        Assert.assertEquals((Object)file.getGroup(), (Object)newGroup);
        Method m = ClientProtocol.class.getMethod("setOwner", String.class, String.class, String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, newUsername, newGroup});
    }

    @Test
    public void testProxyGetStats() throws Exception {
        Supplier<Boolean> check = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                try {
                    long[] combinedData = TestRouterRpc.this.routerProtocol.getStats();
                    long[] individualData = TestRouterRpc.this.getAggregateStats();
                    int len = Math.min(combinedData.length, individualData.length);
                    for (int i = 0; i < len; ++i) {
                        if (combinedData[i] == individualData[i]) continue;
                        LOG.error("Stats for {} don't match: {} != {}", new Object[]{i, combinedData[i], individualData[i]});
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    LOG.error("Cannot get stats: {}", (Object)e.getMessage());
                    return false;
                }
            }
        };
        GenericTestUtils.waitFor((Supplier)check, (long)500L, (long)5000L);
    }

    private long[] getAggregateStats() throws Exception {
        long[] individualData = new long[10];
        for (String nameservice : cluster.getNameservices()) {
            MiniRouterDFSCluster.NamenodeContext n = cluster.getNamenode(nameservice, null);
            DFSClient client = n.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            long[] data = clientProtocol.getStats();
            for (int i = 0; i < data.length; ++i) {
                int n2 = i;
                individualData[n2] = individualData[n2] + data[i];
            }
        }
        return individualData;
    }

    @Test
    public void testProxyGetDatanodeReport() throws Exception {
        DatanodeInfo[] combinedData = this.routerProtocol.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
        Assert.assertEquals((long)0L, (long)this.routerProtocol.getSlowDatanodeReport().length);
        TreeMap<Integer, String> routerDNMap = new TreeMap<Integer, String>();
        for (DatanodeInfo dn : combinedData) {
            String subcluster = dn.getNetworkLocation().split("/")[1];
            routerDNMap.put(dn.getXferPort(), subcluster);
        }
        TreeMap<Integer, String> nnDNMap = new TreeMap<Integer, String>();
        for (String nameservice : cluster.getNameservices()) {
            MiniRouterDFSCluster.NamenodeContext n = cluster.getNamenode(nameservice, null);
            DFSClient client = n.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            DatanodeInfo[] data = clientProtocol.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
            for (int i = 0; i < data.length; ++i) {
                DatanodeInfo info = data[i];
                nnDNMap.put(info.getXferPort(), nameservice);
            }
        }
        Assert.assertEquals(nnDNMap, routerDNMap);
    }

    @Test
    public void testProxyGetDatanodeStorageReport() throws IOException, InterruptedException, URISyntaxException {
        DatanodeStorageReport[] combinedData = this.routerProtocol.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL);
        HashSet<String> individualData = new HashSet<String>();
        for (String nameservice : cluster.getNameservices()) {
            DatanodeStorageReport[] data;
            MiniRouterDFSCluster.NamenodeContext n = cluster.getNamenode(nameservice, null);
            DFSClient client = n.getClient();
            ClientProtocol clientProtocol = client.getNamenode();
            for (DatanodeStorageReport report : data = clientProtocol.getDatanodeStorageReport(HdfsConstants.DatanodeReportType.ALL)) {
                DatanodeInfo dn = report.getDatanodeInfo();
                individualData.add(dn.toString());
            }
        }
        Assert.assertEquals((long)combinedData.length, (long)individualData.size());
    }

    @Test
    public void testProxyMkdir() throws Exception {
        Object[] filesInitial = this.routerFS.listStatus(new Path("/"));
        String dirPath = "/testdir";
        FsPermission permission = new FsPermission("705");
        this.routerProtocol.mkdirs(dirPath, permission, false);
        Object[] files = this.routerFS.listStatus(new Path("/"));
        Assert.assertEquals((String)(Arrays.toString(files) + " should be " + Arrays.toString(filesInitial) + " + " + dirPath), (long)(filesInitial.length + 1), (long)files.length);
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
        int foundCount = 0;
        for (MiniRouterDFSCluster.NamenodeContext n : cluster.getNamenodes()) {
            if (!FederationTestUtils.verifyFileExists(n.getFileSystem(), dirPath)) continue;
            ++foundCount;
        }
        Assert.assertEquals((long)1L, (long)foundCount);
        Assert.assertTrue((boolean)FederationTestUtils.deleteFile(this.routerFS, dirPath));
        Method m = ClientProtocol.class.getMethod("mkdirs", String.class, FsPermission.class, Boolean.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, permission, false});
    }

    @Test
    public void testProxyChmodFiles() throws Exception {
        FsPermission permission = new FsPermission("444");
        this.routerProtocol.setPermission(this.routerFile, permission);
        FileStatus file = FederationTestUtils.getFileStatus(this.namenode.getFileSystem(), this.nnFile);
        Assert.assertEquals((Object)permission, (Object)file.getPermission());
        Method m = ClientProtocol.class.getMethod("setPermission", String.class, FsPermission.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, permission});
    }

    @Test
    public void testProxySetReplication() throws Exception {
        FileStatus file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertEquals((long)1L, (long)file.getReplication());
        this.routerProtocol.setReplication(this.routerFile, (short)2);
        file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertEquals((long)2L, (long)file.getReplication());
        Method m = ClientProtocol.class.getMethod("setReplication", String.class, Short.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, (short)2});
    }

    @Test
    public void testProxyTruncateFile() throws Exception {
        FileStatus file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertTrue((file.getLen() > 0L ? 1 : 0) != 0);
        this.routerProtocol.truncate(this.routerFile, 0L, "testclient");
        file = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertEquals((long)0L, (long)file.getLen());
        Method m = ClientProtocol.class.getMethod("truncate", String.class, Long.TYPE, String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, 0L, "testclient"});
    }

    @Test
    public void testAllowDisallowSnapshots() throws Exception {
        String dirPath = "/testdir";
        String filePath1 = "/sample";
        FsPermission permission = new FsPermission("705");
        this.routerProtocol.mkdirs(dirPath, permission, false);
        FederationTestUtils.createFile(this.routerFS, filePath1, 32L);
        MiniRouterDFSCluster.NamenodeContext nnContext = cluster.getNamenodes().get(0);
        NameNode nn = nnContext.getNamenode();
        FSNamesystem fsn = NameNodeAdapter.getNamesystem((NameNode)nn);
        FSDirectory fsdir = fsn.getFSDirectory();
        INodeDirectory dirNode = fsdir.getINode4Write(dirPath).asDirectory();
        Assert.assertFalse((boolean)dirNode.isSnapshottable());
        this.routerProtocol.allowSnapshot("/testdir");
        dirNode = fsdir.getINode4Write(dirPath).asDirectory();
        Assert.assertTrue((boolean)dirNode.isSnapshottable());
        this.routerProtocol.disallowSnapshot("/testdir");
        dirNode = fsdir.getINode4Write(dirPath).asDirectory();
        Assert.assertFalse((boolean)dirNode.isSnapshottable());
        this.routerProtocol.delete(dirPath, true);
    }

    @Test
    public void testManageSnapshot() throws Exception {
        String mountPoint = "/mntsnapshot";
        String snapshotFolder = "/mntsnapshot/folder";
        LOG.info("Setup a mount point for snapshots: {}", (Object)"/mntsnapshot");
        Router r = this.router.getRouter();
        MockResolver resolver = (MockResolver)r.getSubclusterResolver();
        String ns0 = cluster.getNameservices().get(0);
        resolver.addLocation("/mntsnapshot", ns0, "/");
        FsPermission permission = new FsPermission("777");
        this.routerProtocol.mkdirs("/mntsnapshot", permission, false);
        this.routerProtocol.mkdirs("/mntsnapshot/folder", permission, false);
        for (int i = 1; i <= 9; ++i) {
            String folderPath = "/mntsnapshot/folder/subfolder" + i;
            this.routerProtocol.mkdirs(folderPath, permission, false);
        }
        LOG.info("Create the snapshot: {}", (Object)"/mntsnapshot/folder");
        this.routerProtocol.allowSnapshot("/mntsnapshot/folder");
        String snapshotName = this.routerProtocol.createSnapshot("/mntsnapshot/folder", "snap");
        Assert.assertEquals((Object)"/mntsnapshot/folder/.snapshot/snap", (Object)snapshotName);
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, "/mntsnapshot/folder/.snapshot/snap"));
        LOG.info("Rename the snapshot and check it changed");
        this.routerProtocol.renameSnapshot("/mntsnapshot/folder", "snap", "newsnap");
        Assert.assertFalse((boolean)FederationTestUtils.verifyFileExists(this.routerFS, "/mntsnapshot/folder/.snapshot/snap"));
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, "/mntsnapshot/folder/.snapshot/newsnap"));
        LambdaTestUtils.intercept(SnapshotException.class, (String)"Cannot delete snapshot snap from path /mntsnapshot/folder:", () -> this.routerFS.deleteSnapshot(new Path("/mntsnapshot/folder"), "snap"));
        LOG.info("Delete the snapshot and check it is not there");
        this.routerProtocol.deleteSnapshot("/mntsnapshot/folder", "newsnap");
        Assert.assertFalse((boolean)FederationTestUtils.verifyFileExists(this.routerFS, "/mntsnapshot/folder/.snapshot/newsnap"));
        this.routerProtocol.delete("/mntsnapshot", true);
    }

    @Test
    public void testGetSnapshotListing() throws IOException {
        String snapshotPath = "/testGetSnapshotListing";
        String childDir = "/testGetSnapshotListing/subdir";
        FsPermission permission = new FsPermission("705");
        this.routerProtocol.mkdirs("/testGetSnapshotListing", permission, false);
        this.routerProtocol.allowSnapshot("/testGetSnapshotListing");
        String snapshot1 = "snap1";
        String snapshot2 = "snap2";
        this.routerProtocol.createSnapshot("/testGetSnapshotListing", "snap1");
        this.routerProtocol.mkdirs("/testGetSnapshotListing/subdir", permission, false);
        this.routerProtocol.createSnapshot("/testGetSnapshotListing", "snap2");
        SnapshottableDirectoryStatus[] dirList = this.routerProtocol.getSnapshottableDirListing();
        Assert.assertEquals((long)1L, (long)dirList.length);
        SnapshottableDirectoryStatus snapshotDir0 = dirList[0];
        Assert.assertEquals((Object)"/testGetSnapshotListing", (Object)snapshotDir0.getFullPath().toString());
        SnapshotDiffReport diffReport = this.routerProtocol.getSnapshotDiffReport("/testGetSnapshotListing", "snap1", "snap2");
        Assert.assertEquals((long)2L, (long)diffReport.getDiffList().size());
        byte[] startPath = new byte[]{};
        SnapshotDiffReportListing diffReportListing = this.routerProtocol.getSnapshotDiffReportListing("/testGetSnapshotListing", "snap1", "snap2", startPath, -1);
        Assert.assertEquals((long)1L, (long)diffReportListing.getModifyList().size());
        Assert.assertEquals((long)1L, (long)diffReportListing.getCreateList().size());
        this.routerProtocol.deleteSnapshot("/testGetSnapshotListing", "snap1");
        this.routerProtocol.deleteSnapshot("/testGetSnapshotListing", "snap2");
        this.routerProtocol.disallowSnapshot("/testGetSnapshotListing");
    }

    @Test
    public void testProxyGetBlockLocations() throws Exception {
        LocatedBlocks locations = this.routerProtocol.getBlockLocations(this.routerFile, 0L, 1024L);
        Assert.assertEquals((long)1L, (long)locations.getLocatedBlocks().size());
        Method m = ClientProtocol.class.getMethod("getBlockLocations", String.class, Long.TYPE, Long.TYPE);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, 0L, 0L});
    }

    @Test
    public void testProxyStoragePolicy() throws Exception {
        HdfsFileStatus status = this.namenode.getClient().getFileInfo(this.nnFile);
        BlockStoragePolicy[] policies = this.namenode.getClient().getStoragePolicies();
        BlockStoragePolicy policy = policies[0];
        while (policy.isCopyOnCreateFile()) {
            Random rand = new Random();
            int randIndex = rand.nextInt(policies.length);
            policy = policies[randIndex];
        }
        this.routerProtocol.setStoragePolicy(this.routerFile, policy.getName());
        HdfsFileStatus newStatus = this.namenode.getClient().getFileInfo(this.nnFile);
        Assert.assertTrue((newStatus.getStoragePolicy() == policy.getId() ? 1 : 0) != 0);
        Assert.assertTrue((newStatus.getStoragePolicy() != status.getStoragePolicy() ? 1 : 0) != 0);
        Method m = ClientProtocol.class.getMethod("setStoragePolicy", String.class, String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, "badpolicy"});
    }

    @Test
    public void testProxyGetAndUnsetStoragePolicy() throws Exception {
        String file = "/testGetStoragePolicy";
        String nnFilePath = cluster.getNamenodeTestDirectoryForNS(this.ns) + file;
        String routerFilePath = cluster.getFederatedTestDirectoryForNS(this.ns) + file;
        FederationTestUtils.createFile(this.routerFS, routerFilePath, 32L);
        BlockStoragePolicy policy = this.routerProtocol.getStoragePolicy(routerFilePath);
        Assert.assertEquals((Object)"HOT", (Object)policy.getName());
        Assert.assertEquals((long)7L, (long)policy.getId());
        Object[] policies = this.routerProtocol.getStoragePolicies();
        Object[] nnPolicies = this.namenode.getClient().getStoragePolicies();
        Assert.assertArrayEquals((Object[])nnPolicies, (Object[])policies);
        Object newPolicy = policies[0];
        while (newPolicy.isCopyOnCreateFile()) {
            Random rand = new Random();
            int randIndex = rand.nextInt(policies.length);
            newPolicy = policies[randIndex];
        }
        this.routerProtocol.setStoragePolicy(routerFilePath, newPolicy.getName());
        policy = this.routerProtocol.getStoragePolicy(routerFilePath);
        Assert.assertEquals((Object)newPolicy.getName(), (Object)policy.getName());
        Assert.assertEquals((long)newPolicy.getId(), (long)policy.getId());
        BlockStoragePolicy nnPolicy = this.namenode.getClient().getStoragePolicy(nnFilePath);
        Assert.assertEquals((Object)nnPolicy.getName(), (Object)policy.getName());
        Assert.assertEquals((long)nnPolicy.getId(), (long)policy.getId());
        this.routerProtocol.unsetStoragePolicy(routerFilePath);
        policy = this.routerProtocol.getStoragePolicy(routerFilePath);
        Assert.assertEquals((Object)"HOT", (Object)policy.getName());
        Assert.assertEquals((long)7L, (long)policy.getId());
        nnPolicy = this.namenode.getClient().getStoragePolicy(nnFilePath);
        Assert.assertEquals((Object)nnPolicy.getName(), (Object)policy.getName());
        Assert.assertEquals((long)nnPolicy.getId(), (long)policy.getId());
    }

    @Test
    public void testListStoragePolicies() throws IOException, URISyntaxException {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            Object[] policies = this.namenode.getClient().getStoragePolicies();
            Assert.assertArrayEquals((Object[])policies, (Object[])this.routerProtocol.getStoragePolicies());
            resolver.setDisableNamespace(true);
            Assert.assertArrayEquals((Object[])policies, (Object[])this.routerProtocol.getStoragePolicies());
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    @Test
    public void testGetServerDefaults() throws IOException, URISyntaxException {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            FsServerDefaults defaults = this.namenode.getClient().getServerDefaults();
            Assert.assertEquals((long)defaults.getBlockSize(), (long)this.routerProtocol.getServerDefaults().getBlockSize());
            resolver.setDisableNamespace(true);
            Assert.assertEquals((long)defaults.getBlockSize(), (long)this.routerProtocol.getServerDefaults().getBlockSize());
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    @Test
    public void testProxyGetPreferedBlockSize() throws Exception {
        long namenodeSize = this.nnProtocol.getPreferredBlockSize(this.nnFile);
        long routerSize = this.routerProtocol.getPreferredBlockSize(this.routerFile);
        Assert.assertEquals((long)routerSize, (long)namenodeSize);
        Method m = ClientProtocol.class.getMethod("getPreferredBlockSize", String.class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath});
    }

    private void testConcat(String source, String target, boolean failureExpected) {
        boolean failure = false;
        try {
            this.routerProtocol.concat(target, new String[]{source});
        }
        catch (IOException ex) {
            failure = true;
        }
        Assert.assertEquals((Object)failureExpected, (Object)failure);
    }

    @Test
    public void testProxyConcatFile() throws Exception {
        String sameNameservice = this.ns;
        String existingFile = cluster.getFederatedTestDirectoryForNS(sameNameservice) + "_concatfile";
        int existingFileSize = 32;
        FederationTestUtils.createFile(this.routerFS, existingFile, existingFileSize);
        String alternateNameservice = null;
        for (String n : cluster.getNameservices()) {
            if (n.equals(sameNameservice)) continue;
            alternateNameservice = n;
            break;
        }
        String altRouterFile = cluster.getFederatedTestDirectoryForNS(alternateNameservice) + "_newfile";
        String sameRouterFile = cluster.getFederatedTestDirectoryForNS(sameNameservice) + "_newfile";
        FederationTestUtils.createFile(this.routerFS, altRouterFile, 0x8000000L);
        FederationTestUtils.createFile(this.routerFS, sameRouterFile, 0x8000000L);
        this.testConcat(existingFile, altRouterFile, true);
        this.testConcat(existingFile, sameRouterFile, false);
        FileStatus status = FederationTestUtils.getFileStatus(this.routerFS, sameRouterFile);
        Assert.assertEquals((long)((long)existingFileSize + 0x8000000L), (long)status.getLen());
        Method m = ClientProtocol.class.getMethod("concat", String.class, String[].class);
        String badPath = "/unknownlocation/unknowndir";
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, new String[]{this.routerFile}});
    }

    @Test
    public void testProxyAppend() throws Exception {
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.APPEND);
        DFSClient routerClient = this.getRouterContext().getClient();
        HdfsDataOutputStream stream = routerClient.append(this.routerFile, 1024, createFlag, null, null);
        stream.writeBytes("teststring");
        stream.close();
        FileStatus status = FederationTestUtils.getFileStatus(this.nnFS, this.nnFile);
        Assert.assertTrue((status.getLen() > (long)"teststring".length() ? 1 : 0) != 0);
        Method m = ClientProtocol.class.getMethod("append", String.class, String.class, EnumSetWritable.class);
        String badPath = "/unknownlocation/unknowndir";
        EnumSetWritable createFlagWritable = new EnumSetWritable(createFlag);
        TestRouterRpc.compareResponses(this.routerProtocol, this.nnProtocol, m, new Object[]{badPath, "testClient", createFlagWritable});
    }

    @Test
    public void testProxyGetAdditionalDatanode() throws IOException, InterruptedException, URISyntaxException {
        EnumSet<CreateFlag> createFlag = EnumSet.of(CreateFlag.CREATE);
        String clientName = this.getRouterContext().getClient().getClientName();
        String newRouterFile = this.routerFile + "_additionalDatanode";
        HdfsFileStatus status = this.routerProtocol.create(newRouterFile, new FsPermission("777"), clientName, new EnumSetWritable(createFlag), true, (short)1, 1024L, CryptoProtocolVersion.supported(), null, null);
        LocatedBlock block = this.routerProtocol.addBlock(newRouterFile, clientName, null, null, status.getFileId(), null, null);
        DatanodeInfo[] exclusions = DatanodeInfo.EMPTY_ARRAY;
        LocatedBlock newBlock = this.routerProtocol.getAdditionalDatanode(newRouterFile, status.getFileId(), block.getBlock(), (DatanodeInfo[])block.getLocations(), block.getStorageIDs(), exclusions, 1, clientName);
        Assert.assertNotNull((Object)newBlock);
    }

    @Test
    public void testProxyCreateFileAlternateUser() throws IOException, URISyntaxException, InterruptedException {
        String routerDir = cluster.getFederatedTestDirectoryForNS(this.ns);
        String namenodeDir = cluster.getNamenodeTestDirectoryForNS(this.ns);
        String newRouterFile = routerDir + "/unknownuser";
        String newNamenodeFile = namenodeDir + "/unknownuser";
        String username = "unknownuser";
        this.namenode.getFileContext().setPermission(new Path(namenodeDir), new FsPermission("777"));
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)username);
        DFSClient client = this.getRouterContext().getClient(ugi);
        client.create(newRouterFile, true);
        FileStatus status = FederationTestUtils.getFileStatus(this.nnFS, newNamenodeFile);
        Assert.assertEquals((Object)status.getOwner(), (Object)username);
    }

    @Test
    public void testProxyGetFileInfoAcessException() throws IOException {
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)"unknownuser");
        Exception nnFailure = null;
        try {
            String testFile = cluster.getNamenodeTestFileForNS(this.ns);
            this.namenode.getClient(ugi).getLocatedBlocks(testFile, 0L);
        }
        catch (Exception e) {
            nnFailure = e;
        }
        Assert.assertNotNull((Object)nnFailure);
        Exception routerFailure = null;
        try {
            String testFile = cluster.getFederatedTestFileForNS(this.ns);
            this.getRouterContext().getClient(ugi).getLocatedBlocks(testFile, 0L);
        }
        catch (Exception e) {
            routerFailure = e;
        }
        Assert.assertNotNull((Object)routerFailure);
        Assert.assertEquals(routerFailure.getClass(), nnFailure.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyVersionRequest() throws Exception {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            NamespaceInfo rVersion = this.routerNamenodeProtocol.versionRequest();
            NamespaceInfo nnVersion = this.nnNamenodeProtocol.versionRequest();
            NamespaceInfo nnVersion1 = this.nnNamenodeProtocol1.versionRequest();
            this.compareVersion(rVersion, nnVersion);
            resolver.setDisableNamespace(true);
            boolean isNN0 = rVersion.getBlockPoolID().equals(nnVersion.getBlockPoolID());
            this.compareVersion(rVersion, isNN0 ? nnVersion : nnVersion1);
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    private void compareVersion(NamespaceInfo rVersion, NamespaceInfo nnVersion) {
        Assert.assertEquals((Object)nnVersion.getBlockPoolID(), (Object)rVersion.getBlockPoolID());
        Assert.assertEquals((long)nnVersion.getNamespaceID(), (long)rVersion.getNamespaceID());
        Assert.assertEquals((Object)nnVersion.getClusterID(), (Object)rVersion.getClusterID());
        Assert.assertEquals((long)nnVersion.getLayoutVersion(), (long)rVersion.getLayoutVersion());
        Assert.assertEquals((long)nnVersion.getCTime(), (long)rVersion.getCTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyGetBlockKeys() throws Exception {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            ExportedBlockKeys rKeys = this.routerNamenodeProtocol.getBlockKeys();
            ExportedBlockKeys nnKeys = this.nnNamenodeProtocol.getBlockKeys();
            this.compareBlockKeys(rKeys, nnKeys);
            resolver.setDisableNamespace(true);
            rKeys = this.routerNamenodeProtocol.getBlockKeys();
            this.compareBlockKeys(rKeys, nnKeys);
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    private void compareBlockKeys(ExportedBlockKeys rKeys, ExportedBlockKeys nnKeys) {
        Assert.assertEquals((Object)nnKeys.getCurrentKey(), (Object)rKeys.getCurrentKey());
        Assert.assertEquals((long)nnKeys.getKeyUpdateInterval(), (long)rKeys.getKeyUpdateInterval());
        Assert.assertEquals((long)nnKeys.getTokenLifetime(), (long)rKeys.getTokenLifetime());
    }

    @Test
    public void testProxyGetBlocks() throws Exception {
        DatanodeInfo[] dns = this.routerProtocol.getDatanodeReport(HdfsConstants.DatanodeReportType.ALL);
        DatanodeInfo dn0 = dns[0];
        BlocksWithLocations routerBlockLocations = this.routerNamenodeProtocol.getBlocks(dn0, 1024L, 0L);
        BlocksWithLocations nnBlockLocations = this.nnNamenodeProtocol.getBlocks(dn0, 1024L, 0L);
        BlocksWithLocations.BlockWithLocations[] routerBlocks = routerBlockLocations.getBlocks();
        BlocksWithLocations.BlockWithLocations[] nnBlocks = nnBlockLocations.getBlocks();
        Assert.assertEquals((long)nnBlocks.length, (long)routerBlocks.length);
        for (int i = 0; i < routerBlocks.length; ++i) {
            Assert.assertEquals((long)nnBlocks[i].getBlock().getBlockId(), (long)routerBlocks[i].getBlock().getBlockId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyGetTransactionID() throws IOException {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            long routerTransactionID = this.routerNamenodeProtocol.getTransactionID();
            long nnTransactionID = this.nnNamenodeProtocol.getTransactionID();
            long nnTransactionID1 = this.nnNamenodeProtocol1.getTransactionID();
            Assert.assertEquals((long)nnTransactionID, (long)routerTransactionID);
            resolver.setDisableNamespace(true);
            routerTransactionID = this.routerNamenodeProtocol.getTransactionID();
            Assertions.assertThat((long)routerTransactionID).isIn(new Object[]{nnTransactionID, nnTransactionID1});
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProxyGetMostRecentCheckpointTxId() throws IOException {
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        try {
            long routerCheckPointId = this.routerNamenodeProtocol.getMostRecentCheckpointTxId();
            long nnCheckPointId = this.nnNamenodeProtocol.getMostRecentCheckpointTxId();
            Assert.assertEquals((long)nnCheckPointId, (long)routerCheckPointId);
            resolver.setDisableNamespace(true);
            long l = this.routerNamenodeProtocol.getMostRecentCheckpointTxId();
        }
        finally {
            resolver.setDisableNamespace(false);
        }
    }

    @Test
    public void testProxySetSafemode() throws Exception {
        boolean routerSafemode = this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false);
        boolean nnSafemode = this.nnProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false);
        Assert.assertEquals((Object)nnSafemode, (Object)routerSafemode);
        routerSafemode = this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
        nnSafemode = this.nnProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, true);
        Assert.assertEquals((Object)nnSafemode, (Object)routerSafemode);
        Assert.assertFalse((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false));
        Assert.assertTrue((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false));
        Assert.assertTrue((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false));
        Assert.assertFalse((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false));
        Assert.assertFalse((boolean)this.routerProtocol.setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_GET, false));
    }

    @Test
    public void testProxyRestoreFailedStorage() throws Exception {
        boolean routerSuccess = this.routerProtocol.restoreFailedStorage("check");
        boolean nnSuccess = this.nnProtocol.restoreFailedStorage("check");
        Assert.assertEquals((Object)nnSuccess, (Object)routerSuccess);
    }

    @Test
    public void testProxyExceptionMessages() throws IOException {
        FsPermission permission;
        MockResolver resolver = (MockResolver)this.router.getRouter().getSubclusterResolver();
        String ns0 = cluster.getNameservices().get(0);
        resolver.addLocation("/mnt", ns0, "/");
        try {
            permission = new FsPermission("777");
            this.routerProtocol.mkdirs("/mnt/folder0/folder1", permission, false);
            Assert.fail((String)"mkdirs for non-existing parent folder should have failed");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"/mnt/folder0", (Throwable)ioe, (String)"Wrong path in exception for mkdirs");
        }
        try {
            permission = new FsPermission("777");
            this.routerProtocol.setPermission("/mnt/testfile.txt", permission);
            Assert.fail((String)"setPermission for non-existing file should have failed");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"/mnt/testfile.txt", (Throwable)ioe, (String)"Wrong path in exception for setPermission");
        }
        try {
            permission = new FsPermission("777");
            this.routerProtocol.mkdirs("/mnt/folder0/folder1", permission, false);
            this.routerProtocol.delete("/mnt/folder0", false);
            Assert.fail((String)"delete for non-existing file should have failed");
        }
        catch (IOException ioe) {
            GenericTestUtils.assertExceptionContains((String)"/mnt/folder0", (Throwable)ioe, (String)"Wrong path in exception for delete");
        }
        resolver.cleanRegistrations();
        Assert.assertEquals((Object)"Parent directory doesn't exist: /ns1/a/a/b", (Object)RouterRpcClient.processExceptionMsg((String)"Parent directory doesn't exist: /a/a/b", (String)"/a", (String)"/ns1/a"));
    }

    @Test
    public void testGetReplicatedBlockStats() throws Exception {
        String testFile = "/test-file";
        for (String nsid : cluster.getNameservices()) {
            MiniRouterDFSCluster.NamenodeContext context = cluster.getNamenode(nsid, null);
            NameNode nameNode = context.getNamenode();
            FSNamesystem namesystem = nameNode.getNamesystem();
            BlockManager bm = namesystem.getBlockManager();
            FileSystem fileSystem = context.getFileSystem();
            FederationTestUtils.createFile(fileSystem, testFile, 1024L);
            LocatedBlock block = NameNodeAdapter.getBlockLocations((NameNode)nameNode, (String)testFile, (long)0L, (long)1024L).get(0);
            namesystem.writeLock();
            bm.findAndMarkBlockAsCorrupt(block.getBlock(), (DatanodeInfo)block.getLocations()[0], "STORAGE_ID", "TEST");
            namesystem.writeUnlock();
            BlockManagerTestUtil.updateState((BlockManager)bm);
            DFSTestUtil.waitCorruptReplicas((FileSystem)fileSystem, (FSNamesystem)namesystem, (Path)new Path(testFile), (ExtendedBlock)block.getBlock(), (int)1);
            ReplicatedBlockStats stats = context.getClient().getNamenode().getReplicatedBlockStats();
            Assert.assertEquals((long)1L, (long)stats.getCorruptBlocks());
        }
        ReplicatedBlockStats routerStat = this.routerProtocol.getReplicatedBlockStats();
        Assert.assertEquals((String)"There should be 1 corrupt blocks for each NN", (long)cluster.getNameservices().size(), (long)routerStat.getCorruptBlocks());
    }

    @Test
    public void testErasureCoding() throws Exception {
        ErasureCodingPolicyInfo[] policies;
        LOG.info("List the available erasurce coding policies");
        for (ErasureCodingPolicyInfo policy : policies = this.checkErasureCodingPolicies()) {
            LOG.info("  {}", (Object)policy);
        }
        LOG.info("List the erasure coding codecs");
        Map codecsRouter = this.routerProtocol.getErasureCodingCodecs();
        Map codecsNamenode = this.nnProtocol.getErasureCodingCodecs();
        Assert.assertTrue((boolean)Maps.difference((Map)codecsRouter, (Map)codecsNamenode).areEqual());
        for (Map.Entry entry : codecsRouter.entrySet()) {
            LOG.info("  {}: {}", entry.getKey(), entry.getValue());
        }
        LOG.info("Create a testing directory via the router at the root level");
        String dirPath = "/testec";
        String filePath1 = dirPath + "/testfile1";
        FsPermission permission = new FsPermission("755");
        this.routerProtocol.mkdirs(dirPath, permission, false);
        FederationTestUtils.createFile(this.routerFS, filePath1, 32L);
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, filePath1));
        DFSClient file1Protocol = this.getFileDFSClient(filePath1);
        LOG.info("The policy for the new file should not be set");
        Assert.assertNull((Object)this.routerProtocol.getErasureCodingPolicy(filePath1));
        Assert.assertNull((Object)file1Protocol.getErasureCodingPolicy(filePath1));
        String policyName = "RS-6-3-1024k";
        LOG.info("Set policy \"{}\" for \"{}\"", (Object)policyName, (Object)dirPath);
        this.routerProtocol.setErasureCodingPolicy(dirPath, policyName);
        String filePath2 = dirPath + "/testfile2";
        LOG.info("Create {} in the path with the new EC policy", (Object)filePath2);
        FederationTestUtils.createFile(this.routerFS, filePath2, 32L);
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, filePath2));
        DFSClient file2Protocol = this.getFileDFSClient(filePath2);
        LOG.info("Check that the policy is set for {}", (Object)filePath2);
        ErasureCodingPolicy policyRouter1 = this.routerProtocol.getErasureCodingPolicy(filePath2);
        ErasureCodingPolicy policyNamenode1 = file2Protocol.getErasureCodingPolicy(filePath2);
        Assert.assertNotNull((Object)policyRouter1);
        Assert.assertEquals((Object)policyName, (Object)policyRouter1.getName());
        Assert.assertEquals((Object)policyName, (Object)policyNamenode1.getName());
        LOG.info("Create a new erasure coding policy");
        String newPolicyName = "RS-6-3-128k";
        ECSchema ecSchema = new ECSchema("rs", 6, 3);
        ErasureCodingPolicy ecPolicy = new ErasureCodingPolicy(newPolicyName, ecSchema, 131072, -1);
        ErasureCodingPolicy[] newPolicies = new ErasureCodingPolicy[]{ecPolicy};
        AddErasureCodingPolicyResponse[] responses = this.routerProtocol.addErasureCodingPolicies(newPolicies);
        Assert.assertEquals((long)1L, (long)responses.length);
        Assert.assertTrue((boolean)responses[0].isSucceed());
        this.routerProtocol.disableErasureCodingPolicy(newPolicyName);
        LOG.info("The new policy should be there and disabled");
        policies = this.checkErasureCodingPolicies();
        boolean found = false;
        for (ErasureCodingPolicyInfo policy : policies) {
            LOG.info("  {}" + policy);
            if (!policy.getPolicy().getName().equals(newPolicyName)) continue;
            found = true;
            Assert.assertEquals((Object)ErasureCodingPolicyState.DISABLED, (Object)policy.getState());
            break;
        }
        Assert.assertTrue((boolean)found);
        LOG.info("Set the test folder to use the new policy");
        this.routerProtocol.enableErasureCodingPolicy(newPolicyName);
        this.routerProtocol.setErasureCodingPolicy(dirPath, newPolicyName);
        LOG.info("Create a file in the path with the new EC policy");
        String filePath3 = dirPath + "/testfile3";
        FederationTestUtils.createFile(this.routerFS, filePath3, 32L);
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, filePath3));
        DFSClient file3Protocol = this.getFileDFSClient(filePath3);
        ErasureCodingPolicy policyRouterFile3 = this.routerProtocol.getErasureCodingPolicy(filePath3);
        Assert.assertEquals((Object)newPolicyName, (Object)policyRouterFile3.getName());
        ErasureCodingPolicy policyNamenodeFile3 = file3Protocol.getErasureCodingPolicy(filePath3);
        Assert.assertEquals((Object)newPolicyName, (Object)policyNamenodeFile3.getName());
        LOG.info("Remove the policy and check the one for the test folder");
        this.routerProtocol.removeErasureCodingPolicy(newPolicyName);
        ErasureCodingPolicy policyRouter3 = this.routerProtocol.getErasureCodingPolicy(filePath3);
        Assert.assertEquals((Object)newPolicyName, (Object)policyRouter3.getName());
        ErasureCodingPolicy policyNamenode3 = file3Protocol.getErasureCodingPolicy(filePath3);
        Assert.assertEquals((Object)newPolicyName, (Object)policyNamenode3.getName());
        LOG.info("Check the stats");
        ECBlockGroupStats statsRouter = this.routerProtocol.getECBlockGroupStats();
        ECBlockGroupStats statsNamenode = this.getNamenodeECBlockGroupStats();
        Assert.assertEquals((Object)statsNamenode, (Object)statsRouter);
    }

    private ECBlockGroupStats getNamenodeECBlockGroupStats() throws Exception {
        ArrayList<ECBlockGroupStats> nnStats = new ArrayList<ECBlockGroupStats>();
        for (MiniRouterDFSCluster.NamenodeContext nnContext : cluster.getNamenodes()) {
            ClientProtocol cp = nnContext.getClient().getNamenode();
            nnStats.add(cp.getECBlockGroupStats());
        }
        return ECBlockGroupStats.merge(nnStats);
    }

    @Test
    public void testGetCurrentTXIDandRollEdits() throws IOException {
        Long rollEdits = this.routerProtocol.rollEdits();
        Long currentTXID = this.routerProtocol.getCurrentEditLogTxid();
        Assert.assertEquals((Object)rollEdits, (Object)currentTXID);
    }

    @Test
    public void testSaveNamespace() throws IOException {
        cluster.getCluster().getFileSystem(0).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        cluster.getCluster().getFileSystem(1).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER);
        Boolean saveNamespace = this.routerProtocol.saveNamespace(0L, 0L);
        Assert.assertTrue((boolean)saveNamespace);
        cluster.getCluster().getFileSystem(0).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
        cluster.getCluster().getFileSystem(1).setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNamenodeMetrics() throws Exception {
        final NamenodeBeanMetrics metrics = this.router.getRouter().getNamenodeMetrics();
        final String jsonString0 = metrics.getLiveNodes();
        JSONObject jsonObject = new JSONObject(jsonString0);
        Assert.assertEquals((long)12L, (long)jsonObject.names().length());
        String jsonString1 = metrics.getLiveNodes();
        Assert.assertEquals((Object)jsonString0, (Object)jsonString1);
        GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return !jsonString0.equals(metrics.getLiveNodes());
            }
        }, (long)500L, (long)5000L);
        final String jsonString2 = metrics.getLiveNodes();
        Assert.assertNotEquals((Object)jsonString0, (Object)jsonString2);
        MockResolver resolver = (MockResolver)this.router.getRouter().getNamenodeResolver();
        resolver.cleanRegistrations();
        resolver.setDisableRegistration(true);
        try {
            GenericTestUtils.waitFor((Supplier)new Supplier<Boolean>(){

                @Override
                public Boolean get() {
                    return !jsonString2.equals(metrics.getLiveNodes());
                }
            }, (long)500L, (long)5000L);
            Assert.assertEquals((Object)"{}", (Object)metrics.getLiveNodes());
        }
        finally {
            resolver.setDisableRegistration(false);
            cluster.registerNamenodes();
            cluster.waitNamenodeRegistration();
        }
    }

    @Test
    public void testRBFMetricsMethodsRelayOnStateStore() {
        Assert.assertNull((Object)this.router.getRouter().getStateStore());
        RBFMetrics metrics = this.router.getRouter().getMetrics();
        Assert.assertEquals((Object)"{}", (Object)metrics.getNamenodes());
        Assert.assertEquals((Object)"[]", (Object)metrics.getMountTable());
        Assert.assertEquals((Object)"{}", (Object)metrics.getRouters());
        Assert.assertEquals((long)0L, (long)metrics.getNumNamenodes());
        Assert.assertEquals((long)0L, (long)metrics.getNumExpiredNamenodes());
        Assert.assertEquals((Object)"[]", (Object)metrics.getClusterId());
        Assert.assertEquals((Object)"[]", (Object)metrics.getBlockPoolId());
        Assert.assertEquals((Object)"{}", (Object)metrics.getNameservices());
        Assert.assertEquals((long)0L, (long)metrics.getNumLiveNodes());
    }

    @Test
    public void testNamenodeMetricsEnteringMaintenanceNodes() throws IOException {
        NamenodeBeanMetrics metrics = this.router.getRouter().getNamenodeMetrics();
        Assert.assertEquals((Object)"{}", (Object)metrics.getEnteringMaintenanceNodes());
    }

    @Test
    public void testCacheAdmin() throws Exception {
        DistributedFileSystem routerDFS = (DistributedFileSystem)this.routerFS;
        CachePoolInfo cpInfo = new CachePoolInfo("Check");
        cpInfo.setOwnerName("Owner");
        this.routerProtocol.addCachePool(cpInfo);
        RemoteIterator iter = routerDFS.listCachePools();
        Assert.assertTrue((boolean)iter.hasNext());
        CachePoolInfo info = ((CachePoolEntry)iter.next()).getInfo();
        Assert.assertEquals((Object)"Owner", (Object)info.getOwnerName());
        cpInfo.setOwnerName("new Owner");
        this.routerProtocol.modifyCachePool(cpInfo);
        iter = routerDFS.listCachePools();
        Assert.assertTrue((boolean)iter.hasNext());
        info = ((CachePoolEntry)iter.next()).getInfo();
        Assert.assertEquals((Object)"new Owner", (Object)info.getOwnerName());
        this.routerProtocol.removeCachePool("Check");
        iter = routerDFS.listCachePools();
        Assert.assertFalse((boolean)iter.hasNext());
        cpInfo.setOwnerName("Owner");
        this.routerProtocol.addCachePool(cpInfo);
        routerDFS.mkdirs(new Path("/ns1/dir"));
        CacheDirectiveInfo cacheDir = new CacheDirectiveInfo.Builder().setPath(new Path("/ns1/dir")).setReplication(Short.valueOf((short)1)).setPool("Check").build();
        long id = routerDFS.addCacheDirective(cacheDir);
        CacheDirectiveInfo filter = new CacheDirectiveInfo.Builder().setPath(new Path("/ns1/dir")).build();
        Assert.assertTrue((boolean)routerDFS.listCacheDirectives(filter).hasNext());
        Assert.assertEquals((Object)"Check", (Object)((CacheDirectiveEntry)routerDFS.listCacheDirectives(filter).next()).getInfo().getPool());
        cacheDir = new CacheDirectiveInfo.Builder().setReplication(Short.valueOf((short)2)).setId(Long.valueOf(id)).setPath(new Path("/ns1/dir")).build();
        routerDFS.modifyCacheDirective(cacheDir);
        Assert.assertEquals((long)2L, (long)((CacheDirectiveEntry)routerDFS.listCacheDirectives(filter).next()).getInfo().getReplication().shortValue());
        routerDFS.removeCacheDirective(id);
        Assert.assertFalse((boolean)routerDFS.listCacheDirectives(filter).hasNext());
    }

    @Test
    public void testgetGroupsForUser() throws IOException {
        Object[] group = new String[]{"bar", "group2"};
        UserGroupInformation.createUserForTesting((String)"user", (String[])new String[]{"bar", "group2"});
        Object[] result = this.router.getRouter().getRpcServer().getGroupsForUser("user");
        Assert.assertArrayEquals((Object[])group, (Object[])result);
    }

    private ErasureCodingPolicyInfo[] checkErasureCodingPolicies() throws IOException {
        Object[] policiesRouter = this.routerProtocol.getErasureCodingPolicies();
        Assert.assertNotNull((Object)policiesRouter);
        Object[] policiesNamenode = this.nnProtocol.getErasureCodingPolicies();
        Arrays.sort(policiesRouter, EC_POLICY_CMP);
        Arrays.sort(policiesNamenode, EC_POLICY_CMP);
        Assert.assertArrayEquals((Object[])policiesRouter, (Object[])policiesNamenode);
        return policiesRouter;
    }

    private DFSClient getFileDFSClient(String path) {
        for (String nsId : cluster.getNameservices()) {
            LOG.info("Checking {} for {}", (Object)nsId, (Object)path);
            MiniRouterDFSCluster.NamenodeContext nn = cluster.getNamenode(nsId, null);
            try {
                DFSClient nnClientProtocol = nn.getClient();
                if (nnClientProtocol.getFileInfo(path) == null) continue;
                return nnClientProtocol;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    @Test
    public void testMkdirsWithCallerContext() throws IOException {
        GenericTestUtils.LogCapturer auditlog = GenericTestUtils.LogCapturer.captureLogs((org.apache.log4j.Logger)FSNamesystem.AUDIT_LOG);
        Assert.assertNull((Object)CallerContext.getCurrent());
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("clientContext").build());
        String dirPath = "/test_dir_with_callercontext";
        FsPermission permission = new FsPermission("755");
        this.routerProtocol.mkdirs(dirPath, permission, false);
        String logOutput = auditlog.getOutput();
        Assert.assertTrue((boolean)logOutput.contains("callerContext=clientIp:"));
        Assert.assertTrue((boolean)logOutput.contains(",clientContext"));
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
    }

    @Test
    public void testSetBalancerBandwidth() throws Exception {
        long defaultBandwidth = 0x6400000L;
        long newBandwidth = defaultBandwidth * 2L;
        this.routerProtocol.setBalancerBandwidth(newBandwidth);
        ArrayList datanodes = cluster.getCluster().getDataNodes();
        GenericTestUtils.waitFor(() -> ((DataNode)datanodes.get(0)).getBalancerBandwidth() == newBandwidth, (long)100L, (long)60000L);
    }

    @Test
    public void testAddClientIpPortToCallerContext() throws IOException {
        GenericTestUtils.LogCapturer auditLog = GenericTestUtils.LogCapturer.captureLogs((org.apache.log4j.Logger)FSNamesystem.AUDIT_LOG);
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("clientContext").build());
        String dirPath = "/test";
        this.routerProtocol.mkdirs(dirPath, new FsPermission("755"), false);
        Assert.assertTrue((boolean)auditLog.getOutput().contains("clientIp:"));
        Assert.assertTrue((boolean)auditLog.getOutput().contains("clientPort:"));
        Assert.assertTrue((boolean)FederationTestUtils.verifyFileExists(this.routerFS, dirPath));
        auditLog.clearOutput();
        CallerContext.setCurrent((CallerContext)new CallerContext.Builder("clientContext,clientIp:1.1.1.1,clientPort:1234").build());
        this.routerProtocol.getFileInfo(dirPath);
        Assert.assertFalse((boolean)auditLog.getOutput().contains("clientIp:1.1.1.1"));
        Assert.assertFalse((boolean)auditLog.getOutput().contains("clientPort:1234"));
    }
}

