/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.matrix.decomposition.BidiagonalDecomposition;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public interface Bidiagonal<N extends Number>
extends MatrixDecomposition<N>,
MatrixDecomposition.EconomySize<N> {
    public static final Factory<BigDecimal> BIG = typical -> new BidiagonalDecomposition.Big();
    public static final Factory<ComplexNumber> COMPLEX = typical -> new BidiagonalDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> new BidiagonalDecomposition.Primitive();

    public static <N extends Number> Bidiagonal<N> make(Access2D<N> typical) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return (Bidiagonal)BIG.make(typical);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return (Bidiagonal)COMPLEX.make(typical);
        }
        if (tmpNumber instanceof Double) {
            return (Bidiagonal)PRIMITIVE.make(typical);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Bidiagonal<N> decomposition, NumberContext context) {
        MatrixStore<Object> tmpThat;
        MatrixStore<N> tmpThis;
        boolean retVal;
        int tmpRowDim = (int)matrix.countRows();
        int tmpColDim = (int)matrix.countColumns();
        MatrixStore<Object> tmpQ1 = decomposition.getQ1();
        decomposition.getD();
        MatrixStore<Object> tmpQ2 = decomposition.getQ2();
        Object tmpConjugatedQ1 = tmpQ1.logical().conjugate().get();
        Object tmpConjugatedQ2 = tmpQ2.logical().conjugate().get();
        boolean bl = retVal = (long)tmpRowDim == tmpQ1.countRows() && tmpQ2.countRows() == (long)tmpColDim;
        if (retVal) {
            tmpThis = matrix;
            tmpThat = decomposition.reconstruct();
            retVal &= tmpThis.equals(tmpThat, context);
        }
        if (retVal && tmpQ1.countRows() == tmpQ1.countColumns()) {
            tmpThis = tmpQ1;
            tmpThat = tmpQ1.multiply(tmpConjugatedQ1).multiply((Object)tmpQ1);
            retVal &= tmpThis.equals(tmpThat, context);
        }
        if (retVal && tmpQ2.countRows() == tmpQ2.countColumns()) {
            tmpThis = tmpQ2;
            tmpThat = tmpQ2.multiply(tmpConjugatedQ2).multiply((Object)tmpQ2);
            retVal &= tmpThis.equals(tmpThat, context);
        }
        return retVal;
    }

    public static <N extends Number> MatrixStore<N> reconstruct(Bidiagonal<N> decomposition) {
        return decomposition.getQ1().multiply(decomposition.getD()).multiply((MatrixStore<Object>)decomposition.getQ2().conjugate());
    }

    public MatrixStore<N> getD();

    public MatrixStore<N> getQ1();

    public MatrixStore<N> getQ2();

    public boolean isUpper();

    @Override
    default public MatrixStore<N> reconstruct() {
        return Bidiagonal.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<Bidiagonal<N>> {
    }
}

