/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StreamCapabilities;
import org.apache.hadoop.fs.statistics.IOStatisticsLogging;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.PathOutputCommitter;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.ManifestCommitterConfig;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.ManifestSuccessData;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.files.TaskManifest;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.AuditingIntegration;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestStoreOperations;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.AbortTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CleanupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CommitJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.CommitTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupJobStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.SetupTaskStage;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageEventCallbacks;
import org.apache.hadoop.util.functional.CloseableTaskPoolSubmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class ManifestCommitter
extends PathOutputCommitter
implements IOStatisticsSource,
StageEventCallbacks,
StreamCapabilities {
    public static final Logger LOG = LoggerFactory.getLogger(ManifestCommitter.class);
    public static final String TASK_COMMITTER = "task committer";
    public static final String JOB_COMMITTER = "job committer";
    private final ManifestCommitterConfig baseConfig;
    private final Path destinationDir;
    private final Path taskAttemptDir;
    private final IOStatisticsStore iostatistics;
    private ManifestSuccessData successReport;
    private String activeStage;
    private TaskManifest taskAttemptCommittedManifest;

    public ManifestCommitter(Path outputPath, TaskAttemptContext context) throws IOException {
        super(outputPath, context);
        this.destinationDir = this.resolveDestinationDirectory(outputPath, context.getConfiguration());
        this.iostatistics = ManifestCommitterSupport.createIOStatisticsStore().build();
        this.baseConfig = this.enterCommitter(context.getTaskAttemptID() != null, context);
        this.taskAttemptDir = this.baseConfig.getTaskAttemptDir();
        LOG.info("Created ManifestCommitter with JobID {}, Task Attempt {} and destination {}", new Object[]{context.getJobID(), context.getTaskAttemptID(), outputPath});
    }

    private ManifestCommitterConfig enterCommitter(boolean isTask, JobContext context) {
        ManifestCommitterConfig committerConfig = new ManifestCommitterConfig(this.getOutputPath(), isTask ? TASK_COMMITTER : JOB_COMMITTER, context, this.iostatistics, this);
        AuditingIntegration.updateCommonContextOnCommitterEntry(committerConfig);
        return committerConfig;
    }

    @Override
    public void setupJob(JobContext jobContext) throws IOException {
        ManifestCommitterConfig committerConfig = this.enterCommitter(false, jobContext);
        StageConfig stageConfig = committerConfig.createStageConfig().withOperations(this.createManifestStoreOperations()).build();
        new SetupJobStage(stageConfig).apply(committerConfig.getCreateJobMarker());
        this.logCommitterStatisticsAtDebug();
    }

    @Override
    public void setupTask(TaskAttemptContext context) throws IOException {
        ManifestCommitterConfig committerConfig = this.enterCommitter(true, context);
        StageConfig stageConfig = committerConfig.createStageConfig().withOperations(this.createManifestStoreOperations()).build();
        new SetupTaskStage(stageConfig).apply("");
        this.logCommitterStatisticsAtDebug();
    }

    @Override
    public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
        LOG.info("Probe for needsTaskCommit({})", (Object)context.getTaskAttemptID());
        return true;
    }

    @Override
    public boolean isCommitJobRepeatable(JobContext jobContext) throws IOException {
        LOG.info("Probe for isCommitJobRepeatable({}): returning false", (Object)jobContext.getJobID());
        return false;
    }

    @Override
    public boolean isRecoverySupported(JobContext jobContext) throws IOException {
        LOG.info("Probe for isRecoverySupported({}): returning false", (Object)jobContext.getJobID());
        return false;
    }

    @Override
    public void recoverTask(TaskAttemptContext taskContext) throws IOException {
        LOG.warn("Rejecting recoverTask({}) call", (Object)taskContext.getTaskAttemptID());
        throw new IOException("Cannot recover task " + taskContext.getTaskAttemptID());
    }

    @Override
    public void commitTask(TaskAttemptContext context) throws IOException {
        ManifestCommitterConfig committerConfig = this.enterCommitter(true, context);
        try {
            StageConfig stageConfig = committerConfig.createStageConfig().withOperations(this.createManifestStoreOperations()).build();
            this.taskAttemptCommittedManifest = ((CommitTaskStage.Result)new CommitTaskStage(stageConfig).apply(null)).getTaskManifest();
            this.iostatistics.incrementCounter("committer_tasks_completed", 1L);
        }
        catch (IOException e) {
            this.iostatistics.incrementCounter("committer_tasks_failed", 1L);
            throw e;
        }
        finally {
            this.logCommitterStatisticsAtDebug();
            AuditingIntegration.updateCommonContextOnCommitterExit();
        }
    }

    @Override
    public void abortTask(TaskAttemptContext context) throws IOException {
        ManifestCommitterConfig committerConfig = this.enterCommitter(true, context);
        try {
            new AbortTaskStage(committerConfig.createStageConfig().withOperations(this.createManifestStoreOperations()).build()).apply(false);
        }
        finally {
            this.logCommitterStatisticsAtDebug();
            AuditingIntegration.updateCommonContextOnCommitterExit();
        }
    }

    private ManifestSuccessData getOrCreateSuccessData(ManifestCommitterConfig committerConfig) {
        if (this.successReport == null) {
            this.successReport = ManifestCommitterSupport.createManifestOutcome(committerConfig.createStageConfig(), this.activeStage);
        }
        return this.successReport;
    }

    @Override
    public void commitJob(JobContext jobContext) throws IOException {
        ManifestCommitterConfig committerConfig = this.enterCommitter(false, jobContext);
        ManifestSuccessData marker = this.getOrCreateSuccessData(committerConfig);
        IOException failure = null;
        try (CloseableTaskPoolSubmitter ioProcs = committerConfig.createSubmitter();
             ManifestStoreOperations storeOperations = this.createManifestStoreOperations();){
            StageConfig stageConfig = committerConfig.createStageConfig().withOperations(storeOperations).withIOProcessors(ioProcs).build();
            Configuration conf = jobContext.getConfiguration();
            CommitJobStage.Result result = (CommitJobStage.Result)new CommitJobStage(stageConfig).apply(new CommitJobStage.Arguments(committerConfig.getCreateJobMarker(), committerConfig.getValidateOutput(), conf.getTrimmed("mapreduce.manifest.committer.diagnostics.manifest.directory", ""), CleanupJobStage.cleanupStageOptionsFromConfig("job_stage_cleanup", conf)));
            marker = result.getJobSuccessData();
            this.setSuccessReport(marker);
        }
        catch (IOException e) {
            failure = e;
            throw e;
        }
        finally {
            ManifestCommitter.maybeSaveSummary(this.activeStage, committerConfig, marker, failure, true, true);
            LOG.info("{}: Job Commit statistics {}", (Object)committerConfig.getName(), (Object)IOStatisticsLogging.ioStatisticsToPrettyString(this.iostatistics));
            Long recoveries = this.iostatistics.counters().get("commit_file_rename_recovered");
            if (recoveries != null && recoveries > 0L) {
                LOG.warn("{}: rename failures were recovered from. Number of recoveries: {}", (Object)committerConfig.getName(), (Object)recoveries);
            }
            AuditingIntegration.updateCommonContextOnCommitterExit();
        }
    }

    @Override
    public void abortJob(JobContext jobContext, JobStatus.State state) throws IOException {
        LOG.info("Aborting Job {} in state {}", (Object)jobContext.getJobID(), (Object)state);
        ManifestCommitterConfig committerConfig = this.enterCommitter(false, jobContext);
        ManifestSuccessData report = this.getOrCreateSuccessData(committerConfig);
        IOException failure = null;
        try {
            this.executeCleanup("job_stage_abort", jobContext, committerConfig);
        }
        catch (IOException e) {
            failure = e;
        }
        report.setSuccess(false);
        ManifestCommitter.maybeSaveSummary(this.activeStage, committerConfig, report, failure, true, false);
        LOG.info("Job Abort statistics {}", (Object)IOStatisticsLogging.ioStatisticsToPrettyString(this.iostatistics));
        AuditingIntegration.updateCommonContextOnCommitterExit();
    }

    @Override
    public void cleanupJob(JobContext jobContext) throws IOException {
        ManifestCommitterConfig committerConfig = this.enterCommitter(false, jobContext);
        try {
            this.executeCleanup("job_stage_cleanup", jobContext, committerConfig);
        }
        finally {
            this.logCommitterStatisticsAtDebug();
            AuditingIntegration.updateCommonContextOnCommitterExit();
        }
    }

    private CleanupJobStage.Result executeCleanup(String statisticName, JobContext jobContext, ManifestCommitterConfig committerConfig) throws IOException {
        try (CloseableTaskPoolSubmitter ioProcs = committerConfig.createSubmitter();){
            CleanupJobStage.Result result = (CleanupJobStage.Result)new CleanupJobStage(committerConfig.createStageConfig().withOperations(this.createManifestStoreOperations()).withIOProcessors(ioProcs).build()).apply(CleanupJobStage.cleanupStageOptionsFromConfig(statisticName, jobContext.getConfiguration()));
            return result;
        }
    }

    @Override
    public Path getOutputPath() {
        return this.getDestinationDir();
    }

    @Override
    public Path getWorkPath() {
        return this.getTaskAttemptDir();
    }

    private Path getDestinationDir() {
        return this.destinationDir;
    }

    private Path getTaskAttemptDir() {
        return this.taskAttemptDir;
    }

    @Override
    public void enterStage(String stage) {
        this.activeStage = stage;
        AuditingIntegration.enterStage(stage);
    }

    @Override
    public void exitStage(String stage) {
        AuditingIntegration.exitStage();
    }

    public String getJobUniqueId() {
        return this.baseConfig.getJobUniqueId();
    }

    public Configuration getConf() {
        return this.baseConfig.getConf();
    }

    public ManifestSuccessData getSuccessReport() {
        return this.successReport;
    }

    private void setSuccessReport(ManifestSuccessData successReport) {
        this.successReport = successReport;
    }

    @VisibleForTesting
    TaskManifest getTaskAttemptCommittedManifest() {
        return this.taskAttemptCommittedManifest;
    }

    @VisibleForTesting
    public Path getTaskAttemptPath(TaskAttemptContext context) {
        return this.enterCommitter(false, context).getTaskAttemptDir();
    }

    @VisibleForTesting
    public Path getTaskManifestPath(TaskAttemptContext context) {
        Path dir = this.enterCommitter(false, context).getTaskManifestDir();
        return ManifestCommitterSupport.manifestPathForTask(dir, context.getTaskAttemptID().getTaskID().toString());
    }

    @VisibleForTesting
    public Path getJobAttemptPath(JobContext context) {
        return this.enterCommitter(false, context).getJobAttemptDir();
    }

    private Path resolveDestinationDirectory(Path outputPath, Configuration conf) throws IOException {
        return FileSystem.get(outputPath.toUri(), conf).makeQualified(outputPath);
    }

    protected ManifestStoreOperations createManifestStoreOperations() throws IOException {
        return ManifestCommitterSupport.createManifestStoreOperations(this.baseConfig.getConf(), this.baseConfig.getDestinationFileSystem(), this.baseConfig.getDestinationDir());
    }

    private void logCommitterStatisticsAtDebug() {
        IOStatisticsLogging.logIOStatisticsAtDebug(LOG, "Committer Statistics", this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ManifestCommitter{");
        sb.append(this.baseConfig);
        sb.append(", iostatistics=").append(IOStatisticsLogging.ioStatisticsToPrettyString(this.iostatistics));
        sb.append('}');
        return sb.toString();
    }

    /*
     * Exception decompiling
     */
    private static Path maybeSaveSummary(String activeStage, ManifestCommitterConfig config, ManifestSuccessData report, Throwable thrown, boolean quiet, boolean overwrite) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 7[CATCHBLOCK], 1[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public IOStatisticsStore getIOStatistics() {
        return this.iostatistics;
    }

    @Override
    public boolean hasCapability(String capability) {
        return "mapreduce.job.committer.dynamic.partitioning".equals(capability);
    }
}

