/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.jsr107;

import java.io.Closeable;
import java.io.IOException;
import java.util.function.Supplier;
import org.apache.hadoop.shaded.javax.cache.expiry.Duration;
import org.apache.hadoop.shaded.javax.cache.expiry.ExpiryPolicy;
import org.apache.hadoop.shaded.org.ehcache.core.config.ExpiryUtils;
import org.apache.hadoop.shaded.org.ehcache.jsr107.Eh107Expiry;

class ExpiryPolicyToEhcacheExpiry<K, V>
extends Eh107Expiry<K, V>
implements Closeable {
    private final ExpiryPolicy expiryPolicy;

    ExpiryPolicyToEhcacheExpiry(ExpiryPolicy expiryPolicy) {
        this.expiryPolicy = expiryPolicy;
    }

    @Override
    public java.time.Duration getExpiryForCreation(K key, V value) {
        try {
            Duration duration = this.expiryPolicy.getExpiryForCreation();
            return this.convertDuration(duration);
        }
        catch (Throwable t) {
            return java.time.Duration.ZERO;
        }
    }

    @Override
    protected java.time.Duration getExpiryForAccessInternal(K key, Supplier<? extends V> value) {
        try {
            Duration duration = this.expiryPolicy.getExpiryForAccess();
            if (duration == null) {
                return null;
            }
            return this.convertDuration(duration);
        }
        catch (Throwable t) {
            return java.time.Duration.ZERO;
        }
    }

    @Override
    public java.time.Duration getExpiryForUpdate(K key, Supplier<? extends V> oldValue, V newValue) {
        try {
            Duration duration = this.expiryPolicy.getExpiryForUpdate();
            if (duration == null) {
                return null;
            }
            return this.convertDuration(duration);
        }
        catch (Throwable t) {
            return java.time.Duration.ZERO;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.expiryPolicy instanceof Closeable) {
            ((Closeable)((Object)this.expiryPolicy)).close();
        }
    }

    private java.time.Duration convertDuration(Duration duration) {
        if (duration.isEternal()) {
            return org.apache.hadoop.shaded.org.ehcache.expiry.ExpiryPolicy.INFINITE;
        }
        return java.time.Duration.of(duration.getDurationAmount(), ExpiryUtils.jucTimeUnitToTemporalUnit(duration.getTimeUnit()));
    }
}

