/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticatedURL;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.CollectorInfo;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntities;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.client.api.TimelineV2Client;
import org.apache.hadoop.yarn.client.api.impl.TimelineConnector;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimelineV2ClientImpl
extends TimelineV2Client {
    private static final Logger LOG = LoggerFactory.getLogger(TimelineV2ClientImpl.class);
    private static final String RESOURCE_URI_STR_V2 = "/ws/v2/timeline/";
    private TimelineEntityDispatcher entityDispatcher;
    private TimelineEntityDispatcher subAppEntityDispatcher;
    private volatile String timelineServiceAddress;
    @VisibleForTesting
    volatile org.apache.hadoop.yarn.api.records.Token currentTimelineToken = null;
    private int maxServiceRetries;
    private long serviceRetryInterval;
    private TimelineConnector connector;
    private ApplicationId contextAppId;
    private UserGroupInformation authUgi;

    public TimelineV2ClientImpl(ApplicationId appId) {
        super(TimelineV2ClientImpl.class.getName());
        this.contextAppId = appId;
    }

    public ApplicationId getContextAppId() {
        return this.contextAppId;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        if (!YarnConfiguration.timelineServiceV2Enabled((Configuration)conf)) {
            throw new IOException("Timeline V2 client is not properly configured. Either timeline service is not enabled or version is not set to 2");
        }
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        UserGroupInformation realUgi = ugi.getRealUser();
        String doAsUser = null;
        if (realUgi != null) {
            this.authUgi = realUgi;
            doAsUser = ugi.getShortUserName();
        } else {
            this.authUgi = ugi;
            doAsUser = null;
        }
        DelegationTokenAuthenticatedURL.Token token = new DelegationTokenAuthenticatedURL.Token();
        this.connector = new TimelineConnector(false, this.authUgi, doAsUser, token);
        this.addIfService((Object)this.connector);
        this.maxServiceRetries = conf.getInt("yarn.timeline-service.client.max-retries", 30);
        this.serviceRetryInterval = conf.getLong("yarn.timeline-service.client.retry-interval-ms", 1000L);
        this.entityDispatcher = new TimelineEntityDispatcher(conf);
        this.subAppEntityDispatcher = new TimelineEntityDispatcher(conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        super.serviceStart();
        this.entityDispatcher.start();
        this.subAppEntityDispatcher.start();
    }

    protected void serviceStop() throws Exception {
        this.entityDispatcher.stop();
        this.subAppEntityDispatcher.stop();
        super.serviceStop();
    }

    @Override
    public void putEntities(TimelineEntity ... entities) throws IOException, YarnException {
        this.entityDispatcher.dispatchEntities(true, entities, false);
    }

    @Override
    public void putEntitiesAsync(TimelineEntity ... entities) throws IOException, YarnException {
        this.entityDispatcher.dispatchEntities(false, entities, false);
    }

    @Override
    public void putSubAppEntities(TimelineEntity ... entities) throws IOException, YarnException {
        this.subAppEntityDispatcher.dispatchEntities(true, entities, true);
    }

    @Override
    public void putSubAppEntitiesAsync(TimelineEntity ... entities) throws IOException, YarnException {
        this.subAppEntityDispatcher.dispatchEntities(false, entities, true);
    }

    @Override
    public void setTimelineCollectorInfo(CollectorInfo collectorInfo) {
        if (collectorInfo == null) {
            LOG.warn("Not setting collector info as it is null.");
            return;
        }
        if (collectorInfo.getCollectorToken() != null) {
            this.setTimelineDelegationToken(collectorInfo.getCollectorToken(), collectorInfo.getCollectorAddr());
        }
        if (collectorInfo.getCollectorAddr() != null && !collectorInfo.getCollectorAddr().isEmpty() && !collectorInfo.getCollectorAddr().equals(this.timelineServiceAddress)) {
            this.timelineServiceAddress = collectorInfo.getCollectorAddr();
            LOG.info("Updated timeline service address to " + this.timelineServiceAddress);
        }
    }

    private void setTimelineDelegationToken(org.apache.hadoop.yarn.api.records.Token delegationToken, String collectorAddr) {
        String service;
        if (!delegationToken.getKind().equals(TimelineDelegationTokenIdentifier.KIND_NAME.toString())) {
            LOG.warn("Timeline token to be updated should be of kind " + TimelineDelegationTokenIdentifier.KIND_NAME);
            return;
        }
        if (collectorAddr == null || collectorAddr.isEmpty()) {
            collectorAddr = this.timelineServiceAddress;
        }
        if (((service = delegationToken.getService()) == null || service.isEmpty()) && (collectorAddr == null || collectorAddr.isEmpty())) {
            LOG.warn("Timeline token does not have service and timeline service address is not yet set. Not updating the token");
            return;
        }
        if (this.currentTimelineToken != null && this.currentTimelineToken.equals(delegationToken)) {
            return;
        }
        this.currentTimelineToken = delegationToken;
        Token timelineToken = new Token(delegationToken.getIdentifier().array(), delegationToken.getPassword().array(), new Text(delegationToken.getKind()), service == null ? new Text() : new Text(service));
        InetSocketAddress serviceAddr = collectorAddr != null && !collectorAddr.isEmpty() ? NetUtils.createSocketAddr((String)collectorAddr) : SecurityUtil.getTokenServiceAddr((Token)timelineToken);
        SecurityUtil.setTokenService((Token)timelineToken, (InetSocketAddress)serviceAddr);
        this.authUgi.addToken(timelineToken);
        LOG.info("Updated timeline delegation token " + timelineToken);
    }

    @InterfaceAudience.Private
    protected void putObjects(String path, MultivaluedMap<String, String> params, Object obj) throws IOException, YarnException {
        int retries = this.verifyRestEndPointAvailable();
        boolean needRetry = true;
        while (needRetry) {
            try {
                URI uri = TimelineConnector.constructResURI(this.getConfig(), this.timelineServiceAddress, RESOURCE_URI_STR_V2);
                this.putObjects(uri, path, params, obj);
                needRetry = false;
            }
            catch (IOException e) {
                this.checkRetryWithSleep(retries, e);
                --retries;
            }
        }
    }

    private void checkRetryWithSleep(int retries, IOException e) throws YarnException, IOException {
        if (retries > 0) {
            try {
                Thread.sleep(this.serviceRetryInterval);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new YarnException("Interrupted while retrying to connect to ATS");
            }
        } else {
            StringBuilder msg = new StringBuilder("TimelineClient has reached to max retry times : ");
            msg.append(this.maxServiceRetries).append(" for service address: ").append(this.timelineServiceAddress);
            LOG.error(msg.toString());
            throw new IOException(msg.toString(), e);
        }
    }

    private ClientResponse doPutObjects(URI base, String path, MultivaluedMap<String, String> params, Object obj) {
        return (ClientResponse)((WebResource.Builder)this.connector.getClient().resource(base).path(path).queryParams(params).accept(new String[]{"application/json"}).type("application/json")).put(ClientResponse.class, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putObjects(final URI base, final String path, final MultivaluedMap<String, String> params, final Object obj) throws IOException, YarnException {
        ClientResponse resp = null;
        try {
            resp = (ClientResponse)this.authUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ClientResponse>(){

                @Override
                public ClientResponse run() throws Exception {
                    return TimelineV2ClientImpl.this.doPutObjects(base, path, (MultivaluedMap<String, String>)params, obj);
                }
            });
        }
        catch (UndeclaredThrowableException ue) {
            Throwable cause = ue.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException(cause);
        }
        catch (InterruptedException ie) {
            throw (IOException)new InterruptedIOException().initCause(ie);
        }
        if (resp == null) {
            String msg = "Error getting HTTP response from the timeline server.";
            LOG.error(msg);
            throw new YarnException(msg);
        }
        if (resp.getStatusInfo().getStatusCode() == ClientResponse.Status.OK.getStatusCode()) {
            try {
                resp.close();
            }
            catch (ClientHandlerException che) {
                LOG.warn("Error closing the HTTP response's inputstream. ", (Throwable)che);
            }
        } else {
            String msg = "";
            try {
                String stringType = (String)resp.getEntity(String.class);
                msg = "Server response:\n" + stringType;
            }
            catch (ClientHandlerException | UniformInterfaceException chuie) {
                msg = "Error getting entity from the HTTP response." + chuie.getLocalizedMessage();
            }
            catch (Throwable t) {
                msg = "Error getting entity from the HTTP response." + t.getLocalizedMessage();
            }
            finally {
                msg = "Response from the timeline server is not successful, HTTP error code: " + resp.getStatus() + ", " + msg;
                LOG.error(msg);
                throw new YarnException(msg);
            }
        }
    }

    private int verifyRestEndPointAvailable() throws YarnException {
        int retries = this.pollTimelineServiceAddress(this.maxServiceRetries);
        if (this.timelineServiceAddress == null) {
            String errMessage = "TimelineClient has reached to max retry times : " + this.maxServiceRetries + ", but failed to fetch timeline service address. Please verify Timeline Auxiliary Service is configured in all the NMs";
            LOG.error(errMessage);
            throw new YarnException(errMessage);
        }
        return retries;
    }

    private int pollTimelineServiceAddress(int retries) throws YarnException {
        while (this.timelineServiceAddress == null && retries > 0) {
            try {
                Thread.sleep(this.serviceRetryInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new YarnException("Interrupted while trying to connect ATS");
            }
            --retries;
        }
        return retries;
    }

    private class TimelineEntityDispatcher {
        private final long drainTimeoutPeriod;
        private int numberOfAsyncsToMerge;
        private final BlockingQueue<EntitiesHolder> timelineEntityQueue = new LinkedBlockingQueue<EntitiesHolder>();
        private ExecutorService executor;

        TimelineEntityDispatcher(Configuration conf) {
            this.numberOfAsyncsToMerge = conf.getInt("yarn.timeline-service.timeline-client.number-of-async-entities-to-merge", 10);
            this.drainTimeoutPeriod = conf.getLong("yarn.timeline-service.client.drain-entities.timeout.ms", 2000L);
        }

        Runnable createRunnable() {
            return new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        while (!Thread.currentThread().isInterrupted()) {
                            EntitiesHolder entitiesHolder;
                            try {
                                entitiesHolder = (EntitiesHolder)TimelineEntityDispatcher.this.timelineEntityQueue.take();
                            }
                            catch (InterruptedException ie) {
                                LOG.info("Timeline dispatcher thread was interrupted ");
                                Thread.currentThread().interrupt();
                                if (!TimelineEntityDispatcher.this.timelineEntityQueue.isEmpty()) {
                                    LOG.info("Yet to publish " + TimelineEntityDispatcher.this.timelineEntityQueue.size() + " timelineEntities, draining them now. ");
                                }
                                long timeTillweDrain = System.currentTimeMillis() + TimelineEntityDispatcher.this.drainTimeoutPeriod;
                                while (!TimelineEntityDispatcher.this.timelineEntityQueue.isEmpty()) {
                                    this.publishWithoutBlockingOnQueue((EntitiesHolder)TimelineEntityDispatcher.this.timelineEntityQueue.poll());
                                    if (System.currentTimeMillis() <= timeTillweDrain) continue;
                                    if (TimelineEntityDispatcher.this.timelineEntityQueue.isEmpty()) break;
                                    LOG.warn("Time to drain elapsed! Remaining " + TimelineEntityDispatcher.this.timelineEntityQueue.size() + "timelineEntities will not be published");
                                    EntitiesHolder nextEntityInTheQueue = null;
                                    while ((nextEntityInTheQueue = (EntitiesHolder)TimelineEntityDispatcher.this.timelineEntityQueue.poll()) != null) {
                                        nextEntityInTheQueue.cancel(true);
                                    }
                                    break block7;
                                }
                                return;
                            }
                            if (entitiesHolder == null) continue;
                            this.publishWithoutBlockingOnQueue(entitiesHolder);
                        }
                    }
                    finally {
                        if (!TimelineEntityDispatcher.this.timelineEntityQueue.isEmpty()) {
                            LOG.info("Yet to publish " + TimelineEntityDispatcher.this.timelineEntityQueue.size() + " timelineEntities, draining them now. ");
                        }
                        long timeTillweDrain = System.currentTimeMillis() + TimelineEntityDispatcher.this.drainTimeoutPeriod;
                        while (!TimelineEntityDispatcher.this.timelineEntityQueue.isEmpty()) {
                            this.publishWithoutBlockingOnQueue((EntitiesHolder)TimelineEntityDispatcher.this.timelineEntityQueue.poll());
                            if (System.currentTimeMillis() <= timeTillweDrain) continue;
                            if (TimelineEntityDispatcher.this.timelineEntityQueue.isEmpty()) break;
                            LOG.warn("Time to drain elapsed! Remaining " + TimelineEntityDispatcher.this.timelineEntityQueue.size() + "timelineEntities will not be published");
                            EntitiesHolder nextEntityInTheQueue = null;
                            while ((nextEntityInTheQueue = (EntitiesHolder)TimelineEntityDispatcher.this.timelineEntityQueue.poll()) != null) {
                                nextEntityInTheQueue.cancel(true);
                            }
                            break block9;
                        }
                    }
                }

                private void publishWithoutBlockingOnQueue(EntitiesHolder entitiesHolder) {
                    block4: {
                        if (entitiesHolder.isSync()) {
                            entitiesHolder.run();
                            return;
                        }
                        int count = 1;
                        do {
                            EntitiesHolder nextEntityInTheQueue;
                            if ((nextEntityInTheQueue = (EntitiesHolder)TimelineEntityDispatcher.this.timelineEntityQueue.poll()) == null) {
                                entitiesHolder.run();
                                break block4;
                            }
                            if (nextEntityInTheQueue.isSync()) {
                                entitiesHolder.run();
                                nextEntityInTheQueue.run();
                                break block4;
                            }
                            entitiesHolder.getEntities().addEntities(nextEntityInTheQueue.getEntities().getEntities());
                        } while (++count != TimelineEntityDispatcher.this.numberOfAsyncsToMerge);
                        entitiesHolder.run();
                    }
                }
            };
        }

        public void dispatchEntities(boolean sync, TimelineEntity[] entitiesTobePublished, boolean subappwrite) throws YarnException {
            if (this.executor.isShutdown()) {
                throw new YarnException("Timeline client is in the process of stopping, not accepting any more TimelineEntities");
            }
            TimelineEntities entities = new TimelineEntities();
            for (TimelineEntity entity : entitiesTobePublished) {
                entities.addEntity(entity);
            }
            EntitiesHolder entitiesHolder = new EntitiesHolder(entities, sync, subappwrite);
            try {
                this.timelineEntityQueue.put(entitiesHolder);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new YarnException("Failed while adding entity to the queue for publishing", (Throwable)e);
            }
            if (sync) {
                try {
                    entitiesHolder.get();
                }
                catch (ExecutionException e) {
                    throw new YarnException("Failed while publishing entity", e.getCause());
                }
                catch (InterruptedException | CancellationException e) {
                    Thread.currentThread().interrupt();
                    throw new YarnException("Interrupted while publishing entity", (Throwable)e);
                }
                catch (Exception e) {
                    throw new YarnException("Encountered error while publishing entity", (Throwable)e);
                }
            }
        }

        public void start() {
            this.executor = Executors.newSingleThreadExecutor();
            this.executor.execute(this.createRunnable());
        }

        public void stop() {
            LOG.info("Stopping TimelineClient.");
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(this.drainTimeoutPeriod, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace();
            }
        }
    }

    private final class EntitiesHolder
    extends FutureTask<Void> {
        private final TimelineEntities entities;
        private final boolean isSync;

        EntitiesHolder(final TimelineEntities entities, final boolean isSync, final boolean subappwrite) {
            super(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MultivaluedMapImpl params = new MultivaluedMapImpl();
                    params.add((Object)"appid", (Object)TimelineV2ClientImpl.this.getContextAppId().toString());
                    params.add((Object)"async", (Object)Boolean.toString(!isSync));
                    params.add((Object)"subappwrite", (Object)Boolean.toString(subappwrite));
                    TimelineV2ClientImpl.this.putObjects("entities", (MultivaluedMap<String, String>)params, entities);
                    return null;
                }
            });
            this.entities = entities;
            this.isSync = isSync;
        }

        public boolean isSync() {
            return this.isSync;
        }

        public TimelineEntities getEntities() {
            return this.entities;
        }
    }
}

