/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import org.apache.hadoop.shaded.org.xbill.DNS.AAAARecord;
import org.apache.hadoop.shaded.org.xbill.DNS.ARecord;
import org.apache.hadoop.shaded.org.xbill.DNS.IPAddressUtils;
import org.apache.hadoop.shaded.org.xbill.DNS.Lookup;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.PTRRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.ReverseMap;
import org.apache.hadoop.shaded.org.xbill.DNS.TextParseException;

public final class Address {
    public static final int IPv4 = 1;
    public static final int IPv6 = 2;

    public static int[] toArray(String s2, int family) {
        byte[] byteArray = Address.toByteArray(s2, family);
        if (byteArray == null) {
            return null;
        }
        int[] intArray = new int[byteArray.length];
        for (int i = 0; i < byteArray.length; ++i) {
            intArray[i] = byteArray[i] & 0xFF;
        }
        return intArray;
    }

    public static int[] toArray(String s2) {
        return Address.toArray(s2, 1);
    }

    public static byte[] toByteArray(String s2, int family) {
        if (family == 1) {
            return IPAddressUtils.parseV4(s2);
        }
        if (family == 2) {
            return IPAddressUtils.parseV6(s2);
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static boolean isDottedQuad(String s2) {
        byte[] address = Address.toByteArray(s2, 1);
        return address != null;
    }

    public static String toDottedQuad(byte[] addr) {
        return (addr[0] & 0xFF) + "." + (addr[1] & 0xFF) + "." + (addr[2] & 0xFF) + "." + (addr[3] & 0xFF);
    }

    public static String toDottedQuad(int[] addr) {
        return addr[0] + "." + addr[1] + "." + addr[2] + "." + addr[3];
    }

    private static Record[] lookupHostName(String name, boolean all) throws UnknownHostException {
        try {
            Lookup lookup2 = new Lookup(name, 1);
            Record[] a = lookup2.run();
            if (a == null) {
                Record[] aaaa;
                if (lookup2.getResult() == 4 && (aaaa = new Lookup(name, 28).run()) != null) {
                    return aaaa;
                }
                throw new UnknownHostException("<" + name + "> could not be resolved: " + lookup2.getErrorString());
            }
            if (!all) {
                return a;
            }
            Record[] aaaa = new Lookup(name, 28).run();
            if (aaaa == null) {
                return a;
            }
            Record[] merged = new Record[a.length + aaaa.length];
            System.arraycopy(a, 0, merged, 0, a.length);
            System.arraycopy(aaaa, 0, merged, a.length, aaaa.length);
            return merged;
        }
        catch (TextParseException e) {
            throw new UnknownHostException("<" + name + "> is invalid: " + e.getMessage());
        }
    }

    private static InetAddress addrFromRecord(String name, Record r) throws UnknownHostException {
        InetAddress addr = r instanceof ARecord ? ((ARecord)r).getAddress() : ((AAAARecord)r).getAddress();
        return InetAddress.getByAddress(name, addr.getAddress());
    }

    public static InetAddress getByName(String name) throws UnknownHostException {
        try {
            return Address.getByAddress(name);
        }
        catch (UnknownHostException e) {
            Record[] records = Address.lookupHostName(name, false);
            return Address.addrFromRecord(name, records[0]);
        }
    }

    public static InetAddress[] getAllByName(String name) throws UnknownHostException {
        try {
            InetAddress addr = Address.getByAddress(name);
            return new InetAddress[]{addr};
        }
        catch (UnknownHostException e) {
            Record[] records = Address.lookupHostName(name, true);
            InetAddress[] addrs = new InetAddress[records.length];
            for (int i = 0; i < records.length; ++i) {
                addrs[i] = Address.addrFromRecord(name, records[i]);
            }
            return addrs;
        }
    }

    public static InetAddress getByAddress(String addr) throws UnknownHostException {
        byte[] bytes = Address.toByteArray(addr, 1);
        if (bytes != null) {
            return InetAddress.getByAddress(addr, bytes);
        }
        bytes = Address.toByteArray(addr, 2);
        if (bytes != null) {
            return InetAddress.getByAddress(addr, bytes);
        }
        throw new UnknownHostException("Invalid address: " + addr);
    }

    public static InetAddress getByAddress(String addr, int family) throws UnknownHostException {
        if (family != 1 && family != 2) {
            throw new IllegalArgumentException("unknown address family");
        }
        byte[] bytes = Address.toByteArray(addr, family);
        if (bytes != null) {
            return InetAddress.getByAddress(addr, bytes);
        }
        throw new UnknownHostException("Invalid address: " + addr);
    }

    public static String getHostName(InetAddress addr) throws UnknownHostException {
        Name name = ReverseMap.fromAddress(addr);
        Record[] records = new Lookup(name, 12).run();
        if (records == null) {
            throw new UnknownHostException("unknown address: " + name);
        }
        PTRRecord ptr = (PTRRecord)records[0];
        return ptr.getTarget().toString();
    }

    public static int familyOf(InetAddress address) {
        if (address instanceof Inet4Address) {
            return 1;
        }
        if (address instanceof Inet6Address) {
            return 2;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static int addressLength(int family) {
        if (family == 1) {
            return 4;
        }
        if (family == 2) {
            return 16;
        }
        throw new IllegalArgumentException("unknown address family");
    }

    public static InetAddress truncate(InetAddress address, int maskLength) {
        int family = Address.familyOf(address);
        int maxMaskLength = Address.addressLength(family) * 8;
        if (maskLength < 0 || maskLength > maxMaskLength) {
            throw new IllegalArgumentException("invalid mask length");
        }
        if (maskLength == maxMaskLength) {
            return address;
        }
        byte[] bytes = address.getAddress();
        for (int i = maskLength / 8 + 1; i < bytes.length; ++i) {
            bytes[i] = 0;
        }
        int maskBits = maskLength % 8;
        int bitmask = 0;
        for (int i = 0; i < maskBits; ++i) {
            bitmask |= 1 << 7 - i;
        }
        int n = maskLength / 8;
        bytes[n] = (byte)(bytes[n] & (byte)bitmask);
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("invalid address");
        }
    }

    @Generated
    private Address() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

