/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.handlers;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.mapred.RawKeyValueIterator;
import org.apache.hadoop.mapred.nativetask.NativeDataTarget;
import org.apache.hadoop.mapred.nativetask.buffer.ByteBufferDataWriter;
import org.apache.hadoop.mapred.nativetask.buffer.OutputBuffer;
import org.apache.hadoop.mapred.nativetask.handlers.IDataLoader;
import org.apache.hadoop.mapred.nativetask.serde.KVSerializer;
import org.apache.hadoop.mapred.nativetask.util.SizedWritable;

@InterfaceAudience.Private
public class BufferPullee<IK, IV>
implements IDataLoader {
    public static final int KV_HEADER_LENGTH = 8;
    private final SizedWritable<IK> tmpInputKey;
    private final SizedWritable<IV> tmpInputValue;
    private boolean inputKVBufferd = false;
    private RawKeyValueIterator rIter;
    private ByteBufferDataWriter nativeWriter;
    protected KVSerializer<IK, IV> serializer;
    private final OutputBuffer outputBuffer;
    private final NativeDataTarget target;
    private boolean closed = false;

    public BufferPullee(Class<IK> iKClass, Class<IV> iVClass, RawKeyValueIterator rIter, NativeDataTarget target) throws IOException {
        this.rIter = rIter;
        this.tmpInputKey = new SizedWritable(iKClass);
        this.tmpInputValue = new SizedWritable(iVClass);
        if (null != iKClass && null != iVClass) {
            this.serializer = new KVSerializer<IK, IV>(iKClass, iVClass);
        }
        this.outputBuffer = target.getOutputBuffer();
        this.target = target;
    }

    @Override
    public int load() throws IOException {
        if (this.closed) {
            return 0;
        }
        if (null == this.outputBuffer) {
            throw new IOException("output buffer not set");
        }
        this.nativeWriter = new ByteBufferDataWriter(this.target);
        this.outputBuffer.rewind();
        int written = 0;
        boolean firstKV = true;
        if (this.inputKVBufferd) {
            written += this.serializer.serializeKV(this.nativeWriter, this.tmpInputKey, this.tmpInputValue);
            this.inputKVBufferd = false;
            firstKV = false;
        }
        while (this.rIter.next()) {
            this.inputKVBufferd = false;
            this.tmpInputKey.readFields(this.rIter.getKey());
            this.tmpInputValue.readFields(this.rIter.getValue());
            this.serializer.updateLength(this.tmpInputKey, this.tmpInputValue);
            int kvSize = this.tmpInputKey.length + this.tmpInputValue.length + 8;
            if (!firstKV && this.nativeWriter.shortOfSpace(kvSize)) {
                this.inputKVBufferd = true;
                break;
            }
            written += this.serializer.serializeKV(this.nativeWriter, this.tmpInputKey, this.tmpInputValue);
            firstKV = false;
        }
        if (this.nativeWriter.hasUnFlushedData()) {
            this.nativeWriter.flush();
        }
        return written;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        if (null != this.rIter) {
            this.rIter.close();
        }
        if (null != this.nativeWriter) {
            this.nativeWriter.close();
        }
        this.closed = true;
    }
}

