/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.router;

import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.apache.hadoop.hdfs.server.federation.MockResolver;
import org.apache.hadoop.hdfs.server.federation.RouterConfigBuilder;
import org.apache.hadoop.hdfs.server.federation.router.Router;
import org.apache.hadoop.hdfs.server.federation.router.TestRouterFederationRename;
import org.apache.hadoop.tools.fedbalance.DistCpProcedure;

public class TestRouterFederationRenameBase {
    static final int NUM_SUBCLUSTERS = 2;
    static final int NUM_DNS = 6;
    private MiniRouterDFSCluster.RouterContext router;
    private String ns;
    private FileSystem routerFS;
    private FileSystem nnFS;
    private String nnFile;
    private static MiniRouterDFSCluster cluster;

    public static void globalSetUp() throws Exception {
        Configuration namenodeConf = new Configuration();
        namenodeConf.setBoolean("hadoop.caller.context.enabled", true);
        namenodeConf.set("hadoop.security.group.mapping", TestRouterFederationRename.MockGroupsMapping.class.getName());
        cluster = new MiniRouterDFSCluster(false, 2);
        cluster.setNumDatanodesPerNameservice(6);
        cluster.addNamenodeOverrides(namenodeConf);
        cluster.setIndependentDNs();
        Configuration conf = new Configuration();
        conf.setInt("dfs.ls.limit", 5);
        cluster.addNamenodeOverrides(conf);
        cluster.startCluster();
        String journal = "hdfs://" + cluster.getCluster().getNameNode(1).getClientNamenodeAddress() + "/journal";
        Configuration routerConf = new RouterConfigBuilder().metrics().rpc().routerRenameOption().set("hdfs.fedbalance.procedure.scheduler.journal.uri", journal).set("dfs.federation.router.federation.rename.map", "1").set("dfs.federation.router.federation.rename.bandwidth", "1").build();
        routerConf.setTimeDuration("dfs.federation.router.dn-report.cache-expire", 1L, TimeUnit.SECONDS);
        routerConf.setBoolean("dfs.federation.router.admin.enable", true);
        routerConf.setBoolean("dfs.permissions.enabled", true);
        routerConf.set("hadoop.security.group.mapping", TestRouterFederationRename.MockGroupsMapping.class.getName());
        cluster.addRouterOverrides(routerConf);
        cluster.startRouters();
        cluster.registerNamenodes();
        cluster.waitNamenodeRegistration();
        cluster.getCluster().getNamesystem(0).getBlockManager().getDatanodeManager().setHeartbeatInterval(1L);
        cluster.getCluster().getNamesystem(1).getBlockManager().getDatanodeManager().setHeartbeatInterval(1L);
        cluster.getCluster().getNamesystem(0).getBlockManager().getDatanodeManager().setHeartbeatExpireInterval(3000L);
        cluster.getCluster().getNamesystem(1).getBlockManager().getDatanodeManager().setHeartbeatExpireInterval(3000L);
        DistCpProcedure.enableForTest();
    }

    public static void tearDown() {
        cluster.shutdown();
        cluster = null;
        DistCpProcedure.disableForTest();
    }

    protected void setup() throws IOException, InterruptedException {
        cluster.installMockLocations();
        cluster.deleteAllFiles();
        cluster.createTestDirectoriesNamenode();
        MiniRouterDFSCluster.RouterContext rndRouter = cluster.getRandomRouter();
        this.setRouter(rndRouter);
        for (MiniRouterDFSCluster.RouterContext rc : cluster.getRouters()) {
            Router r = rc.getRouter();
            MockResolver resolver = (MockResolver)r.getSubclusterResolver();
            List<String> nss = cluster.getNameservices();
            String ns0 = nss.get(0);
            resolver.addLocation("/same", ns0, "/");
            resolver.addLocation("/same", ns0, cluster.getNamenodePathForNS(ns0));
        }
        String ns0 = cluster.getNameservices().get(0);
        this.setNs(ns0);
        this.setNamenode(cluster.getNamenode(ns0, null));
        Random rnd = new Random();
        String randomFile = "testfile-" + rnd.nextInt();
        this.nnFile = cluster.getNamenodeTestDirectoryForNS(this.ns) + "/" + randomFile;
        FederationTestUtils.createFile(this.nnFS, this.nnFile, 32L);
        FederationTestUtils.verifyFileExists(this.nnFS, this.nnFile);
    }

    protected void setRouter(MiniRouterDFSCluster.RouterContext r) throws IOException {
        this.router = r;
        this.routerFS = r.getFileSystem();
    }

    protected void setNs(String nameservice) {
        this.ns = nameservice;
    }

    protected void setNamenode(MiniRouterDFSCluster.NamenodeContext nn) throws IOException {
        this.nnFS = nn.getFileSystem();
    }

    protected FileSystem getRouterFileSystem() {
        return this.routerFS;
    }

    protected void createDir(FileSystem fs, String dir) throws IOException {
        fs.mkdirs(new Path(dir));
        String file = dir + "/file";
        FederationTestUtils.createFile(fs, file, 32L);
        FederationTestUtils.verifyFileExists(fs, dir);
        FederationTestUtils.verifyFileExists(fs, file);
    }

    public MiniRouterDFSCluster getCluster() {
        return cluster;
    }

    public MiniRouterDFSCluster.RouterContext getRouterContext() {
        return this.router;
    }
}

