/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.bouncycastle.jsse.BCX509ExtendedKeyManager;
import org.bouncycastle.jsse.BCX509ExtendedTrustManager;
import org.bouncycastle.jsse.java.security.BCAlgorithmConstraints;
import org.bouncycastle.jsse.java.security.BCCryptoPrimitive;
import org.bouncycastle.jsse.provider.CipherSuiteInfo;
import org.bouncycastle.jsse.provider.JsseUtils;
import org.bouncycastle.jsse.provider.NamedGroupInfo;
import org.bouncycastle.jsse.provider.ProvSSLContextSpi;
import org.bouncycastle.jsse.provider.ProvSSLParameters;
import org.bouncycastle.jsse.provider.ProvSSLSessionContext;
import org.bouncycastle.jsse.provider.SignatureSchemeInfo;
import org.bouncycastle.tls.ProtocolVersion;
import org.bouncycastle.tls.SignatureAndHashAlgorithm;
import org.bouncycastle.tls.TlsUtils;
import org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ContextData {
    private static final Set<BCCryptoPrimitive> TLS_CRYPTO_PRIMITIVES_BC = JsseUtils.KEY_AGREEMENT_CRYPTO_PRIMITIVES_BC;
    private final boolean fipsMode;
    private final JcaTlsCrypto crypto;
    private final BCX509ExtendedKeyManager x509KeyManager;
    private final BCX509ExtendedTrustManager x509TrustManager;
    private final Map<String, CipherSuiteInfo> supportedCipherSuites;
    private final Map<String, ProtocolVersion> supportedProtocols;
    private final String[] defaultCipherSuitesClient;
    private final String[] defaultCipherSuitesServer;
    private final String[] defaultProtocolsClient;
    private final String[] defaultProtocolsServer;
    private final ProvSSLSessionContext clientSessionContext;
    private final ProvSSLSessionContext serverSessionContext;
    private final NamedGroupInfo.PerContext namedGroups;
    private final SignatureSchemeInfo.PerContext signatureSchemes;

    ContextData(boolean fipsMode, JcaTlsCrypto crypto, BCX509ExtendedKeyManager x509KeyManager, BCX509ExtendedTrustManager x509TrustManager, Map<String, CipherSuiteInfo> supportedCipherSuites, Map<String, ProtocolVersion> supportedProtocols, String[] defaultCipherSuitesClient, String[] defaultCipherSuitesServer, String[] defaultProtocolsClient, String[] defaultProtocolsServer) {
        this.fipsMode = fipsMode;
        this.crypto = crypto;
        this.x509KeyManager = x509KeyManager;
        this.x509TrustManager = x509TrustManager;
        this.supportedCipherSuites = supportedCipherSuites;
        this.supportedProtocols = supportedProtocols;
        this.defaultCipherSuitesClient = defaultCipherSuitesClient;
        this.defaultCipherSuitesServer = defaultCipherSuitesServer;
        this.defaultProtocolsClient = defaultProtocolsClient;
        this.defaultProtocolsServer = defaultProtocolsServer;
        this.clientSessionContext = new ProvSSLSessionContext(this);
        this.serverSessionContext = new ProvSSLSessionContext(this);
        this.namedGroups = NamedGroupInfo.createPerContext(fipsMode, crypto);
        this.signatureSchemes = SignatureSchemeInfo.createPerContext(fipsMode, crypto, this.namedGroups);
    }

    int[] getActiveCipherSuites(JcaTlsCrypto crypto, ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions) {
        String[] enabledCipherSuites = sslParameters.getCipherSuitesArray();
        BCAlgorithmConstraints algorithmConstraints = sslParameters.getAlgorithmConstraints();
        ProtocolVersion latest = ProtocolVersion.getLatestTLS(activeProtocolVersions);
        ProtocolVersion earliest = ProtocolVersion.getEarliestTLS(activeProtocolVersions);
        boolean post13Active = TlsUtils.isTLSv13(latest);
        boolean pre13Active = !TlsUtils.isTLSv13(earliest);
        int[] candidates = new int[enabledCipherSuites.length];
        int count = 0;
        for (String enabledCipherSuite : enabledCipherSuites) {
            CipherSuiteInfo candidate = this.supportedCipherSuites.get(enabledCipherSuite);
            if (null == candidate || (!candidate.isTLSv13() ? !pre13Active : !post13Active) || !algorithmConstraints.permits(TLS_CRYPTO_PRIMITIVES_BC, enabledCipherSuite, null)) continue;
            candidates[count++] = candidate.getCipherSuite();
        }
        int[] result = TlsUtils.getSupportedCipherSuites(crypto, candidates, 0, count);
        if (result.length < 1) {
            throw new IllegalStateException("No usable cipher suites enabled");
        }
        return result;
    }

    ProtocolVersion[] getActiveProtocolVersions(ProvSSLParameters sslParameters) {
        String[] enabledProtocols = sslParameters.getProtocolsArray();
        BCAlgorithmConstraints algorithmConstraints = sslParameters.getAlgorithmConstraints();
        TreeSet<ProtocolVersion> result = new TreeSet<ProtocolVersion>(new Comparator<ProtocolVersion>(){

            @Override
            public int compare(ProtocolVersion o1, ProtocolVersion o2) {
                return o1.isLaterVersionOf(o2) ? -1 : (o2.isLaterVersionOf(o1) ? 1 : 0);
            }
        });
        for (String enabledProtocol : enabledProtocols) {
            ProtocolVersion candidate = this.supportedProtocols.get(enabledProtocol);
            if (null == candidate || !algorithmConstraints.permits(TLS_CRYPTO_PRIMITIVES_BC, enabledProtocol, null)) continue;
            result.add(candidate);
        }
        if (result.isEmpty()) {
            throw new IllegalStateException("No usable protocols enabled");
        }
        return result.toArray(new ProtocolVersion[result.size()]);
    }

    ProvSSLSessionContext getClientSessionContext() {
        return this.clientSessionContext;
    }

    JcaTlsCrypto getCrypto() {
        return this.crypto;
    }

    String[] getDefaultCipherSuites(boolean isClient) {
        return (String[])this.implGetDefaultCipherSuites(isClient).clone();
    }

    String[] getDefaultProtocols(boolean isClient) {
        return (String[])this.implGetDefaultProtocols(isClient).clone();
    }

    ProvSSLParameters getDefaultSSLParameters(boolean isClient) {
        return new ProvSSLParameters(this, this.implGetDefaultCipherSuites(isClient), this.implGetDefaultProtocols(isClient));
    }

    ProvSSLParameters getSupportedSSLParameters(boolean isClient) {
        return new ProvSSLParameters(this, this.getSupportedCipherSuites(), this.getSupportedProtocols());
    }

    NamedGroupInfo.PerConnection getNamedGroupsClient(ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions) {
        return NamedGroupInfo.createPerConnectionClient(this.namedGroups, sslParameters, activeProtocolVersions);
    }

    NamedGroupInfo.PerConnection getNamedGroupsServer(ProvSSLParameters sslParameters, ProtocolVersion negotiatedVersion) {
        return NamedGroupInfo.createPerConnectionServer(this.namedGroups, sslParameters, negotiatedVersion);
    }

    ProvSSLSessionContext getServerSessionContext() {
        return this.serverSessionContext;
    }

    SignatureSchemeInfo.PerConnection getSignatureSchemesClient(ProvSSLParameters sslParameters, ProtocolVersion[] activeProtocolVersions, NamedGroupInfo.PerConnection namedGroups) {
        return SignatureSchemeInfo.createPerConnectionClient(this.signatureSchemes, sslParameters, activeProtocolVersions, namedGroups);
    }

    SignatureSchemeInfo.PerConnection getSignatureSchemesServer(ProvSSLParameters sslParameters, ProtocolVersion negotiatedVersion, NamedGroupInfo.PerConnection namedGroups) {
        return SignatureSchemeInfo.createPerConnectionServer(this.signatureSchemes, sslParameters, negotiatedVersion, namedGroups);
    }

    List<SignatureSchemeInfo> getSignatureSchemes(Vector<SignatureAndHashAlgorithm> sigAndHashAlgs) {
        return SignatureSchemeInfo.getSignatureSchemes(this.signatureSchemes, sigAndHashAlgs);
    }

    String[] getSupportedCipherSuites() {
        return JsseUtils.getKeysArray(this.supportedCipherSuites);
    }

    String[] getSupportedCipherSuites(String[] cipherSuites) {
        if (null == cipherSuites) {
            throw new NullPointerException("'cipherSuites' cannot be null");
        }
        ArrayList<String> result = new ArrayList<String>(cipherSuites.length);
        for (String cipherSuite : cipherSuites) {
            if (TlsUtils.isNullOrEmpty(cipherSuite)) {
                throw new IllegalArgumentException("'cipherSuites' cannot contain null or empty string elements");
            }
            if (!this.supportedCipherSuites.containsKey(cipherSuite)) continue;
            result.add(cipherSuite);
        }
        return JsseUtils.getArray(result);
    }

    String[] getSupportedProtocols() {
        return JsseUtils.getKeysArray(this.supportedProtocols);
    }

    BCX509ExtendedKeyManager getX509KeyManager() {
        return this.x509KeyManager;
    }

    BCX509ExtendedTrustManager getX509TrustManager() {
        return this.x509TrustManager;
    }

    boolean isFipsMode() {
        return this.fipsMode;
    }

    boolean isSupportedProtocols(String[] protocols) {
        if (protocols == null) {
            return false;
        }
        for (String protocol : protocols) {
            if (protocol != null && this.supportedProtocols.containsKey(protocol)) continue;
            return false;
        }
        return true;
    }

    void updateDefaultSSLParameters(ProvSSLParameters sslParameters, boolean isClient) {
        if (sslParameters.getCipherSuitesArray() == this.implGetDefaultCipherSuites(!isClient)) {
            sslParameters.setCipherSuitesArray(this.implGetDefaultCipherSuites(isClient));
        }
        if (sslParameters.getProtocolsArray() == this.implGetDefaultProtocols(!isClient)) {
            sslParameters.setProtocolsArray(this.implGetDefaultProtocols(isClient));
        }
    }

    String validateNegotiatedCipherSuite(ProvSSLParameters sslParameters, int cipherSuite) {
        String name = ProvSSLContextSpi.getCipherSuiteName(cipherSuite);
        if (!(null != name && JsseUtils.contains(sslParameters.getCipherSuitesArray(), name) && sslParameters.getAlgorithmConstraints().permits(TLS_CRYPTO_PRIMITIVES_BC, name, null) && this.supportedCipherSuites.containsKey(name))) {
            throw new IllegalStateException("SSL connection negotiated unsupported ciphersuite: " + cipherSuite);
        }
        return name;
    }

    String validateNegotiatedProtocol(ProvSSLParameters sslParameters, ProtocolVersion protocol) {
        String name = ProvSSLContextSpi.getProtocolVersionName(protocol);
        if (!(null != name && JsseUtils.contains(sslParameters.getProtocolsArray(), name) && sslParameters.getAlgorithmConstraints().permits(TLS_CRYPTO_PRIMITIVES_BC, name, null) && this.supportedProtocols.containsKey(name))) {
            throw new IllegalStateException("SSL connection negotiated unsupported protocol: " + String.valueOf(protocol));
        }
        return name;
    }

    private String[] implGetDefaultCipherSuites(boolean isClient) {
        return isClient ? this.defaultCipherSuitesClient : this.defaultCipherSuitesServer;
    }

    private String[] implGetDefaultProtocols(boolean isClient) {
        return isClient ? this.defaultProtocolsClient : this.defaultProtocolsServer;
    }
}

