/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.net.InetAddress;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NMAuditLogger {
    private static final Logger LOG = LoggerFactory.getLogger(NMAuditLogger.class);

    static String createSuccessLog(String user, String operation, String target, ApplicationId appId, ContainerId containerId) {
        StringBuilder b = new StringBuilder();
        NMAuditLogger.start(Keys.USER, user, b);
        NMAuditLogger.addRemoteIP(b);
        NMAuditLogger.add(Keys.OPERATION, operation, b);
        NMAuditLogger.add(Keys.TARGET, target, b);
        NMAuditLogger.add(Keys.RESULT, "SUCCESS", b);
        if (appId != null) {
            NMAuditLogger.add(Keys.APPID, appId.toString(), b);
        }
        if (containerId != null) {
            NMAuditLogger.add(Keys.CONTAINERID, containerId.toString(), b);
        }
        return b.toString();
    }

    public static void logSuccess(String user, String operation, String target, ApplicationId appId, ContainerId containerId) {
        if (LOG.isInfoEnabled()) {
            LOG.info(NMAuditLogger.createSuccessLog(user, operation, target, appId, containerId));
        }
    }

    public static void logSuccess(String user, String operation, String target) {
        if (LOG.isInfoEnabled()) {
            LOG.info(NMAuditLogger.createSuccessLog(user, operation, target, null, null));
        }
    }

    static String createFailureLog(String user, String operation, String target, String description, ApplicationId appId, ContainerId containerId) {
        StringBuilder b = new StringBuilder();
        NMAuditLogger.start(Keys.USER, user, b);
        NMAuditLogger.addRemoteIP(b);
        NMAuditLogger.add(Keys.OPERATION, operation, b);
        NMAuditLogger.add(Keys.TARGET, target, b);
        NMAuditLogger.add(Keys.RESULT, "FAILURE", b);
        NMAuditLogger.add(Keys.DESCRIPTION, description, b);
        if (appId != null) {
            NMAuditLogger.add(Keys.APPID, appId.toString(), b);
        }
        if (containerId != null) {
            NMAuditLogger.add(Keys.CONTAINERID, containerId.toString(), b);
        }
        return b.toString();
    }

    public static void logFailure(String user, String operation, String target, String description, ApplicationId appId, ContainerId containerId) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(NMAuditLogger.createFailureLog(user, operation, target, description, appId, containerId));
        }
    }

    public static void logFailure(String user, String operation, String target, String description) {
        if (LOG.isWarnEnabled()) {
            LOG.warn(NMAuditLogger.createFailureLog(user, operation, target, description, null, null));
        }
    }

    static void addRemoteIP(StringBuilder b) {
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            NMAuditLogger.add(Keys.IP, ip.getHostAddress(), b);
        }
    }

    static void start(Keys key, String value, StringBuilder b) {
        b.append(key.name()).append("=").append(value);
    }

    static void add(Keys key, String value, StringBuilder b) {
        b.append('\t').append(key.name()).append("=").append(value);
    }

    public static class AuditConstants {
        static final String SUCCESS = "SUCCESS";
        static final String FAILURE = "FAILURE";
        static final String KEY_VAL_SEPARATOR = "=";
        static final char PAIR_SEPARATOR = '\t';
        public static final String START_CONTAINER = "Start Container Request";
        public static final String STOP_CONTAINER = "Stop Container Request";
        public static final String START_CONTAINER_REINIT = "Container ReInitialization - Started";
        public static final String FINISH_CONTAINER_REINIT = "Container ReInitialization - Finished";
        public static final String FINISH_SUCCESS_CONTAINER = "Container Finished - Succeeded";
        public static final String FINISH_FAILED_CONTAINER = "Container Finished - Failed";
        public static final String FINISH_KILLED_CONTAINER = "Container Finished - Killed";
    }

    static enum Keys {
        USER,
        OPERATION,
        TARGET,
        RESULT,
        IP,
        DESCRIPTION,
        APPID,
        CONTAINERID;

    }
}

