/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import java.io.File;
import java.io.IOException;
import java.security.Security;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.collections.SetUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.sls.AMRunner;
import org.apache.hadoop.yarn.sls.NMRunner;
import org.apache.hadoop.yarn.sls.RMRunner;
import org.apache.hadoop.yarn.sls.appmaster.AMSimulator;
import org.apache.hadoop.yarn.sls.nodemanager.NMSimulator;
import org.apache.hadoop.yarn.sls.scheduler.SchedulerWrapper;
import org.apache.hadoop.yarn.sls.scheduler.TaskRunner;
import org.apache.hadoop.yarn.sls.scheduler.Tracker;
import org.apache.hadoop.yarn.sls.synthetic.SynthTraceJobProducer;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SLSRunner
extends Configured
implements Tool {
    private static final TaskRunner runner = new TaskRunner();
    private String[] inputTraces;
    private boolean printSimulation;
    private static final Map<String, Object> simulateInfoMap = new HashMap<String, Object>();
    public static final Logger LOG = LoggerFactory.getLogger(SLSRunner.class);
    private static boolean exitAtTheFinish = false;
    private AMRunner amRunner;
    private RMRunner rmRunner;
    private NMRunner nmRunner;
    private TraceType inputType;
    private SynthTraceJobProducer stjp;
    public static final String NETWORK_CACHE_TTL = "networkaddress.cache.ttl";
    public static final String NETWORK_NEGATIVE_CACHE_TTL = "networkaddress.cache.negative.ttl";

    public int getRemainingApps() {
        return this.amRunner.remainingApps;
    }

    public SLSRunner() throws ClassNotFoundException, YarnException {
        Configuration tempConf = new Configuration(false);
        this.init(tempConf);
    }

    public SLSRunner(Configuration tempConf) throws ClassNotFoundException, YarnException {
        this.init(tempConf);
    }

    public void setConf(Configuration conf) {
        if (null != conf) {
            conf.addResource("sls-runner.xml");
        }
        super.setConf(conf);
    }

    private void init(Configuration tempConf) throws ClassNotFoundException, YarnException {
        this.setConf(tempConf);
        int poolSize = tempConf.getInt("yarn.sls.runner.pool.size", 10);
        runner.setQueueSize(poolSize);
        this.rmRunner = new RMRunner(this.getConf(), this);
        this.nmRunner = new NMRunner(runner, this.getConf(), this.rmRunner.getRm(), this.rmRunner.getTableMapping(), poolSize);
        this.amRunner = new AMRunner(runner, this);
        this.amRunner.init(tempConf);
    }

    private SynthTraceJobProducer getSynthJobTraceProducer() throws YarnException {
        if (this.nmRunner.getStjp() != null) {
            return this.nmRunner.getStjp();
        }
        try {
            return new SynthTraceJobProducer(this.getConf(), new Path(this.inputTraces[0]));
        }
        catch (IOException e) {
            throw new YarnException("Failed to initialize SynthTraceJobProducer", (Throwable)e);
        }
    }

    public static Map<String, Object> getSimulateInfoMap() {
        return Collections.unmodifiableMap(simulateInfoMap);
    }

    public void setSimulationParams(TraceType inputType, String[] inTraces, String nodes, String metricsOutputDir, Set<String> trackApps, boolean printSimulation) throws YarnException {
        this.inputType = inputType;
        this.inputTraces = (String[])inTraces.clone();
        this.amRunner.setInputType(inputType);
        this.amRunner.setInputTraces(this.inputTraces);
        this.amRunner.setTrackedApps(trackApps);
        this.nmRunner.setNodeFile(nodes);
        this.nmRunner.setInputType(inputType);
        this.nmRunner.setInputTraces(this.inputTraces);
        this.printSimulation = printSimulation;
        this.rmRunner.setMetricsOutputDir(metricsOutputDir);
        String tableMapping = metricsOutputDir + "/tableMapping.csv";
        this.rmRunner.setTableMapping(tableMapping);
        this.nmRunner.setTableMapping(tableMapping);
        if (inputType == TraceType.SYNTH) {
            this.stjp = this.getSynthJobTraceProducer();
        }
    }

    public void start() throws IOException, ClassNotFoundException, YarnException, InterruptedException {
        SLSRunner.enableDNSCaching(this.getConf());
        this.rmRunner.startRM();
        this.nmRunner.setRm(this.rmRunner.getRm());
        this.amRunner.setResourceManager(this.rmRunner.getRm());
        this.nmRunner.startNM();
        this.amRunner.startAM();
        SchedulerWrapper resourceScheduler = (SchedulerWrapper)this.rmRunner.getRm().getResourceScheduler();
        resourceScheduler.setSLSRunner(this);
        Tracker tracker = resourceScheduler.getTracker();
        tracker.setQueueSet(this.rmRunner.getQueueAppNumMap().keySet());
        tracker.setTrackedAppSet(this.amRunner.getTrackedApps());
        this.printSimulationInfo();
        this.nmRunner.waitForNodesRunning();
        runner.start();
    }

    static void enableDNSCaching(Configuration conf) {
        if (conf.getBoolean("yarn.sls.dns.caching.enabled", false)) {
            Security.setProperty(NETWORK_CACHE_TTL, "-1");
            Security.setProperty(NETWORK_NEGATIVE_CACHE_TTL, "-1");
        }
    }

    Resource getDefaultContainerResource() {
        int containerMemory = this.getConf().getInt("yarn.sls.container.memory.mb", 1024);
        int containerVCores = this.getConf().getInt("yarn.sls.container.vcores", 1);
        return Resources.createResource((int)containerMemory, (int)containerVCores);
    }

    public void increaseQueueAppNum(String queue) throws YarnException {
        this.rmRunner.increaseQueueAppNum(queue);
    }

    private void printSimulationInfo() {
        int numAMs = this.amRunner.getNumAMs();
        int numTasks = this.amRunner.getNumTasks();
        long maxRuntime = this.amRunner.getMaxRuntime();
        Map<String, AMSimulator> amMap = this.amRunner.getAmMap();
        Map<String, Integer> queueAppNumMap = this.rmRunner.getQueueAppNumMap();
        if (this.printSimulation) {
            LOG.info("------------------------------------");
            LOG.info("# nodes = {}, # racks = {}, capacity of each node {}.", new Object[]{this.nmRunner.getNumNMs(), this.nmRunner.getNumRacks(), this.nmRunner.getNodeManagerResource()});
            LOG.info("------------------------------------");
            LOG.info("# applications = {}, # total tasks = {}, average # tasks per application = {}", new Object[]{numAMs, numTasks, (int)Math.ceil(((double)numTasks + 0.0) / (double)numAMs)});
            LOG.info("JobId\tQueue\tAMType\tDuration\t#Tasks");
            for (Map.Entry<String, AMSimulator> entry : amMap.entrySet()) {
                AMSimulator am = entry.getValue();
                LOG.info(entry.getKey() + "\t" + am.getQueue() + "\t" + am.getAMType() + "\t" + am.getDuration() + "\t" + am.getNumTasks());
            }
            LOG.info("------------------------------------");
            LOG.info("number of queues = {}  average number of apps = {}", (Object)queueAppNumMap.size(), (Object)((int)Math.ceil(((double)numAMs + 0.0) / (double)queueAppNumMap.size())));
            LOG.info("------------------------------------");
            LOG.info("estimated simulation time is {} seconds", (Object)((long)Math.ceil((double)maxRuntime / 1000.0)));
            LOG.info("------------------------------------");
        }
        simulateInfoMap.put("Number of racks", this.nmRunner.getNumRacks());
        simulateInfoMap.put("Number of nodes", this.nmRunner.getNumNMs());
        simulateInfoMap.put("Node memory (MB)", this.nmRunner.getNodeManagerResource().getResourceValue("memory-mb"));
        simulateInfoMap.put("Node VCores", this.nmRunner.getNodeManagerResource().getResourceValue("vcores"));
        simulateInfoMap.put("Number of applications", numAMs);
        simulateInfoMap.put("Number of tasks", numTasks);
        simulateInfoMap.put("Average tasks per applicaion", (int)Math.ceil(((double)numTasks + 0.0) / (double)numAMs));
        simulateInfoMap.put("Number of queues", queueAppNumMap.size());
        simulateInfoMap.put("Average applications per queue", (int)Math.ceil(((double)numAMs + 0.0) / (double)queueAppNumMap.size()));
        simulateInfoMap.put("Estimated simulate time (s)", (long)Math.ceil((double)maxRuntime / 1000.0));
    }

    public Map<NodeId, NMSimulator> getNmMap() {
        return this.nmRunner.getNmMap();
    }

    public void decreaseRemainingApps() {
        --this.amRunner.remainingApps;
        if (this.amRunner.remainingApps == 0) {
            SLSRunner.exitSLSRunner();
        }
    }

    public static void exitSLSRunner() {
        LOG.info("SLSRunner tears down.");
        if (exitAtTheFinish) {
            System.exit(0);
        }
    }

    public void stop() throws InterruptedException {
        this.rmRunner.stop();
        runner.stop();
    }

    public int run(String[] argv) throws IOException, InterruptedException, ParseException, ClassNotFoundException, YarnException {
        Options options = new Options();
        options.addOption("inputrumen", true, "input rumen files");
        options.addOption("inputsls", true, "input sls files");
        options.addOption("tracetype", true, "the type of trace");
        options.addOption("tracelocation", true, "input trace files");
        options.addOption("nodes", true, "input topology");
        options.addOption("output", true, "output directory");
        options.addOption("trackjobs", true, "jobs to be tracked during simulating");
        options.addOption("printsimulation", false, "print out simulation information");
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, argv);
        boolean hasInputRumenOption = cmd.hasOption("inputrumen");
        boolean hasInputSlsOption = cmd.hasOption("inputsls");
        boolean hasTraceTypeOption = cmd.hasOption("tracetype");
        TraceType traceType = this.determineTraceType(cmd, hasInputRumenOption, hasInputSlsOption, hasTraceTypeOption);
        String traceLocation = this.determineTraceLocation(cmd, hasInputRumenOption, hasInputSlsOption, hasTraceTypeOption);
        String output = cmd.getOptionValue("output");
        File outputFile = new File(output);
        if (!outputFile.exists() && !outputFile.mkdirs()) {
            System.err.println("ERROR: Cannot create output directory " + outputFile.getAbsolutePath());
            throw new YarnException("Cannot create output directory");
        }
        HashSet<String> trackedJobSet = new HashSet<String>();
        if (cmd.hasOption("trackjobs")) {
            String trackjobs = cmd.getOptionValue("trackjobs");
            String[] jobIds = trackjobs.split(",");
            trackedJobSet.addAll(Arrays.asList(jobIds));
        }
        String tempNodeFile = cmd.hasOption("nodes") ? cmd.getOptionValue("nodes") : "";
        String[] inputFiles = traceLocation.split(",");
        this.setSimulationParams(traceType, inputFiles, tempNodeFile, output, trackedJobSet, cmd.hasOption("printsimulation"));
        this.start();
        return 0;
    }

    private TraceType determineTraceType(CommandLine cmd, boolean hasInputRumenOption, boolean hasInputSlsOption, boolean hasTraceTypeOption) throws YarnException {
        String traceType = null;
        if (hasInputRumenOption) {
            traceType = "RUMEN";
        }
        if (hasInputSlsOption) {
            traceType = "SLS";
        }
        if (hasTraceTypeOption) {
            traceType = cmd.getOptionValue("tracetype");
        }
        if (traceType == null) {
            throw new YarnException("Misconfigured input");
        }
        switch (traceType) {
            case "SLS": {
                return TraceType.SLS;
            }
            case "RUMEN": {
                return TraceType.RUMEN;
            }
            case "SYNTH": {
                return TraceType.SYNTH;
            }
        }
        SLSRunner.printUsage();
        throw new YarnException("Misconfigured input");
    }

    private String determineTraceLocation(CommandLine cmd, boolean hasInputRumenOption, boolean hasInputSlsOption, boolean hasTraceTypeOption) throws YarnException {
        if (hasInputRumenOption) {
            return cmd.getOptionValue("inputrumen");
        }
        if (hasInputSlsOption) {
            return cmd.getOptionValue("inputsls");
        }
        if (hasTraceTypeOption) {
            return cmd.getOptionValue("tracelocation");
        }
        throw new YarnException("Misconfigured input! ");
    }

    public static void main(String[] argv) throws Exception {
        exitAtTheFinish = true;
        ToolRunner.run((Configuration)new Configuration(), (Tool)new SLSRunner(), (String[])argv);
    }

    static void printUsage() {
        System.err.println();
        System.err.println("ERROR: Wrong tracetype");
        System.err.println();
        System.err.println("Options: -tracetype SLS|RUMEN|SYNTH -tracelocation FILE,FILE... (deprecated alternative options --inputsls FILE, FILE,...  | --inputrumen FILE,FILE,...)-output FILE [-nodes FILE] [-trackjobs JobId,JobId...] [-printsimulation]");
        System.err.println();
    }

    public SynthTraceJobProducer getStjp() {
        return this.stjp;
    }

    public void setStjp(SynthTraceJobProducer stjp) {
        this.stjp = stjp;
    }

    public AMSimulator getAMSimulatorByAppId(ApplicationId appId) {
        return this.amRunner.getAMSimulator(appId);
    }

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static class NodeDetails {
        private String hostname;
        private Resource nodeResource;
        private Set<NodeLabel> labels;

        public NodeDetails(String nodeHostname) {
            this.hostname = nodeHostname;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public Resource getNodeResource() {
            return this.nodeResource;
        }

        public void setNodeResource(Resource nodeResource) {
            this.nodeResource = nodeResource;
        }

        public Set<NodeLabel> getLabels() {
            return this.labels;
        }

        public void setLabels(Set<NodeLabel> labels) {
            this.labels = labels;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeDetails)) {
                return false;
            }
            NodeDetails that = (NodeDetails)o;
            return StringUtils.equals((CharSequence)this.hostname, (CharSequence)that.hostname) && Objects.equals(this.nodeResource, that.nodeResource) && SetUtils.isEqualSet(this.labels, that.labels);
        }

        public int hashCode() {
            int result = this.hostname == null ? 0 : this.hostname.hashCode();
            result = 31 * result + (this.nodeResource == null ? 0 : this.nodeResource.hashCode());
            result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
            return result;
        }
    }

    public static enum TraceType {
        SLS,
        RUMEN,
        SYNTH;

    }
}

